/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_13.helpers;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.interfaces.PacketHelper;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.JNBTListTag;
import com.denizenscript.denizen.nms.util.jnbt.Tag;
import com.denizenscript.denizen.nms.v1_13.impl.jnbt.CompoundTagImpl;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.server.v1_13_R2.Block;
import net.minecraft.server.v1_13_R2.BlockPosition;
import net.minecraft.server.v1_13_R2.ChatComponentText;
import net.minecraft.server.v1_13_R2.DataWatcher;
import net.minecraft.server.v1_13_R2.DataWatcherRegistry;
import net.minecraft.server.v1_13_R2.Entity;
import net.minecraft.server.v1_13_R2.EntityCreeper;
import net.minecraft.server.v1_13_R2.EntityEnderman;
import net.minecraft.server.v1_13_R2.EntityHuman;
import net.minecraft.server.v1_13_R2.EntityLiving;
import net.minecraft.server.v1_13_R2.EntitySpider;
import net.minecraft.server.v1_13_R2.EnumHand;
import net.minecraft.server.v1_13_R2.IChatBaseComponent;
import net.minecraft.server.v1_13_R2.Packet;
import net.minecraft.server.v1_13_R2.PacketDataSerializer;
import net.minecraft.server.v1_13_R2.PacketPlayInClientCommand;
import net.minecraft.server.v1_13_R2.PacketPlayOutAbilities;
import net.minecraft.server.v1_13_R2.PacketPlayOutBlockAction;
import net.minecraft.server.v1_13_R2.PacketPlayOutBlockBreakAnimation;
import net.minecraft.server.v1_13_R2.PacketPlayOutCamera;
import net.minecraft.server.v1_13_R2.PacketPlayOutCustomPayload;
import net.minecraft.server.v1_13_R2.PacketPlayOutEntityEquipment;
import net.minecraft.server.v1_13_R2.PacketPlayOutEntityMetadata;
import net.minecraft.server.v1_13_R2.PacketPlayOutExperience;
import net.minecraft.server.v1_13_R2.PacketPlayOutGameStateChange;
import net.minecraft.server.v1_13_R2.PacketPlayOutOpenSignEditor;
import net.minecraft.server.v1_13_R2.PacketPlayOutPlayerListHeaderFooter;
import net.minecraft.server.v1_13_R2.PacketPlayOutSetSlot;
import net.minecraft.server.v1_13_R2.PacketPlayOutSpawnEntityLiving;
import net.minecraft.server.v1_13_R2.PacketPlayOutTileEntityData;
import net.minecraft.server.v1_13_R2.PacketPlayOutTitle;
import net.minecraft.server.v1_13_R2.PacketPlayOutUpdateHealth;
import net.minecraft.server.v1_13_R2.PacketPlayOutWorldBorder;
import net.minecraft.server.v1_13_R2.TileEntity;
import net.minecraft.server.v1_13_R2.TileEntitySign;
import net.minecraft.server.v1_13_R2.World;
import net.minecraft.server.v1_13_R2.WorldBorder;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.block.banner.Pattern;
import org.bukkit.craftbukkit.v1_13_R2.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_13_R2.CraftServer;
import org.bukkit.craftbukkit.v1_13_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_13_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_13_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_13_R2.inventory.CraftItemStack;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class PacketHelperImpl
implements PacketHelper {
    public void setFakeAbsorption(Player player, float value) {
        DataWatcher dw = new DataWatcher(null);
        dw.register(DataWatcherRegistry.c.a(11), (Object)Float.valueOf(value));
        PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutEntityMetadata(player.getEntityId(), dw, true));
    }

    public void resetWorldBorder(Player player) {
        WorldBorder wb = ((CraftWorld)player.getWorld()).getHandle().getWorldBorder();
        PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutWorldBorder(wb, PacketPlayOutWorldBorder.EnumWorldBorderAction.INITIALIZE));
    }

    public void setWorldBorder(Player player, Location center, double size, double currSize, long time, int warningDistance, int warningTime) {
        WorldBorder wb = new WorldBorder();
        wb.world = ((CraftWorld)player.getWorld()).getHandle();
        wb.setCenter(center.getX(), center.getZ());
        wb.setWarningDistance(warningDistance);
        wb.setWarningTime(warningTime);
        if (time > 0L) {
            wb.transitionSizeBetween(currSize, size, time);
        } else {
            wb.setSize(size);
        }
        PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutWorldBorder(wb, PacketPlayOutWorldBorder.EnumWorldBorderAction.INITIALIZE));
    }

    public void setSlot(Player player, int slot, ItemStack itemStack, boolean playerOnly) {
        int windowId = playerOnly ? 0 : ((CraftPlayer)player).getHandle().activeContainer.windowId;
        PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutSetSlot(windowId, slot, CraftItemStack.asNMSCopy((ItemStack)itemStack)));
    }

    public void setFieldOfView(Player player, float fov) {
        PacketPlayOutAbilities packet = new PacketPlayOutAbilities(((CraftPlayer)player).getHandle().abilities);
        if (!Float.isNaN(fov)) {
            packet.b(fov);
        }
        PacketHelperImpl.sendPacket(player, (Packet)packet);
    }

    public void respawn(Player player) {
        ((CraftPlayer)player).getHandle().playerConnection.a(new PacketPlayInClientCommand(PacketPlayInClientCommand.EnumClientCommand.PERFORM_RESPAWN));
    }

    public void setVision(Player player, EntityType entityType) {
        EntityCreeper entity;
        if (entityType == EntityType.CREEPER) {
            entity = new EntityCreeper((World)((CraftWorld)player.getWorld()).getHandle());
        } else if (entityType == EntityType.SPIDER || entityType == EntityType.CAVE_SPIDER) {
            entity = new EntitySpider((World)((CraftWorld)player.getWorld()).getHandle());
        } else if (entityType == EntityType.ENDERMAN) {
            entity = new EntityEnderman((World)((CraftWorld)player.getWorld()).getHandle());
        } else {
            return;
        }
        PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutSpawnEntityLiving((EntityLiving)entity));
        PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutCamera((Entity)entity));
        ((CraftServer)Bukkit.getServer()).getHandle().moveToWorld(((CraftPlayer)player).getHandle(), ((CraftWorld)player.getWorld()).getHandle().dimension, true, player.getLocation(), false);
    }

    public void showDemoScreen(Player player) {
        PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutGameStateChange(5, 0.0f));
    }

    public void showBlockAction(Player player, Location location, int action, int state) {
        BlockPosition position = new BlockPosition(location.getX(), location.getY(), location.getZ());
        Block block = ((CraftWorld)location.getWorld()).getHandle().getType(position).getBlock();
        PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutBlockAction(position, block, action, state));
    }

    public void showBlockCrack(Player player, int id, Location location, int progress) {
        BlockPosition position = new BlockPosition(location.getX(), location.getY(), location.getZ());
        PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutBlockBreakAnimation(id, position, progress));
    }

    public void showTileEntityData(Player player, Location location, int action, CompoundTag compoundTag) {
        BlockPosition position = new BlockPosition(location.getX(), location.getY(), location.getZ());
        PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutTileEntityData(position, action, ((CompoundTagImpl)compoundTag).toNMSTag()));
    }

    public void showBannerUpdate(Player player, Location location, DyeColor base, List<Pattern> patterns) {
        ArrayList<CompoundTag> nbtPatterns = new ArrayList<CompoundTag>();
        for (Pattern pattern : patterns) {
            nbtPatterns.add(NMSHandler.getInstance().createCompoundTag(new HashMap()).createBuilder().putInt("Color", (int)pattern.getColor().getDyeData()).putString("Pattern", pattern.getPattern().getIdentifier()).build());
        }
        CompoundTag compoundTag = NMSHandler.getBlockHelper().getNbtData(location.getBlock()).createBuilder().putInt("Base", (int)base.getDyeData()).put("Patterns", (Tag)new JNBTListTag(CompoundTag.class, nbtPatterns)).build();
        this.showTileEntityData(player, location, 3, compoundTag);
    }

    public void showTabListHeaderFooter(Player player, String header, String footer) {
        PacketPlayOutPlayerListHeaderFooter packet = new PacketPlayOutPlayerListHeaderFooter();
        packet.header = new ChatComponentText(header);
        packet.footer = new ChatComponentText(footer);
        PacketHelperImpl.sendPacket(player, (Packet)packet);
    }

    public void resetTabListHeaderFooter(Player player) {
        this.showTabListHeaderFooter(player, "", "");
    }

    public void showTitle(Player player, String title, String subtitle, int fadeInTicks, int stayTicks, int fadeOutTicks) {
        PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutTitle(fadeInTicks, stayTicks, fadeOutTicks));
        if (title != null) {
            PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutTitle(PacketPlayOutTitle.EnumTitleAction.TITLE, (IChatBaseComponent)new ChatComponentText(title)));
        }
        if (subtitle != null) {
            PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutTitle(PacketPlayOutTitle.EnumTitleAction.SUBTITLE, (IChatBaseComponent)new ChatComponentText(subtitle)));
        }
    }

    public void showEquipment(Player player, LivingEntity entity, EquipmentSlot equipmentSlot, ItemStack itemStack) {
        PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutEntityEquipment(entity.getEntityId(), CraftEquipmentSlot.getNMS((EquipmentSlot)equipmentSlot), CraftItemStack.asNMSCopy((ItemStack)itemStack)));
    }

    public void resetEquipment(Player player, LivingEntity entity) {
        EntityEquipment equipment = entity.getEquipment();
        this.showEquipment(player, entity, EquipmentSlot.HAND, equipment.getItemInMainHand());
        this.showEquipment(player, entity, EquipmentSlot.OFF_HAND, equipment.getItemInOffHand());
        this.showEquipment(player, entity, EquipmentSlot.HEAD, equipment.getHelmet());
        this.showEquipment(player, entity, EquipmentSlot.CHEST, equipment.getChestplate());
        this.showEquipment(player, entity, EquipmentSlot.LEGS, equipment.getLeggings());
        this.showEquipment(player, entity, EquipmentSlot.FEET, equipment.getBoots());
    }

    public void openBook(Player player, EquipmentSlot hand) {
        PacketDataSerializer serializer = new PacketDataSerializer(Unpooled.buffer());
        serializer.a((Enum)(hand == EquipmentSlot.OFF_HAND ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND));
        PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutCustomPayload(PacketPlayOutCustomPayload.c, serializer));
    }

    public void showHealth(Player player, float health, int food, float saturation) {
        PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutUpdateHealth(health, food, saturation));
    }

    public void resetHealth(Player player) {
        this.showHealth(player, (float)player.getHealth(), player.getFoodLevel(), player.getSaturation());
    }

    public void showExperience(Player player, float experience, int level) {
        PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutExperience(experience, 0, level));
    }

    public void resetExperience(Player player) {
        this.showExperience(player, player.getExp(), player.getLevel());
    }

    public boolean showSignEditor(Player player, Location location) {
        TileEntity tileEntity = ((CraftWorld)location.getWorld()).getHandle().getTileEntity(new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ()));
        if (tileEntity instanceof TileEntitySign) {
            TileEntitySign sign = (TileEntitySign)tileEntity;
            PacketHelperImpl.sendPacket(player, (Packet)sign.getUpdatePacket());
            sign.isEditable = true;
            sign.a((EntityHuman)((CraftPlayer)player).getHandle());
            PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutOpenSignEditor(sign.getPosition()));
            return true;
        }
        return false;
    }

    public void forceSpectate(Player player, org.bukkit.entity.Entity entity) {
        PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutCamera(((CraftEntity)entity).getHandle()));
    }

    public static void sendPacket(Player player, Packet packet) {
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket(packet);
    }
}

