/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerFishEvent;

public class PlayerFishesScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerFishesScriptEvent instance;
    public EntityTag hook;
    public ElementTag state;
    public EntityTag entity;
    public ItemTag item;
    public PlayerFishEvent event;

    public PlayerFishesScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventLower.startsWith("player fishes");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String fish = path.eventArgLowerAt(2);
        if (!(fish.isEmpty() || fish.equals("in") || fish.equals("while"))) {
            if (this.entity == null) {
                return false;
            }
            if (!this.tryEntity(this.entity, fish)) {
                if (this.item == null) {
                    return false;
                }
                if (!this.tryItem(this.item, fish)) {
                    return false;
                }
            }
        }
        String[] data = path.eventArgsLower;
        for (int index = 2; index < data.length; ++index) {
            if (!data[index].equals("while") || data[index + 1].equalsIgnoreCase(this.state.asString())) continue;
            return false;
        }
        if (!this.runInCheck(path, this.hook.getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String determination;
        if (!PlayerFishesScriptEvent.isDefaultDetermination(determinationObj) && determinationObj instanceof ElementTag && CoreUtilities.toLowerCase(determination = determinationObj.toString()).startsWith("caught:")) {
            this.item = ItemTag.valueOf(determination.substring("caught:".length()));
            if (this.entity != null && this.entity.getBukkitEntityType() == EntityType.DROPPED_ITEM) {
                ((Item)this.entity.getBukkitEntity()).setItemStack(this.item.getItemStack());
                return true;
            }
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public String getName() {
        return "PlayerFishes";
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(EntityTag.isPlayer((Entity)this.event.getPlayer()) ? EntityTag.getPlayerFrom((Entity)this.event.getPlayer()) : (EntityTag.isPlayer(this.event.getCaught()) ? EntityTag.getPlayerFrom(this.event.getCaught()) : null), EntityTag.isCitizensNPC((Entity)this.event.getPlayer()) ? EntityTag.getNPCFrom((Entity)this.event.getPlayer()) : (EntityTag.isCitizensNPC(this.event.getCaught()) ? EntityTag.getNPCFrom(this.event.getCaught()) : null));
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("hook")) {
            return this.hook;
        }
        if (name.equals("entity") && this.entity != null) {
            return this.entity.getDenizenObject();
        }
        if (name.equals("item") && this.item != null) {
            return this.item;
        }
        if (name.equals("state")) {
            return this.state;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPlayerFishes(PlayerFishEvent event) {
        if (EntityTag.isNPC((Entity)event.getPlayer())) {
            return;
        }
        Entity hookEntity = NMSHandler.getEntityHelper().getFishHook(event);
        EntityTag.rememberEntity(hookEntity);
        this.hook = new EntityTag(hookEntity);
        this.state = new ElementTag(event.getState().toString());
        this.item = null;
        this.entity = null;
        Entity caughtEntity = event.getCaught();
        if (caughtEntity != null) {
            EntityTag.rememberEntity(caughtEntity);
            this.entity = new EntityTag(caughtEntity);
            if (caughtEntity instanceof Item) {
                this.item = new ItemTag(((Item)caughtEntity).getItemStack());
            }
        }
        this.event = event;
        this.fire((Event)event);
        EntityTag.forgetEntity(hookEntity);
        EntityTag.forgetEntity(caughtEntity);
    }
}

