/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;

public class PlayerReceivesMessageScriptEvent
extends BukkitScriptEvent {
    public static PlayerReceivesMessageScriptEvent instance;
    public ElementTag message;
    public ElementTag rawJson;
    public ElementTag system;
    public PlayerTag player;
    public boolean messageModified;
    public boolean rawJsonModified;
    public boolean loaded;

    public PlayerReceivesMessageScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventLower.startsWith("player receives message");
    }

    @Override
    public String getName() {
        return "PlayerReceivesMessage";
    }

    @Override
    public void init() {
        this.loaded = true;
    }

    @Override
    public void destroy() {
        this.loaded = false;
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        if (determinationObj instanceof ElementTag && !PlayerReceivesMessageScriptEvent.isDefaultDetermination(determinationObj)) {
            String determination = determinationObj.toString();
            String lower = CoreUtilities.toLowerCase(determination);
            if (lower.startsWith("message:")) {
                this.message = new ElementTag(determination.substring("message:".length()));
                this.messageModified = true;
                return true;
            }
            if (lower.startsWith("raw_json:")) {
                this.rawJson = new ElementTag(determination.substring("raw_json:".length()));
                this.rawJsonModified = true;
                return true;
            }
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.player, null);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("message")) {
            return this.message;
        }
        if (name.equals("raw_json")) {
            return this.rawJson;
        }
        if (name.equals("system_message")) {
            return this.system;
        }
        return super.getContext(name);
    }
}

