/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.abstracts;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public abstract class ProfileEditor {
    public static final Map<UUID, PlayerProfile> fakeProfiles = new HashMap<UUID, PlayerProfile>();
    public static final HashSet<UUID> mirrorUUIDs = new HashSet();

    public ProfileEditor() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new PlayerProfileEditorListener(), (Plugin)NMSHandler.getJavaPlugin());
    }

    public void setPlayerName(Player player, String name) {
        PlayerProfile profile = this.getFakeProfile(player);
        profile.setName(name);
        this.updatePlayer(player, false);
    }

    public String getPlayerName(Player player) {
        return this.getFakeProfile(player).getName();
    }

    public void setPlayerSkin(Player player, String name) {
        PlayerProfile profile = this.getFakeProfile(player);
        PlayerProfile skinProfile = NMSHandler.getInstance().fillPlayerProfile(new PlayerProfile(name, null));
        if (skinProfile.getTexture() != null) {
            profile.setTexture(skinProfile.getTexture());
            profile.setTextureSignature(skinProfile.getTextureSignature());
            this.updatePlayer(player, true);
        }
    }

    public void setPlayerSkinBlob(Player player, String blob) {
        PlayerProfile profile = this.getFakeProfile(player);
        String[] split = blob.split(";");
        profile.setTexture(split[0]);
        profile.setTextureSignature(split.length > 0 ? split[1] : null);
        this.updatePlayer(player, true);
    }

    public String getPlayerSkinBlob(Player player) {
        PlayerProfile prof = this.getFakeProfile(player);
        return prof.getTexture() + ";" + prof.getTextureSignature();
    }

    protected abstract void updatePlayer(Player var1, boolean var2);

    private PlayerProfile getFakeProfile(Player player) {
        UUID uuid = player.getUniqueId();
        if (fakeProfiles.containsKey(uuid)) {
            return fakeProfiles.get(uuid);
        }
        PlayerProfile fakeProfile = NMSHandler.getInstance().getPlayerProfile(player);
        fakeProfiles.put(uuid, fakeProfile);
        return fakeProfile;
    }

    private static class PlayerProfileEditorListener
    implements Listener {
        private PlayerProfileEditorListener() {
        }

        @EventHandler
        public void onPlayerQuit(PlayerQuitEvent event) {
            UUID uuid = event.getPlayer().getUniqueId();
            fakeProfiles.remove(uuid);
        }
    }
}

