/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.interfaces.BlockHelper;
import com.denizenscript.denizen.objects.ChunkTag;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.objects.notable.NotableManager;
import com.denizenscript.denizen.utilities.Settings;
import com.denizenscript.denizen.utilities.depends.Depends;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.notable.Notable;
import com.denizenscript.denizencore.objects.notable.Note;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class CuboidTag
implements ObjectTag,
Cloneable,
Notable,
Adjustable {
    public List<LocationPair> pairs = new ArrayList<LocationPair>();
    String prefix = "Cuboid";
    public static ObjectTagProcessor<CuboidTag> tagProcessor = new ObjectTagProcessor();

    public CuboidTag clone() {
        CuboidTag cuboid;
        try {
            cuboid = (CuboidTag)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            com.denizenscript.denizen.utilities.debugging.Debug.echoError(ex);
            cuboid = new CuboidTag();
        }
        cuboid.pairs = new ArrayList<LocationPair>(this.pairs.size());
        for (LocationPair pair : this.pairs) {
            cuboid.pairs.add(new LocationPair(pair.point_1.clone(), pair.point_2.clone()));
        }
        return cuboid;
    }

    public static List<CuboidTag> getNotableCuboidsContaining(Location location) {
        ArrayList<CuboidTag> cuboids = new ArrayList<CuboidTag>();
        for (CuboidTag cuboid : NotableManager.getAllType(CuboidTag.class)) {
            if (!cuboid.isInsideCuboid(location)) continue;
            cuboids.add(cuboid);
        }
        return cuboids;
    }

    public static CuboidTag valueOf(String string) {
        return CuboidTag.valueOf(string, null);
    }

    @Fetchable(value="cu")
    public static CuboidTag valueOf(String string, TagContext context) {
        Notable noted;
        if (string == null) {
            return null;
        }
        if (CoreUtilities.toLowerCase(string).startsWith("cu@")) {
            string = string.substring("cu@".length());
        }
        if (CoreUtilities.contains(string, '|')) {
            ListTag positions = ListTag.valueOf(string, context);
            if (positions.size() > 1 && LocationTag.matches((String)positions.get(0)) && LocationTag.matches((String)positions.get(1))) {
                if (positions.size() % 2 != 0) {
                    if (context == null || context.debug) {
                        com.denizenscript.denizen.utilities.debugging.Debug.echoError("valueOf CuboidTag returning null (Uneven number of locations): '" + string + "'.");
                    }
                    return null;
                }
                CuboidTag toReturn = new CuboidTag();
                for (int i = 0; i < positions.size(); i += 2) {
                    LocationTag pos_1 = LocationTag.valueOf((String)positions.get(i));
                    LocationTag pos_2 = LocationTag.valueOf((String)positions.get(i + 1));
                    if (pos_1 == null || pos_2 == null) {
                        if (context == null || context.debug) {
                            com.denizenscript.denizen.utilities.debugging.Debug.echoError("valueOf in CuboidTag returning null (null locations): '" + string + "'.");
                        }
                        return null;
                    }
                    if (pos_1.getWorldName() == null || pos_2.getWorldName() == null) {
                        if (context == null || context.debug) {
                            com.denizenscript.denizen.utilities.debugging.Debug.echoError("valueOf in CuboidTag returning null (null worlds): '" + string + "'.");
                        }
                        return null;
                    }
                    toReturn.addPair(pos_1, pos_2);
                }
                if (toReturn.pairs.size() > 0) {
                    return toReturn;
                }
            }
        } else if (CoreUtilities.contains(string, ',')) {
            List<String> subStrs = CoreUtilities.split(string, ',');
            if (subStrs.size() < 7 || (subStrs.size() - 1) % 6 != 0) {
                if (context == null || context.debug) {
                    com.denizenscript.denizen.utilities.debugging.Debug.echoError("valueOf CuboidTag returning null (Improper number of commas): '" + string + "'.");
                }
                return null;
            }
            CuboidTag toReturn = new CuboidTag();
            String worldName = subStrs.get(0);
            if (worldName.startsWith("w@")) {
                worldName = worldName.substring("w@".length());
            }
            try {
                for (int i = 0; i < subStrs.size() - 1; i += 6) {
                    LocationTag locationOne = new LocationTag(CuboidTag.parseRoundDouble(subStrs.get(i + 1)), CuboidTag.parseRoundDouble(subStrs.get(i + 2)), CuboidTag.parseRoundDouble(subStrs.get(i + 3)), worldName);
                    LocationTag locationTwo = new LocationTag(CuboidTag.parseRoundDouble(subStrs.get(i + 4)), CuboidTag.parseRoundDouble(subStrs.get(i + 5)), CuboidTag.parseRoundDouble(subStrs.get(i + 6)), worldName);
                    toReturn.addPair(locationOne, locationTwo);
                }
            }
            catch (NumberFormatException ex) {
                if (context == null || context.debug) {
                    com.denizenscript.denizen.utilities.debugging.Debug.echoError("valueOf CuboidTag returning null (Improper number value inputs): '" + ex.getMessage() + "'.");
                }
                return null;
            }
            if (toReturn.pairs.size() > 0) {
                return toReturn;
            }
        }
        if ((noted = NotableManager.getSavedObject(string)) instanceof CuboidTag) {
            return (CuboidTag)noted;
        }
        if (context == null || context.debug) {
            com.denizenscript.denizen.utilities.debugging.Debug.echoError("valueOf CuboidTag returning null: " + string);
        }
        return null;
    }

    public static double parseRoundDouble(String str) {
        return Math.floor(Double.parseDouble(str));
    }

    public static boolean matches(String string) {
        return CuboidTag.valueOf(string, CoreUtilities.noDebugContext) != null;
    }

    public CuboidTag() {
    }

    public CuboidTag(Location point_1, Location point_2) {
        this.addPair(new LocationTag(point_1), new LocationTag(point_2));
    }

    public void addPair(LocationTag point_1, LocationTag point_2) {
        if (point_1.getWorld() != point_2.getWorld()) {
            com.denizenscript.denizen.utilities.debugging.Debug.echoError("Tried to make cross-world cuboid!");
            return;
        }
        if (this.pairs.size() > 0 && point_1.getWorld() != this.getWorld()) {
            com.denizenscript.denizen.utilities.debugging.Debug.echoError("Tried to make cross-world cuboid set!");
            return;
        }
        LocationPair pair = new LocationPair(point_1, point_2);
        this.pairs.add(pair);
    }

    public static boolean isBetween(double a, double b, double c) {
        return b > a ? c >= a && c < b : c >= b && c < a;
    }

    public boolean isInsideCuboid(Location location) {
        for (LocationPair pair : this.pairs) {
            if (!location.getWorld().equals(pair.low.getWorld()) || !CuboidTag.isBetween(pair.low.getBlockX(), pair.high.getBlockX() + 1, location.getBlockX()) || !CuboidTag.isBetween(pair.low.getBlockY(), pair.high.getBlockY() + 1, location.getBlockY()) || !CuboidTag.isBetween(pair.low.getBlockZ(), pair.high.getBlockZ() + 1, location.getBlockZ())) continue;
            return true;
        }
        return false;
    }

    public ListTag getShell() {
        int max = Settings.blockTagsMaxBlocks();
        int index = 0;
        ListTag list = new ListTag();
        for (LocationPair pair : this.pairs) {
            int z;
            LocationTag low = pair.low;
            LocationTag high = pair.high;
            int y_distance = pair.y_distance;
            int z_distance = pair.z_distance;
            int x_distance = pair.x_distance;
            for (int x = 0; x < x_distance; ++x) {
                for (int y = 0; y < y_distance; ++y) {
                    list.addObject(new LocationTag(low.getWorld(), (double)(low.getBlockX() + x), (double)(low.getBlockY() + y), low.getBlockZ()));
                    list.addObject(new LocationTag(low.getWorld(), (double)(low.getBlockX() + x), (double)(low.getBlockY() + y), high.getBlockZ()));
                    if (++index <= max) continue;
                    return list;
                }
                for (z = 0; z < z_distance; ++z) {
                    list.addObject(new LocationTag(low.getWorld(), (double)(low.getBlockX() + x), (double)low.getBlockY(), low.getBlockZ() + z));
                    list.addObject(new LocationTag(low.getWorld(), (double)(low.getBlockX() + x), (double)high.getBlockY(), low.getBlockZ() + z));
                    if (++index <= max) continue;
                    return list;
                }
            }
            for (int y = 0; y < y_distance; ++y) {
                for (z = 0; z < z_distance; ++z) {
                    list.addObject(new LocationTag(low.getWorld(), (double)low.getBlockX(), (double)(low.getBlockY() + y), low.getBlockZ() + z));
                    list.addObject(new LocationTag(low.getWorld(), (double)high.getBlockX(), (double)(low.getBlockY() + y), low.getBlockZ() + z));
                    if (++index <= max) continue;
                    return list;
                }
            }
        }
        return list;
    }

    public ListTag getOutline() {
        int max = Settings.blockTagsMaxBlocks();
        int index = 0;
        ListTag list = new ListTag();
        for (LocationPair pair : this.pairs) {
            LocationTag loc_1 = pair.low;
            LocationTag loc_2 = pair.high;
            int y_distance = pair.y_distance;
            int z_distance = pair.z_distance;
            int x_distance = pair.x_distance;
            for (int y = loc_1.getBlockY(); y < loc_1.getBlockY() + y_distance; ++y) {
                list.addObject(new LocationTag(loc_1.getWorld(), (double)loc_1.getBlockX(), (double)y, loc_1.getBlockZ()));
                list.addObject(new LocationTag(loc_1.getWorld(), (double)loc_2.getBlockX(), (double)y, loc_2.getBlockZ()));
                list.addObject(new LocationTag(loc_1.getWorld(), (double)loc_1.getBlockX(), (double)y, loc_2.getBlockZ()));
                list.addObject(new LocationTag(loc_1.getWorld(), (double)loc_2.getBlockX(), (double)y, loc_1.getBlockZ()));
                if (++index <= max) continue;
                return list;
            }
            for (int x = loc_1.getBlockX(); x < loc_1.getBlockX() + x_distance; ++x) {
                list.addObject(new LocationTag(loc_1.getWorld(), (double)x, (double)loc_1.getBlockY(), loc_1.getBlockZ()));
                list.addObject(new LocationTag(loc_1.getWorld(), (double)x, (double)loc_1.getBlockY(), loc_2.getBlockZ()));
                list.addObject(new LocationTag(loc_1.getWorld(), (double)x, (double)loc_2.getBlockY(), loc_2.getBlockZ()));
                list.addObject(new LocationTag(loc_1.getWorld(), (double)x, (double)loc_2.getBlockY(), loc_1.getBlockZ()));
                if (++index <= max) continue;
                return list;
            }
            for (int z = loc_1.getBlockZ(); z < loc_1.getBlockZ() + z_distance; ++z) {
                list.addObject(new LocationTag(loc_1.getWorld(), (double)loc_1.getBlockX(), (double)loc_1.getBlockY(), z));
                list.addObject(new LocationTag(loc_1.getWorld(), (double)loc_2.getBlockX(), (double)loc_2.getBlockY(), z));
                list.addObject(new LocationTag(loc_1.getWorld(), (double)loc_1.getBlockX(), (double)loc_2.getBlockY(), z));
                list.addObject(new LocationTag(loc_1.getWorld(), (double)loc_2.getBlockX(), (double)loc_1.getBlockY(), z));
                if (++index <= max) continue;
                return list;
            }
            list.addObject(pair.high);
        }
        return list;
    }

    public ListTag getBlocks(Attribute attribute) {
        return this.getBlocks(null, attribute);
    }

    private boolean matchesMaterialList(Location loc, List<MaterialTag> materials, Attribute attribute) {
        if (materials == null) {
            return true;
        }
        MaterialTag mat = new MaterialTag(new LocationTag(loc).getBlockForTag(attribute));
        for (MaterialTag material : materials) {
            if (!mat.equals(material) && mat.getMaterial() != material.getMaterial()) continue;
            return true;
        }
        return false;
    }

    public ListTag getBlocks(List<MaterialTag> materials, Attribute attribute) {
        List<LocationTag> locs = this.getBlocks_internal(materials, attribute);
        ListTag list = new ListTag();
        for (LocationTag loc : locs) {
            list.addObject(loc);
        }
        return list;
    }

    public List<LocationTag> getBlocks_internal(List<MaterialTag> materials, Attribute attribute) {
        if (materials == null) {
            return this.getBlockLocationsUnfiltered();
        }
        int max = Settings.blockTagsMaxBlocks();
        ArrayList<LocationTag> list = new ArrayList<LocationTag>();
        int index = 0;
        for (LocationPair pair : this.pairs) {
            LocationTag loc_1 = pair.low;
            int y_distance = pair.y_distance;
            int z_distance = pair.z_distance;
            int x_distance = pair.x_distance;
            for (int x = 0; x != x_distance + 1; ++x) {
                for (int y = 0; y != y_distance + 1; ++y) {
                    for (int z = 0; z != z_distance + 1; ++z) {
                        LocationTag loc = new LocationTag(loc_1.clone().add(x, y, z));
                        if (loc.getY() < 0.0 || loc.getY() > 255.0) continue;
                        if (this.matchesMaterialList(loc, materials, attribute)) {
                            list.add(loc);
                        }
                        if (++index <= max) continue;
                        return list;
                    }
                }
            }
        }
        return list;
    }

    public List<LocationTag> getBlockLocationsUnfiltered() {
        int max = Settings.blockTagsMaxBlocks();
        ArrayList<LocationTag> list = new ArrayList<LocationTag>();
        int index = 0;
        for (LocationPair pair : this.pairs) {
            LocationTag loc_1 = pair.low;
            int y_distance = pair.y_distance;
            int z_distance = pair.z_distance;
            int x_distance = pair.x_distance;
            for (int x = 0; x <= x_distance; ++x) {
                for (int z = 0; z <= z_distance; ++z) {
                    for (int y = 0; y <= y_distance; ++y) {
                        LocationTag loc = new LocationTag(loc_1.clone().add(x, y, z));
                        list.add(loc);
                        if (++index <= max) continue;
                        return list;
                    }
                }
            }
        }
        return list;
    }

    public ListTag getSpawnableBlocks(Attribute attribute) {
        return this.getSpawnableBlocks(null, attribute);
    }

    public ListTag getSpawnableBlocks(List<MaterialTag> mats, Attribute attribute) {
        int max = Settings.blockTagsMaxBlocks();
        ListTag list = new ListTag();
        int index = 0;
        BlockHelper blockHelper = NMSHandler.getBlockHelper();
        for (LocationPair pair : this.pairs) {
            LocationTag loc_1 = pair.low;
            int y_distance = pair.y_distance;
            int z_distance = pair.z_distance;
            int x_distance = pair.x_distance;
            for (int x = 0; x != x_distance + 1; ++x) {
                for (int y = 0; y != y_distance + 1; ++y) {
                    for (int z = 0; z != z_distance + 1; ++z) {
                        LocationTag loc = new LocationTag(loc_1.clone().add(x, y, z));
                        if (blockHelper.isSafeBlock(loc.getBlockTypeForTag(attribute)) && blockHelper.isSafeBlock(new LocationTag(loc.clone().add(0.0, 1.0, 0.0)).getBlockTypeForTag(attribute)) && new LocationTag(loc.clone().add(0.0, -1.0, 0.0)).getBlockTypeForTag(attribute).isSolid() && this.matchesMaterialList(loc.clone().add(0.0, -1.0, 0.0), mats, attribute)) {
                            loc.add(0.5, 0.0, 0.5);
                            list.addObject(loc);
                        }
                        if (++index <= max) continue;
                        return list;
                    }
                }
            }
        }
        return list;
    }

    public World getWorld() {
        if (this.pairs.isEmpty()) {
            return null;
        }
        return this.pairs.get((int)0).high.getWorld();
    }

    public LocationTag getHigh(int index) {
        if (index < 0) {
            return null;
        }
        if (index >= this.pairs.size()) {
            return null;
        }
        return this.pairs.get((int)index).high;
    }

    public LocationTag getLow(int index) {
        if (index < 0) {
            return null;
        }
        if (index >= this.pairs.size()) {
            return null;
        }
        return this.pairs.get((int)index).low;
    }

    @Override
    public boolean isUnique() {
        return NotableManager.isSaved(this);
    }

    @Override
    @Note(value="Cuboids")
    public String getSaveObject() {
        return this.identifyFull().substring(3);
    }

    @Override
    public void makeUnique(String id) {
        NotableManager.saveAs(this, id);
    }

    @Override
    public void forget() {
        NotableManager.remove(this);
    }

    @Override
    public String getObjectType() {
        return "cuboid";
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public CuboidTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public String debuggable() {
        if (this.isUnique()) {
            return "cu@" + NotableManager.getSavedId(this) + " <GR>(" + this.identifyFull() + ")";
        }
        return this.identifyFull();
    }

    @Override
    public String identify() {
        if (this.isUnique()) {
            return "cu@" + NotableManager.getSavedId(this);
        }
        return this.identifyFull();
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String identifyFull() {
        StringBuilder sb = new StringBuilder();
        sb.append("cu@").append(this.pairs.get((int)0).low.getWorldName());
        for (LocationPair pair : this.pairs) {
            sb.append(',').append(pair.low.getBlockX()).append(',').append(pair.low.getBlockY()).append(',').append(pair.low.getBlockZ()).append(',').append(pair.high.getBlockX()).append(',').append(pair.high.getBlockY()).append(',').append(pair.high.getBlockZ());
        }
        return sb.toString();
    }

    public String toString() {
        return this.identify();
    }

    public static void registerTags() {
        CuboidTag.registerTag("blocks", (attribute, cuboid) -> {
            if (attribute.hasContext(1)) {
                return new ListTag(cuboid.getBlocks(ListTag.valueOf(attribute.getContext(1), attribute.context).filter(MaterialTag.class, attribute.context), attribute));
            }
            return new ListTag(cuboid.getBlocks(attribute));
        }, "get_blocks");
        CuboidTag.registerTag("members_size", (attribute, cuboid) -> new ElementTag(cuboid.pairs.size()), new String[0]);
        CuboidTag.registerTag("spawnable_blocks", (attribute, cuboid) -> {
            if (attribute.hasContext(1)) {
                return new ListTag(cuboid.getSpawnableBlocks(ListTag.valueOf(attribute.getContext(1), attribute.context).filter(MaterialTag.class, attribute.context), attribute));
            }
            return new ListTag(cuboid.getSpawnableBlocks(attribute));
        }, "get_spawnable_blocks");
        CuboidTag.registerTag("shell", (attribute, cuboid) -> cuboid.getShell(), new String[0]);
        CuboidTag.registerTag("outline", (attribute, cuboid) -> cuboid.getOutline(), "get_outline");
        CuboidTag.registerTag("intersects", (attribute, cuboid) -> {
            if (!attribute.hasContext(1)) {
                com.denizenscript.denizen.utilities.debugging.Debug.echoError("The tag CuboidTag.intersects[...] must have a value.");
                return null;
            }
            CuboidTag cub2 = CuboidTag.valueOf(attribute.getContext(1));
            if (cub2 != null) {
                boolean intersects = false;
                block0: for (LocationPair pair : cuboid.pairs) {
                    for (LocationPair pair2 : cub2.pairs) {
                        if (!pair.low.getWorld().getName().equalsIgnoreCase(pair2.low.getWorld().getName())) {
                            return new ElementTag("false");
                        }
                        if (!(pair2.low.getX() <= pair.high.getX()) || !(pair2.low.getY() <= pair.high.getY()) || !(pair2.low.getZ() <= pair.high.getZ()) || !(pair2.high.getX() >= pair.low.getX()) || !(pair2.high.getY() >= pair.low.getY()) || !(pair2.high.getZ() >= pair.low.getZ())) continue;
                        intersects = true;
                        break block0;
                    }
                }
                return new ElementTag(intersects);
            }
            return null;
        }, new String[0]);
        CuboidTag.registerTag("contains_location", (attribute, cuboid) -> {
            if (!attribute.hasContext(1)) {
                com.denizenscript.denizen.utilities.debugging.Debug.echoError("The tag CuboidTag.contains_location[...] must have a value.");
                return null;
            }
            LocationTag loc = LocationTag.valueOf(attribute.getContext(1));
            return new ElementTag(cuboid.isInsideCuboid(loc));
        }, new String[0]);
        CuboidTag.registerTag("is_within", (attribute, cuboid) -> {
            if (!attribute.hasContext(1)) {
                com.denizenscript.denizen.utilities.debugging.Debug.echoError("The tag CuboidTag.is_within[...] must have a value.");
                return null;
            }
            CuboidTag cub2 = CuboidTag.valueOf(attribute.getContext(1));
            if (cub2 != null) {
                boolean contains = true;
                for (LocationPair pair2 : cuboid.pairs) {
                    boolean contained = false;
                    for (LocationPair pair : cub2.pairs) {
                        if (!pair.low.getWorld().getName().equalsIgnoreCase(pair2.low.getWorld().getName())) {
                            if (Debug.verbose) {
                                com.denizenscript.denizen.utilities.debugging.Debug.log("Worlds don't match!");
                            }
                            return new ElementTag("false");
                        }
                        if (!(pair2.low.getX() >= pair.low.getX()) || !(pair2.low.getY() >= pair.low.getY()) || !(pair2.low.getZ() >= pair.low.getZ()) || !(pair2.high.getX() <= pair.high.getX()) || !(pair2.high.getY() <= pair.high.getY()) || !(pair2.high.getZ() <= pair.high.getZ())) continue;
                        contained = true;
                        break;
                    }
                    if (contained) continue;
                    contains = false;
                    break;
                }
                return new ElementTag(contains);
            }
            return null;
        }, new String[0]);
        CuboidTag.registerTag("list_members", (attribute, cuboid) -> {
            List<LocationPair> pairs = cuboid.pairs;
            ListTag list = new ListTag();
            for (LocationPair pair : pairs) {
                list.addObject(new CuboidTag(pair.low, pair.high));
            }
            return list;
        }, new String[0]);
        CuboidTag.registerTag("get", (attribute, cuboid) -> {
            if (!attribute.hasContext(1)) {
                com.denizenscript.denizen.utilities.debugging.Debug.echoError("The tag CuboidTag.get[...] must have a value.");
                return null;
            }
            int member = attribute.getIntContext(1);
            if (member < 1) {
                member = 1;
            }
            if (member > cuboid.pairs.size()) {
                member = cuboid.pairs.size();
            }
            LocationPair pair = cuboid.pairs.get(member - 1);
            return new CuboidTag(pair.point_1, pair.point_2);
        }, "member", "get_member");
        CuboidTag.registerTag("set", (attribute, cuboid) -> {
            if (!attribute.hasContext(1)) {
                com.denizenscript.denizen.utilities.debugging.Debug.echoError("The tag CuboidTag.set[...] must have a value.");
                return null;
            }
            CuboidTag subCuboid = CuboidTag.valueOf(attribute.getContext(1));
            if (!attribute.startsWith("at", 2)) {
                com.denizenscript.denizen.utilities.debugging.Debug.echoError("The tag CuboidTag.set[...] must be followed by an 'at'.");
                return null;
            }
            if (!attribute.hasContext(2)) {
                com.denizenscript.denizen.utilities.debugging.Debug.echoError("The tag CuboidTag.set[...].at[...] must have an 'at' value.");
                return null;
            }
            int member = attribute.getIntContext(2);
            if (member < 1) {
                member = 1;
            }
            if (member > cuboid.pairs.size()) {
                member = cuboid.pairs.size();
            }
            attribute.fulfill(1);
            LocationPair pair = subCuboid.pairs.get(0);
            CuboidTag cloned = cuboid.clone();
            cloned.pairs.set(member - 1, new LocationPair(pair.point_1, pair.point_2));
            return cloned;
        }, new String[0]);
        CuboidTag.registerTag("add_member", (attribute, cuboid) -> {
            if (!attribute.hasContext(1)) {
                com.denizenscript.denizen.utilities.debugging.Debug.echoError("The tag CuboidTag.add_member[...] must have a value.");
                return null;
            }
            cuboid = cuboid.clone();
            CuboidTag subCuboid = CuboidTag.valueOf(attribute.getContext(1));
            int member = cuboid.pairs.size() + 1;
            if (attribute.startsWith("at", 2)) {
                if (!attribute.hasContext(2)) {
                    com.denizenscript.denizen.utilities.debugging.Debug.echoError("The tag CuboidTag.add_member[...].at[...] must have an 'at' value.");
                    return null;
                }
                member = attribute.getIntContext(2);
                attribute.fulfill(1);
            }
            if (member < 1) {
                member = 1;
            }
            if (member > cuboid.pairs.size() + 1) {
                member = cuboid.pairs.size() + 1;
            }
            LocationPair pair = subCuboid.pairs.get(0);
            cuboid.pairs.add(member - 1, new LocationPair(pair.point_1, pair.point_2));
            return cuboid;
        }, new String[0]);
        CuboidTag.registerTag("remove_member", (attribute, cuboid) -> {
            if (!attribute.hasContext(1)) {
                com.denizenscript.denizen.utilities.debugging.Debug.echoError("The tag CuboidTag.remove_member[...] must have a value.");
                return null;
            }
            cuboid = cuboid.clone();
            int member = attribute.getIntContext(1);
            if (member < 1) {
                member = 1;
            }
            if (member > cuboid.pairs.size() + 1) {
                member = cuboid.pairs.size() + 1;
            }
            cuboid.pairs.remove(member - 1);
            return cuboid;
        }, new String[0]);
        CuboidTag.registerTag("center", (attribute, cuboid) -> {
            LocationPair pair;
            if (!attribute.hasContext(1)) {
                pair = cuboid.pairs.get(0);
            } else {
                int member = attribute.getIntContext(1);
                if (member < 1) {
                    member = 1;
                }
                if (member > cuboid.pairs.size()) {
                    member = cuboid.pairs.size();
                }
                pair = cuboid.pairs.get(member - 1);
            }
            Location base = pair.high.clone().add(pair.low.clone()).add(1.0, 1.0, 1.0);
            base.setX(base.getX() / 2.0);
            base.setY(base.getY() / 2.0);
            base.setZ(base.getZ() / 2.0);
            return new LocationTag(base);
        }, new String[0]);
        CuboidTag.registerTag("volume", (attribute, cuboid) -> {
            LocationPair pair = cuboid.pairs.get(0);
            Location base = pair.high.clone().subtract(pair.low.clone()).add(1.0, 1.0, 1.0);
            return new ElementTag(base.getX() * base.getY() * base.getZ());
        }, new String[0]);
        CuboidTag.registerTag("size", (attribute, cuboid) -> {
            LocationPair pair;
            if (!attribute.hasContext(1)) {
                pair = cuboid.pairs.get(0);
            } else {
                int member = attribute.getIntContext(1);
                if (member < 1) {
                    member = 1;
                }
                if (member > cuboid.pairs.size()) {
                    member = cuboid.pairs.size();
                }
                pair = cuboid.pairs.get(member - 1);
            }
            Location base = pair.high.clone().subtract(pair.low.clone()).add(1.0, 1.0, 1.0);
            return new LocationTag(base);
        }, new String[0]);
        CuboidTag.registerTag("max", (attribute, cuboid) -> {
            if (!attribute.hasContext(1)) {
                return cuboid.pairs.get((int)0).high;
            }
            int member = attribute.getIntContext(1);
            if (member < 1) {
                member = 1;
            }
            if (member > cuboid.pairs.size()) {
                member = cuboid.pairs.size();
            }
            return cuboid.pairs.get((int)(member - 1)).high;
        }, new String[0]);
        CuboidTag.registerTag("min", (attribute, cuboid) -> {
            if (!attribute.hasContext(1)) {
                return cuboid.pairs.get((int)0).low;
            }
            int member = attribute.getIntContext(1);
            if (member < 1) {
                member = 1;
            }
            if (member > cuboid.pairs.size()) {
                member = cuboid.pairs.size();
            }
            return cuboid.pairs.get((int)(member - 1)).low;
        }, new String[0]);
        CuboidTag.registerTag("include", (attribute, cuboid) -> {
            if (!attribute.hasContext(1)) {
                com.denizenscript.denizen.utilities.debugging.Debug.echoError("The tag CuboidTag.include[...] must have a value.");
                return null;
            }
            LocationTag loc = LocationTag.valueOf(attribute.getContext(1));
            if (loc != null) {
                if (loc.getX() < cuboid.pairs.get((int)0).low.getX()) {
                    cuboid.pairs.get((int)0).low = new LocationTag(cuboid.pairs.get((int)0).low.getWorld(), loc.getX(), cuboid.pairs.get((int)0).low.getY(), cuboid.pairs.get((int)0).low.getZ());
                }
                if (loc.getY() < cuboid.pairs.get((int)0).low.getY()) {
                    cuboid.pairs.get((int)0).low = new LocationTag(cuboid.pairs.get((int)0).low.getWorld(), cuboid.pairs.get((int)0).low.getX(), loc.getY(), cuboid.pairs.get((int)0).low.getZ());
                }
                if (loc.getZ() < cuboid.pairs.get((int)0).low.getZ()) {
                    cuboid.pairs.get((int)0).low = new LocationTag(cuboid.pairs.get((int)0).low.getWorld(), cuboid.pairs.get((int)0).low.getX(), cuboid.pairs.get((int)0).low.getY(), loc.getZ());
                }
                if (loc.getX() > cuboid.pairs.get((int)0).high.getX()) {
                    cuboid.pairs.get((int)0).high = new LocationTag(cuboid.pairs.get((int)0).high.getWorld(), loc.getX(), cuboid.pairs.get((int)0).high.getY(), cuboid.pairs.get((int)0).high.getZ());
                }
                if (loc.getY() > cuboid.pairs.get((int)0).high.getY()) {
                    cuboid.pairs.get((int)0).high = new LocationTag(cuboid.pairs.get((int)0).high.getWorld(), cuboid.pairs.get((int)0).high.getX(), loc.getY(), cuboid.pairs.get((int)0).high.getZ());
                }
                if (loc.getZ() > cuboid.pairs.get((int)0).high.getZ()) {
                    cuboid.pairs.get((int)0).high = new LocationTag(cuboid.pairs.get((int)0).high.getWorld(), cuboid.pairs.get((int)0).high.getX(), cuboid.pairs.get((int)0).high.getY(), loc.getZ());
                }
                return cuboid;
            }
            return null;
        }, new String[0]);
        CuboidTag.registerTag("include_x", (attribute, cuboid) -> {
            if (!attribute.hasContext(1)) {
                com.denizenscript.denizen.utilities.debugging.Debug.echoError("The tag CuboidTag.include_x[...] must have a value.");
                return null;
            }
            double x = attribute.getDoubleContext(1);
            if (x < cuboid.pairs.get((int)0).low.getX()) {
                cuboid.pairs.get((int)0).low = new LocationTag(cuboid.pairs.get((int)0).low.getWorld(), x, cuboid.pairs.get((int)0).low.getY(), cuboid.pairs.get((int)0).low.getZ());
            }
            if (x > cuboid.pairs.get((int)0).high.getX()) {
                cuboid.pairs.get((int)0).high = new LocationTag(cuboid.pairs.get((int)0).high.getWorld(), x, cuboid.pairs.get((int)0).high.getY(), cuboid.pairs.get((int)0).high.getZ());
            }
            return cuboid;
        }, new String[0]);
        CuboidTag.registerTag("include_y", (attribute, cuboid) -> {
            if (!attribute.hasContext(1)) {
                com.denizenscript.denizen.utilities.debugging.Debug.echoError("The tag CuboidTag.include_y[...] must have a value.");
                return null;
            }
            double y = attribute.getDoubleContext(1);
            if (y < cuboid.pairs.get((int)0).low.getY()) {
                cuboid.pairs.get((int)0).low = new LocationTag(cuboid.pairs.get((int)0).low.getWorld(), cuboid.pairs.get((int)0).low.getX(), y, cuboid.pairs.get((int)0).low.getZ());
            }
            if (y > cuboid.pairs.get((int)0).high.getY()) {
                cuboid.pairs.get((int)0).high = new LocationTag(cuboid.pairs.get((int)0).high.getWorld(), cuboid.pairs.get((int)0).high.getX(), y, cuboid.pairs.get((int)0).high.getZ());
            }
            return cuboid;
        }, new String[0]);
        CuboidTag.registerTag("include_z", (attribute, cuboid) -> {
            if (!attribute.hasContext(1)) {
                com.denizenscript.denizen.utilities.debugging.Debug.echoError("The tag CuboidTag.include_z[...] must have a value.");
                return null;
            }
            double z = attribute.getDoubleContext(1);
            if (z < cuboid.pairs.get((int)0).low.getZ()) {
                cuboid.pairs.get((int)0).low = new LocationTag(cuboid.pairs.get((int)0).low.getWorld(), cuboid.pairs.get((int)0).low.getX(), cuboid.pairs.get((int)0).low.getY(), z);
            }
            if (z > cuboid.pairs.get((int)0).high.getZ()) {
                cuboid.pairs.get((int)0).high = new LocationTag(cuboid.pairs.get((int)0).high.getWorld(), cuboid.pairs.get((int)0).high.getX(), cuboid.pairs.get((int)0).high.getY(), z);
            }
            return cuboid;
        }, new String[0]);
        CuboidTag.registerTag("with_min", (attribute, cuboid) -> {
            if (!attribute.hasContext(1)) {
                com.denizenscript.denizen.utilities.debugging.Debug.echoError("The tag CuboidTag.with_min[...] must have a value.");
                return null;
            }
            LocationTag location = LocationTag.valueOf(attribute.getContext(1));
            return new CuboidTag(location, cuboid.pairs.get((int)0).high);
        }, new String[0]);
        CuboidTag.registerTag("with_max", (attribute, cuboid) -> {
            if (!attribute.hasContext(1)) {
                com.denizenscript.denizen.utilities.debugging.Debug.echoError("The tag CuboidTag.with_max[...] must have a value.");
                return null;
            }
            LocationTag location = LocationTag.valueOf(attribute.getContext(1));
            return new CuboidTag(location, cuboid.pairs.get((int)0).low);
        }, new String[0]);
        CuboidTag.registerTag("expand", (attribute, cuboid) -> {
            Vector expandBy;
            if (!attribute.hasContext(1)) {
                com.denizenscript.denizen.utilities.debugging.Debug.echoError("The tag CuboidTag.expand[...] must have a value.");
                return null;
            }
            if (ArgumentHelper.matchesInteger(attribute.getContext(1))) {
                int val = attribute.getIntContext(1);
                expandBy = new Vector(val, val, val);
            } else {
                expandBy = LocationTag.valueOf(attribute.getContext(1)).toVector();
            }
            LocationPair pair = cuboid.pairs.get(0);
            return new CuboidTag(pair.low.clone().subtract(expandBy), pair.high.clone().add(expandBy));
        }, new String[0]);
        CuboidTag.registerTag("list_players", (attribute, cuboid) -> {
            ArrayList<PlayerTag> players = new ArrayList<PlayerTag>();
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!cuboid.isInsideCuboid(player.getLocation())) continue;
                players.add(PlayerTag.mirrorBukkitPlayer((OfflinePlayer)player));
            }
            return new ListTag((Collection<? extends ObjectTag>)players);
        }, new String[0]);
        if (Depends.citizens != null) {
            CuboidTag.registerTag("list_npcs", (attribute, cuboid) -> {
                ArrayList<NPCTag> npcs = new ArrayList<NPCTag>();
                for (NPC npc : CitizensAPI.getNPCRegistry()) {
                    NPCTag dnpc = NPCTag.mirrorCitizensNPC(npc);
                    if (!cuboid.isInsideCuboid(dnpc.getLocation())) continue;
                    npcs.add(dnpc);
                }
                return new ListTag((Collection<? extends ObjectTag>)npcs);
            }, new String[0]);
        }
        CuboidTag.registerTag("list_entities", (attribute, cuboid) -> {
            ArrayList<EntityTag> entities = new ArrayList<EntityTag>();
            ListTag types = new ListTag();
            if (attribute.hasContext(1)) {
                types = ListTag.valueOf(attribute.getContext(1), attribute.context);
            }
            block0: for (Entity ent : new WorldTag(cuboid.getWorld()).getEntitiesForTag()) {
                EntityTag current = new EntityTag(ent);
                if (!cuboid.isInsideCuboid(ent.getLocation())) continue;
                if (!types.isEmpty()) {
                    for (String type : types) {
                        if (!current.identifySimpleType().equalsIgnoreCase(type)) continue;
                        entities.add(current);
                        continue block0;
                    }
                    continue;
                }
                entities.add(new EntityTag(ent));
            }
            return new ListTag((Collection<? extends ObjectTag>)entities);
        }, new String[0]);
        CuboidTag.registerTag("list_living_entities", (attribute, cuboid) -> {
            ArrayList<EntityTag> entities = new ArrayList<EntityTag>();
            for (Entity ent : cuboid.getWorld().getLivingEntities()) {
                if (!cuboid.isInsideCuboid(ent.getLocation()) || EntityTag.isCitizensNPC(ent)) continue;
                entities.add(new EntityTag(ent));
            }
            return new ListTag((Collection<? extends ObjectTag>)entities);
        }, new String[0]);
        CuboidTag.registerTag("list_chunks", (attribute, cuboid) -> {
            ListTag chunks = new ListTag();
            for (LocationPair pair : cuboid.pairs) {
                int minY = pair.low.getBlockY();
                ChunkTag minChunk = new ChunkTag(pair.low);
                if (cuboid.isInsideCuboid(new Location(cuboid.getWorld(), (double)(minChunk.getX() * 16), (double)minY, (double)(minChunk.getZ() * 16)))) {
                    chunks.addObject(minChunk);
                }
                ChunkTag maxChunk = new ChunkTag(pair.high);
                if (cuboid.isInsideCuboid(new Location(cuboid.getWorld(), (double)(maxChunk.getX() * 16 + 15), (double)minY, (double)(maxChunk.getZ() * 16 + 15)))) {
                    chunks.addObject(maxChunk);
                }
                for (int x = minChunk.getX() + 1; x < maxChunk.getX(); ++x) {
                    for (int z = minChunk.getZ() + 1; z < maxChunk.getZ(); ++z) {
                        chunks.addObject(new ChunkTag(new WorldTag(cuboid.getWorld()), x, z));
                    }
                }
            }
            return chunks.deduplicate();
        }, new String[0]);
        CuboidTag.registerTag("list_partial_chunks", (attribute, cuboid) -> {
            ListTag chunks = new ListTag();
            for (LocationPair pair : cuboid.pairs) {
                ChunkTag minChunk = new ChunkTag(pair.low);
                ChunkTag maxChunk = new ChunkTag(pair.high);
                for (int x = minChunk.getX(); x <= maxChunk.getX(); ++x) {
                    for (int z = minChunk.getZ(); z <= maxChunk.getZ(); ++z) {
                        chunks.addObject(new ChunkTag(new WorldTag(cuboid.getWorld()), x, z));
                    }
                }
            }
            return chunks;
        }, new String[0]);
        CuboidTag.registerTag("notable_name", (attribute, cuboid) -> {
            String notname = NotableManager.getSavedId(cuboid);
            if (notname == null) {
                return null;
            }
            return new ElementTag(notname);
        }, new String[0]);
        CuboidTag.registerTag("full", (attribute, cuboid) -> new ElementTag(cuboid.identifyFull()), new String[0]);
        CuboidTag.registerTag("type", (attribute, cuboid) -> new ElementTag("Cuboid"), new String[0]);
    }

    public static void registerTag(String name, TagRunnable.ObjectInterface<CuboidTag> runnable, String ... variants) {
        tagProcessor.registerTag(name, runnable, variants);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        if (NotableManager.isExactSavedObject(this)) {
            com.denizenscript.denizen.utilities.debugging.Debug.echoError("Cannot apply properties to noted objects.");
            return;
        }
        this.adjust(mechanism);
    }

    @Override
    public void adjust(Mechanism mechanism) {
        LocationPair pair;
        CuboidTag subCuboid;
        int member;
        int comma;
        String value;
        if (mechanism.matches("set_member")) {
            value = mechanism.getValue().asString();
            comma = value.indexOf(44);
            member = 1;
            if (comma > 0) {
                member = new ElementTag(value.substring(0, comma)).asInt();
            }
            subCuboid = CuboidTag.valueOf(comma == -1 ? value : value.substring(comma + 1));
            if (member < 1) {
                member = 1;
            }
            if (member > this.pairs.size()) {
                member = this.pairs.size();
            }
            pair = subCuboid.pairs.get(0);
            this.pairs.set(member - 1, new LocationPair(pair.point_1, pair.point_2));
        }
        if (mechanism.matches("add_member")) {
            value = mechanism.getValue().asString();
            comma = value.indexOf(44);
            member = this.pairs.size() + 1;
            if (comma > 0) {
                member = new ElementTag(value.substring(0, comma)).asInt();
            }
            subCuboid = CuboidTag.valueOf(comma == -1 ? value : value.substring(comma + 1));
            if (member < 1) {
                member = 1;
            }
            if (member > this.pairs.size()) {
                member = this.pairs.size();
            }
            pair = subCuboid.pairs.get(0);
            this.pairs.add(member - 1, new LocationPair(pair.point_1, pair.point_2));
        }
        if (mechanism.matches("remove_member") && mechanism.requireInteger()) {
            int member2 = mechanism.getValue().asInt();
            if (member2 < 1) {
                member2 = 1;
            }
            if (member2 > this.pairs.size()) {
                member2 = this.pairs.size();
            }
            this.pairs.remove(member2 - 1);
        }
        CoreUtilities.autoPropertyMechanism(this, mechanism);
    }

    public static class LocationPair {
        public LocationTag low;
        public LocationTag high;
        LocationTag point_1;
        LocationTag point_2;
        int x_distance;
        int y_distance;
        int z_distance;

        public LocationPair(LocationTag point_1, LocationTag point_2) {
            this.point_1 = point_1;
            this.point_2 = point_2;
            this.regenerate();
        }

        public void regenerate() {
            String world = this.point_1.getWorldName();
            int x_high = this.point_1.getBlockX() >= this.point_2.getBlockX() ? this.point_1.getBlockX() : this.point_2.getBlockX();
            int x_low = this.point_1.getBlockX() <= this.point_2.getBlockX() ? this.point_1.getBlockX() : this.point_2.getBlockX();
            int y_high = this.point_1.getBlockY() >= this.point_2.getBlockY() ? this.point_1.getBlockY() : this.point_2.getBlockY();
            int y_low = this.point_1.getBlockY() <= this.point_2.getBlockY() ? this.point_1.getBlockY() : this.point_2.getBlockY();
            int z_high = this.point_1.getBlockZ() >= this.point_2.getBlockZ() ? this.point_1.getBlockZ() : this.point_2.getBlockZ();
            int z_low = this.point_1.getBlockZ() <= this.point_2.getBlockZ() ? this.point_1.getBlockZ() : this.point_2.getBlockZ();
            this.low = new LocationTag(x_low, (double)y_low, (double)z_low, world);
            this.high = new LocationTag(x_high, (double)y_high, (double)z_high, world);
            this.generateDistances();
        }

        public void generateDistances() {
            this.x_distance = this.high.getBlockX() - this.low.getBlockX();
            this.y_distance = this.high.getBlockY() - this.low.getBlockY();
            this.z_distance = this.high.getBlockZ() - this.low.getBlockZ();
        }
    }
}

