/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;

public class EntityEquipment
implements Property {
    public static final String[] handledTags = new String[]{"equipment"};
    public static final String[] handledMechs = new String[]{"equipment"};
    EntityTag entity;

    public static boolean describes(ObjectTag entity) {
        return entity instanceof EntityTag && ((EntityTag)entity).getBukkitEntity() instanceof LivingEntity;
    }

    public static EntityEquipment getFrom(ObjectTag entity) {
        if (!EntityEquipment.describes(entity)) {
            return null;
        }
        return new EntityEquipment((EntityTag)entity);
    }

    private EntityEquipment(EntityTag ent) {
        this.entity = ent;
    }

    @Override
    public String getPropertyString() {
        return this.entity.getEquipment().identify();
    }

    @Override
    public String getPropertyId() {
        return "equipment";
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("equipment.boots")) {
            if (this.entity.getLivingEntity().getEquipment().getBoots() != null) {
                return new ItemTag(this.entity.getLivingEntity().getEquipment().getBoots()).getObjectAttribute(attribute.fulfill(2));
            }
            return new ItemTag(Material.AIR).getObjectAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("equipment.chestplate") || attribute.startsWith("equipment.chest")) {
            if (this.entity.getLivingEntity().getEquipment().getChestplate() != null) {
                return new ItemTag(this.entity.getLivingEntity().getEquipment().getChestplate()).getObjectAttribute(attribute.fulfill(2));
            }
            return new ItemTag(Material.AIR).getObjectAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("equipment.helmet") || attribute.startsWith("equipment.head")) {
            if (this.entity.getLivingEntity().getEquipment().getHelmet() != null) {
                return new ItemTag(this.entity.getLivingEntity().getEquipment().getHelmet()).getObjectAttribute(attribute.fulfill(2));
            }
            return new ItemTag(Material.AIR).getObjectAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("equipment.leggings") || attribute.startsWith("equipment.legs")) {
            if (this.entity.getLivingEntity().getEquipment().getLeggings() != null) {
                return new ItemTag(this.entity.getLivingEntity().getEquipment().getLeggings()).getObjectAttribute(attribute.fulfill(2));
            }
            return new ItemTag(Material.AIR).getObjectAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("equipment")) {
            return this.entity.getEquipment().getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("equipment")) {
            ListTag list = ListTag.valueOf(mechanism.getValue().asString(), mechanism.context);
            ItemStack[] stacks = new ItemStack[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                stacks[i] = ItemTag.valueOf((String)list.get(i), mechanism.context).getItemStack();
            }
            this.entity.getLivingEntity().getEquipment().setArmorContents(stacks);
        }
    }
}

