/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.TradeTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import java.util.ArrayList;
import java.util.Collection;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.MerchantRecipe;

public class EntityTrades
implements Property {
    public static final String[] handledTags = new String[]{"trades"};
    public static final String[] handledMechs = new String[]{"trades"};
    private EntityTag entity;

    public static boolean describes(ObjectTag entity) {
        return entity instanceof EntityTag && ((EntityTag)entity).getBukkitEntity() instanceof Merchant;
    }

    public static EntityTrades getFrom(ObjectTag entity) {
        if (!EntityTrades.describes(entity)) {
            return null;
        }
        return new EntityTrades((EntityTag)entity);
    }

    public ListTag getTradeRecipes() {
        if (this.entity.getBukkitEntity() instanceof Merchant) {
            ArrayList<TradeTag> recipes = new ArrayList<TradeTag>();
            for (MerchantRecipe recipe : ((Merchant)this.entity.getBukkitEntity()).getRecipes()) {
                recipes.add(new TradeTag(recipe));
            }
            return new ListTag((Collection<? extends ObjectTag>)recipes);
        }
        return null;
    }

    public EntityTrades(EntityTag entity) {
        this.entity = entity;
    }

    @Override
    public String getPropertyString() {
        if (((Merchant)this.entity.getBukkitEntity()).getRecipes() == null) {
            return null;
        }
        return this.getTradeRecipes().identify();
    }

    @Override
    public String getPropertyId() {
        return "trades";
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("trades")) {
            return this.getTradeRecipes().getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("trades")) {
            ArrayList<MerchantRecipe> recipes = new ArrayList<MerchantRecipe>();
            for (TradeTag recipe : mechanism.valueAsType(ListTag.class).filter(TradeTag.class, mechanism.context)) {
                recipes.add(recipe.getRecipe());
            }
            ((Merchant)this.entity.getBukkitEntity()).setRecipes(recipes);
        }
    }
}

