/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.objects.ColorTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;

public class ItemColor
implements Property {
    public static final String[] handledTags = new String[]{"color", "dye_color"};
    public static final String[] handledMechs = new String[]{"color", "dye_color", "dye"};
    ItemTag item;

    public static boolean describes(ObjectTag item) {
        return item instanceof ItemTag && (((ItemTag)item).getItemStack().getType() == Material.LEATHER_BOOTS || ((ItemTag)item).getItemStack().getType() == Material.LEATHER_CHESTPLATE || ((ItemTag)item).getItemStack().getType() == Material.LEATHER_HELMET || ((ItemTag)item).getItemStack().getType() == Material.LEATHER_LEGGINGS || ((ItemTag)item).getItemStack().getType() == Material.POTION || ((ItemTag)item).getItemStack().getType() == Material.SPLASH_POTION || ((ItemTag)item).getItemStack().getType() == Material.LINGERING_POTION);
    }

    public static ItemColor getFrom(ObjectTag _item) {
        if (!ItemColor.describes(_item)) {
            return null;
        }
        return new ItemColor((ItemTag)_item);
    }

    private ItemColor(ItemTag _item) {
        this.item = _item;
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("color") || attribute.startsWith("dye_color")) {
            Material mat = this.item.getItemStack().getType();
            if (mat == Material.POTION || mat == Material.LINGERING_POTION || mat == Material.SPLASH_POTION) {
                PotionMeta pm = (PotionMeta)this.item.getItemStack().getItemMeta();
                if (!pm.hasColor()) {
                    return new ColorTag(Color.WHITE).getObjectAttribute(attribute.fulfill(1));
                }
                return new ColorTag(pm.getColor()).getObjectAttribute(attribute.fulfill(1));
            }
            return new ColorTag(((LeatherArmorMeta)this.item.getItemStack().getItemMeta()).getColor()).getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public String getPropertyString() {
        Material mat = this.item.getItemStack().getType();
        if (mat == Material.POTION || mat == Material.LINGERING_POTION || mat == Material.SPLASH_POTION) {
            PotionMeta pm = (PotionMeta)this.item.getItemStack().getItemMeta();
            if (!pm.hasColor()) {
                return null;
            }
            return new ColorTag(pm.getColor()).identify();
        }
        return new ColorTag(((LeatherArmorMeta)this.item.getItemStack().getItemMeta()).getColor()).identify();
    }

    @Override
    public String getPropertyId() {
        return "color";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if ((mechanism.matches("dye") || mechanism.matches("dye_color") || mechanism.matches("color")) && mechanism.requireObject(ColorTag.class)) {
            ColorTag color = mechanism.valueAsType(ColorTag.class);
            Material mat = this.item.getItemStack().getType();
            if (mat == Material.POTION || mat == Material.LINGERING_POTION || mat == Material.SPLASH_POTION) {
                PotionMeta meta = (PotionMeta)this.item.getItemStack().getItemMeta();
                meta.setColor(color.getColor());
                this.item.getItemStack().setItemMeta((ItemMeta)meta);
                return;
            }
            LeatherArmorMeta meta = (LeatherArmorMeta)this.item.getItemStack().getItemMeta();
            meta.setColor(color.getColor());
            this.item.getItemStack().setItemMeta((ItemMeta)meta);
        }
    }
}

