/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemUnbreakable
implements Property {
    public static final String[] handledTags = new String[]{"unbreakable"};
    public static final String[] handledMechs = new String[]{"unbreakable"};
    ItemTag item;

    public static boolean describes(ObjectTag object) {
        return object instanceof ItemTag;
    }

    public static ItemUnbreakable getFrom(ObjectTag object) {
        if (!ItemUnbreakable.describes(object)) {
            return null;
        }
        return new ItemUnbreakable((ItemTag)object);
    }

    private ItemUnbreakable(ItemTag item) {
        this.item = item;
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("unbreakable")) {
            return new ElementTag(this.getPropertyString() != null).getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public String getPropertyString() {
        ItemStack itemStack = this.item.getItemStack();
        return itemStack.hasItemMeta() && itemStack.getItemMeta().isUnbreakable() ? "true" : null;
    }

    @Override
    public String getPropertyId() {
        return "unbreakable";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("unbreakable") && mechanism.requireBoolean()) {
            ItemStack itemStack = this.item.getItemStack().clone();
            ItemMeta meta = itemStack.getItemMeta();
            meta.setUnbreakable(mechanism.getValue().asBoolean());
            itemStack.setItemMeta(meta);
            this.item.setItemStack(itemStack);
        }
    }
}

