/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.material;

import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.block.data.Ageable;

public class MaterialAge
implements Property {
    public static final String[] handledMechs = new String[]{"age", "plant_growth"};
    MaterialTag material;

    public static boolean describes(ObjectTag material) {
        return material instanceof MaterialTag && ((MaterialTag)material).hasModernData() && ((MaterialTag)material).getModernData().data instanceof Ageable;
    }

    public static MaterialAge getFrom(ObjectTag _material) {
        if (!MaterialAge.describes(_material)) {
            return null;
        }
        return new MaterialAge((MaterialTag)_material);
    }

    private MaterialAge(MaterialTag _material) {
        this.material = _material;
    }

    public static void registerTags() {
        PropertyParser.PropertyTag<MaterialAge> runnable = (attribute, material) -> new ElementTag(material.getMax());
        PropertyParser.registerTag("maximum_age", runnable, new String[0]);
        PropertyParser.registerTag("maximum_plant_growth", runnable, new String[0]);
        runnable = (attribute, material) -> new ElementTag(material.getCurrent());
        PropertyParser.registerTag("age", runnable, new String[0]);
        PropertyParser.registerTag("plant_growth", runnable, new String[0]);
    }

    public Ageable getAgeable() {
        return (Ageable)this.material.getModernData().data;
    }

    public int getCurrent() {
        return this.getAgeable().getAge();
    }

    public int getMax() {
        return this.getAgeable().getMaximumAge();
    }

    @Override
    public String getPropertyString() {
        return String.valueOf(this.getCurrent());
    }

    @Override
    public String getPropertyId() {
        return "age";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if ((mechanism.matches("age") || mechanism.matches("plant_growth")) && mechanism.requireInteger()) {
            int age = mechanism.getValue().asInt();
            if (age < 0 || age > this.getMax()) {
                Debug.echoError("Age value '" + age + "' is not valid. Must be between 0 and " + this.getMax() + " for material '" + this.material.realName() + "'.");
                return;
            }
            this.getAgeable().setAge(age);
        }
    }
}

