/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.entity;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;

public class FollowCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("stop") && arg.matches("stop")) {
                scriptEntry.addObject("stop", new ElementTag(true));
                continue;
            }
            if (!scriptEntry.hasObject("lead") && arg.matchesFloat() && arg.matchesPrefix("l", "lead")) {
                scriptEntry.addObject("lead", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("max") && arg.matchesFloat() && arg.matchesPrefix("max")) {
                scriptEntry.addObject("max", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("allow_wander") && arg.matches("allow_wander")) {
                scriptEntry.addObject("allow_wander", new ElementTag(true));
                continue;
            }
            if (!scriptEntry.hasObject("speed") && arg.matchesFloat() && arg.matchesPrefix("s", "speed")) {
                scriptEntry.addObject("speed", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("entities") && arg.matchesPrefix("followers", "follower") && arg.matchesArgumentList(EntityTag.class)) {
                scriptEntry.addObject("entities", arg.asType(ListTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("target") && arg.matchesArgumentType(EntityTag.class)) {
                scriptEntry.addObject("target", arg.asType(EntityTag.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("target")) {
            if (Utilities.entryHasPlayer(scriptEntry)) {
                scriptEntry.addObject("target", Utilities.getEntryPlayer(scriptEntry).getDenizenEntity());
            } else if (!scriptEntry.hasObject("stop")) {
                throw new InvalidArgumentsException("This command requires a linked player!");
            }
        }
        if (!scriptEntry.hasObject("entities")) {
            if (!Utilities.entryHasNPC(scriptEntry)) {
                throw new InvalidArgumentsException("This command requires a linked NPC!");
            }
            scriptEntry.addObject("entities", new ListTag(Utilities.getEntryNPC(scriptEntry)));
        }
        scriptEntry.defaultObject("stop", new ElementTag(false)).defaultObject("allow_wander", new ElementTag(false));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ElementTag stop = scriptEntry.getElement("stop");
        ElementTag lead = scriptEntry.getElement("lead");
        ElementTag maxRange = scriptEntry.getElement("max");
        ElementTag allowWander = scriptEntry.getElement("allow_wander");
        ElementTag speed = scriptEntry.getElement("speed");
        ListTag entities = (ListTag)scriptEntry.getObjectTag("entities");
        EntityTag target = (EntityTag)scriptEntry.getObjectTag("target");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), (Utilities.getEntryPlayer(scriptEntry) != null ? Utilities.getEntryPlayer(scriptEntry).debug() : "") + (!stop.asBoolean() ? ArgumentHelper.debugObj("Action", "FOLLOW") : ArgumentHelper.debugObj("Action", "STOP")) + (lead != null ? lead.debug() : "") + (maxRange != null ? maxRange.debug() : "") + allowWander.debug() + entities.debug() + target.debug());
        }
        for (EntityTag entity : entities.filter(EntityTag.class, scriptEntry)) {
            if (entity.isCitizensNPC()) {
                NPCTag npc = entity.getDenizenNPC();
                if (lead != null) {
                    npc.getNavigator().getLocalParameters().distanceMargin(lead.asDouble());
                }
                if (speed != null) {
                    npc.getNavigator().getLocalParameters().speedModifier(speed.asFloat());
                }
                if (stop.asBoolean()) {
                    npc.getNavigator().cancelNavigation();
                    continue;
                }
                npc.getNavigator().setTarget(target.getBukkitEntity(), false);
                continue;
            }
            if (stop.asBoolean()) {
                NMSHandler.getEntityHelper().stopFollowing(entity.getBukkitEntity());
                continue;
            }
            NMSHandler.getEntityHelper().follow(target.getBukkitEntity(), entity.getBukkitEntity(), speed != null ? speed.asDouble() : 0.3, lead != null ? lead.asDouble() : 5.0, maxRange != null ? maxRange.asDouble() : 8.0, allowWander.asBoolean());
        }
    }
}

