/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.entity;

import com.denizenscript.denizen.npc.traits.HealthTrait;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import java.util.Arrays;
import java.util.List;

public class HealthCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("target") && arg.matches("player")) {
                if (!Utilities.entryHasPlayer(scriptEntry)) {
                    throw new InvalidArgumentsException("No player attached!");
                }
                scriptEntry.addObject("target", Arrays.asList(Utilities.getEntryPlayer(scriptEntry).getDenizenEntity()));
                continue;
            }
            if (!scriptEntry.hasObject("qty") && arg.matchesFloat()) {
                scriptEntry.addObject("qty", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("target") && arg.matchesArgumentList(EntityTag.class)) {
                scriptEntry.addObject("target", arg.asType(ListTag.class).filter(EntityTag.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("action") && arg.matchesPrefix("state")) {
                scriptEntry.addObject("action", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("qty") && !scriptEntry.hasObject("action")) {
            throw new InvalidArgumentsException("Must specify a quantity!");
        }
        if (!scriptEntry.hasObject("target")) {
            if (!Utilities.entryHasNPC(scriptEntry)) {
                throw new InvalidArgumentsException("Missing NPC!");
            }
            scriptEntry.addObject("target", Arrays.asList(Utilities.getEntryNPC(scriptEntry).getDenizenEntity()));
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ElementTag qty = scriptEntry.getElement("qty");
        ElementTag action = scriptEntry.getElement("action");
        List targets = (List)scriptEntry.getObject("target");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), (qty != null ? qty.debug() : "") + (action != null ? action.debug() : "") + ArgumentHelper.debugObj("target", targets.toString()));
        }
        if (qty == null && action == null) {
            Debug.echoError(scriptEntry.getResidingQueue(), "Null quantity!");
        }
        if (action == null) {
            action = new ElementTag(true);
        }
        for (EntityTag target : targets) {
            if (target.isCitizensNPC()) {
                if (action.asString().equalsIgnoreCase("true")) {
                    target.getDenizenNPC().getCitizen().addTrait(HealthTrait.class);
                } else if (action.asString().equalsIgnoreCase("false")) {
                    target.getDenizenNPC().getCitizen().removeTrait(HealthTrait.class);
                } else if (target.getDenizenNPC().getCitizen().hasTrait(HealthTrait.class)) {
                    target.getDenizenNPC().getCitizen().removeTrait(HealthTrait.class);
                } else {
                    target.getDenizenNPC().getCitizen().addTrait(HealthTrait.class);
                }
            }
            if (qty == null) continue;
            if (target.isCitizensNPC()) {
                if (target.getDenizenNPC().getCitizen().hasTrait(HealthTrait.class)) {
                    ((HealthTrait)target.getDenizenNPC().getCitizen().getTrait(HealthTrait.class)).setMaxhealth((int)qty.asFloat());
                    continue;
                }
                Debug.echoError(scriptEntry.getResidingQueue(), "NPC doesn't have health trait!");
                continue;
            }
            if (target.isLivingEntity()) {
                target.getLivingEntity().setMaxHealth(qty.asDouble());
                continue;
            }
            Debug.echoError(scriptEntry.getResidingQueue(), "Entity '" + target.identify() + "'is not alive!");
        }
    }
}

