/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.entity;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.scripts.commands.entity.WalkCommandCitizensEvents;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.depends.Depends;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.Holdable;
import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.citizensnpcs.api.ai.Navigator;
import org.bukkit.Location;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class WalkCommand
extends AbstractCommand
implements Holdable {
    public static List<ScriptEntry> held = new ArrayList<ScriptEntry>();

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("lookat") && arg.matchesPrefix("lookat") && arg.matchesArgumentType(LocationTag.class)) {
                scriptEntry.addObject("lookat", arg.asType(LocationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("speed") && arg.matchesFloat() && arg.matchesPrefix("s", "speed")) {
                scriptEntry.addObject("speed", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("auto_range") && arg.matches("auto_range")) {
                scriptEntry.addObject("auto_range", new ElementTag(true));
                continue;
            }
            if (!scriptEntry.hasObject("radius") && arg.matchesFloat() && arg.matchesPrefix("radius")) {
                scriptEntry.addObject("radius", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("stop") && arg.matches("stop")) {
                scriptEntry.addObject("stop", new ElementTag(true));
                continue;
            }
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(LocationTag.class)) {
                scriptEntry.addObject("location", arg.asType(LocationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(EntityTag.class)) {
                scriptEntry.addObject("entities", arg.asType(ListTag.class).filter(EntityTag.class, scriptEntry));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("location") && !scriptEntry.hasObject("stop")) {
            throw new InvalidArgumentsException("Must specify a location!");
        }
        if (!scriptEntry.hasObject("entities")) {
            if (Utilities.getEntryNPC(scriptEntry) == null || !Utilities.getEntryNPC(scriptEntry).isValid() || !Utilities.getEntryNPC(scriptEntry).isSpawned()) {
                throw new InvalidArgumentsException("Must have a valid spawned NPC attached.");
            }
            scriptEntry.addObject("entities", Arrays.asList(Utilities.getEntryNPC(scriptEntry).getDenizenEntity()));
        }
        scriptEntry.defaultObject("stop", new ElementTag(false));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        LocationTag loc = (LocationTag)scriptEntry.getObject("location");
        ElementTag speed = scriptEntry.getElement("speed");
        ElementTag auto_range = scriptEntry.getElement("auto_range");
        ElementTag radius = scriptEntry.getElement("radius");
        ElementTag stop = scriptEntry.getElement("stop");
        List entities = (List)scriptEntry.getObject("entities");
        final LocationTag lookat = (LocationTag)scriptEntry.getObjectTag("lookat");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), (loc != null ? loc.debug() : "") + (speed != null ? speed.debug() : "") + (auto_range != null ? auto_range.debug() : "") + (radius != null ? radius.debug() : "") + (lookat != null ? lookat.debug() : "") + stop.debug() + ArgumentHelper.debugObj("entities", entities));
        }
        boolean shouldStop = stop.asBoolean();
        ArrayList<NPCTag> npcs = new ArrayList<NPCTag>();
        ArrayList<EntityTag> waitForEntities = new ArrayList<EntityTag>();
        for (final EntityTag entity : entities) {
            if (entity.isCitizensNPC()) {
                NPCTag npc = entity.getDenizenNPC();
                npcs.add(npc);
                if (!npc.isSpawned()) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "NPC " + npc.identify() + " is not spawned!");
                    continue;
                }
                if (shouldStop) {
                    npc.getNavigator().cancelNavigation();
                    continue;
                }
                if (auto_range != null && auto_range.asBoolean()) {
                    double distance = npc.getLocation().distance(loc);
                    if ((double)npc.getNavigator().getLocalParameters().range() < distance + 10.0) {
                        npc.getNavigator().getLocalParameters().range((float)distance + 10.0f);
                    }
                }
                npc.getNavigator().setTarget((Location)loc);
                if (lookat != null) {
                    npc.getNavigator().getLocalParameters().lookAtFunction((Function)new Function<Navigator, Location>(){

                        public Location apply(Navigator nav) {
                            return lookat;
                        }
                    });
                }
                if (speed != null) {
                    npc.getNavigator().getLocalParameters().speedModifier(speed.asFloat());
                }
                if (radius == null) continue;
                npc.getNavigator().getLocalParameters().addRunCallback((Runnable)WalkCommandCitizensEvents.generateNewFlocker(npc.getCitizen(), radius.asDouble()));
                continue;
            }
            if (shouldStop) {
                NMSHandler.getEntityHelper().stopWalking(entity.getBukkitEntity());
                continue;
            }
            waitForEntities.add(entity);
            NMSHandler.getEntityHelper().walkTo(entity.getBukkitEntity(), loc, speed != null ? speed.asDouble() : 0.2, new Runnable(){

                @Override
                public void run() {
                    WalkCommand.this.checkHeld(entity);
                }
            });
        }
        if (scriptEntry.shouldWaitFor()) {
            held.add(scriptEntry);
            if (!npcs.isEmpty()) {
                scriptEntry.addObject("tally", npcs);
            }
            if (!waitForEntities.isEmpty()) {
                scriptEntry.addObject("entities", waitForEntities);
            }
        }
    }

    public void checkHeld(EntityTag entity) {
        for (int i = 0; i < held.size(); ++i) {
            ScriptEntry entry = held.get(i);
            List waitForEntities = (List)entry.getObject("entities");
            if (waitForEntities == null) continue;
            waitForEntities.remove(entity);
            if (!waitForEntities.isEmpty() || entry.hasObject("tally") && !((List)entry.getObject("tally")).isEmpty()) continue;
            entry.setFinished(true);
            held.remove(i);
            --i;
        }
    }

    @Override
    public void onEnable() {
        if (Depends.citizens != null) {
            DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)new WalkCommandCitizensEvents(), (Plugin)DenizenAPI.getCurrentInstance());
        }
    }
}

