/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.item;

import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.depends.Depends;
import com.denizenscript.denizen.utilities.inventory.SlotHelper;
import com.denizenscript.denizen.utilities.nbt.CustomNBT;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class TakeCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("type") && arg.matches("money", "coins")) {
                scriptEntry.addObject("type", (Object)Type.MONEY);
                continue;
            }
            if (!scriptEntry.hasObject("type") && arg.matches("xp", "exp")) {
                scriptEntry.addObject("type", (Object)Type.XP);
                continue;
            }
            if (!scriptEntry.hasObject("type") && arg.matches("item_in_hand", "iteminhand")) {
                scriptEntry.addObject("type", (Object)Type.ITEMINHAND);
                continue;
            }
            if (!scriptEntry.hasObject("qty") && arg.matchesPrefix("q", "qty", "quantity") && arg.matchesFloat()) {
                scriptEntry.addObject("qty", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("items") && arg.matchesPrefix("bydisplay") && !scriptEntry.hasObject("type")) {
                scriptEntry.addObject("type", (Object)Type.BYDISPLAY);
                scriptEntry.addObject("displayname", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("items") && arg.matchesPrefix("nbt") && !scriptEntry.hasObject("type")) {
                scriptEntry.addObject("type", (Object)Type.NBT);
                scriptEntry.addObject("nbt_key", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("type") && !scriptEntry.hasObject("items") && arg.matchesPrefix("bycover")) {
                scriptEntry.addObject("type", (Object)Type.BYCOVER);
                scriptEntry.addObject("cover", arg.asType(ListTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("type") && !scriptEntry.hasObject("items") && arg.matchesPrefix("script", "scriptname")) {
                scriptEntry.addObject("type", (Object)Type.SCRIPTNAME);
                scriptEntry.addObject("scriptitem", arg.asType(ItemTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("slot") && !scriptEntry.hasObject("type") && arg.matchesPrefix("slot")) {
                scriptEntry.addObject("type", (Object)Type.SLOT);
                scriptEntry.addObject("slot", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("items") && !scriptEntry.hasObject("type") && arg.matchesArgumentList(ItemTag.class)) {
                scriptEntry.addObject("items", ListTag.valueOf(arg.raw_value.replace("item:", ""), scriptEntry.getContext()).filter(ItemTag.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("inventory") && arg.matchesPrefix("f", "from") && arg.matchesArgumentType(InventoryTag.class)) {
                scriptEntry.addObject("inventory", arg.asType(InventoryTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("type") && arg.matches("inventory")) {
                scriptEntry.addObject("type", (Object)Type.INVENTORY);
                continue;
            }
            if (!scriptEntry.hasObject("inventory") && arg.matches("npc")) {
                scriptEntry.addObject("inventory", Utilities.getEntryNPC(scriptEntry).getDenizenEntity().getInventory());
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("type", new Object[]{Type.ITEM}).defaultObject("qty", new ElementTag(1));
        Type type = (Type)((Object)scriptEntry.getObject("type"));
        if (type != Type.MONEY && scriptEntry.getObject("inventory") == null) {
            scriptEntry.addObject("inventory", Utilities.entryHasPlayer(scriptEntry) ? Utilities.getEntryPlayer(scriptEntry).getInventory() : null);
        }
        if (!scriptEntry.hasObject("inventory") && type != Type.MONEY) {
            throw new InvalidArgumentsException("Must specify an inventory to take from!");
        }
        if (type == Type.ITEM && scriptEntry.getObject("items") == null) {
            throw new InvalidArgumentsException("Must specify item/items!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        InventoryTag inventory = (InventoryTag)scriptEntry.getObject("inventory");
        ElementTag qty = scriptEntry.getElement("qty");
        ElementTag displayname = scriptEntry.getElement("displayname");
        ItemTag scriptitem = (ItemTag)scriptEntry.getObjectTag("scriptitem");
        ElementTag slot = scriptEntry.getElement("slot");
        ListTag titleAuthor = (ListTag)scriptEntry.getObjectTag("cover");
        ElementTag nbtKey = scriptEntry.getElement("nbt_key");
        Type type = (Type)((Object)scriptEntry.getObject("type"));
        Object items_object = scriptEntry.getObject("items");
        List items = null;
        if (items_object != null) {
            items = (List)items_object;
        }
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), ArgumentHelper.debugObj("Type", type.name()) + qty.debug() + (inventory != null ? inventory.debug() : "") + (displayname != null ? displayname.debug() : "") + (scriptitem != null ? scriptitem.debug() : "") + ArgumentHelper.debugObj("Items", items) + (slot != null ? slot.debug() : "") + (nbtKey != null ? nbtKey.debug() : "") + (titleAuthor != null ? titleAuthor.debug() : ""));
        }
        block0 : switch (type) {
            case INVENTORY: {
                inventory.clear();
                break;
            }
            case ITEMINHAND: {
                int inHandAmt = Utilities.getEntryPlayer(scriptEntry).getPlayerEntity().getEquipment().getItemInMainHand().getAmount();
                int theAmount = (int)qty.asDouble();
                ItemStack newHandItem = new ItemStack(Material.AIR);
                if (theAmount > inHandAmt) {
                    Debug.echoDebug((Debuggable)scriptEntry, "...player did not have enough of the item in hand, so Denizen just took as many as it could. To avoid this situation, use an IF <PLAYER.ITEM_IN_HAND.QTY>.");
                    Utilities.getEntryPlayer(scriptEntry).getPlayerEntity().setItemInHand(newHandItem);
                    break;
                }
                if (theAmount == inHandAmt) {
                    Utilities.getEntryPlayer(scriptEntry).getPlayerEntity().setItemInHand(newHandItem);
                    break;
                }
                newHandItem = Utilities.getEntryPlayer(scriptEntry).getPlayerEntity().getEquipment().getItemInMainHand().clone();
                newHandItem.setAmount(inHandAmt - theAmount);
                Utilities.getEntryPlayer(scriptEntry).getPlayerEntity().setItemInHand(newHandItem);
                Utilities.getEntryPlayer(scriptEntry).getPlayerEntity().updateInventory();
                break;
            }
            case MONEY: {
                if (Depends.economy != null) {
                    Depends.economy.withdrawPlayer(Utilities.getEntryPlayer(scriptEntry).getOfflinePlayer(), qty.asDouble());
                    break;
                }
                Debug.echoError(scriptEntry.getResidingQueue(), "No economy loaded! Have you installed Vault and a compatible economy plugin?");
                break;
            }
            case XP: {
                Utilities.getEntryPlayer(scriptEntry).getPlayerEntity().giveExp(-qty.asInt());
                break;
            }
            case ITEM: {
                for (ItemTag item : items) {
                    ItemStack is = item.getItemStack();
                    is.setAmount(qty.asInt());
                    if (inventory.removeItem(item, item.getAmount())) continue;
                    Debug.echoDebug((Debuggable)scriptEntry, "Inventory does not contain at least " + qty.asInt() + " of " + item.getFullString() + "... Taking as much as possible...");
                }
                break;
            }
            case BYDISPLAY: {
                int found_items = 0;
                if (displayname == null) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Must specify a displayname!");
                    return;
                }
                for (ItemStack it : inventory.getContents()) {
                    if (found_items >= qty.asInt() || it == null || !it.hasItemMeta() || !it.getItemMeta().hasDisplayName() || !it.getItemMeta().getDisplayName().equalsIgnoreCase(displayname.identify())) continue;
                    int amt = it.getAmount();
                    if (found_items + it.getAmount() > qty.asInt()) {
                        it.setAmount(it.getAmount() - (qty.asInt() - found_items));
                        break block0;
                    }
                    inventory.getInventory().removeItem(new ItemStack[]{it});
                    found_items += amt;
                }
                break;
            }
            case NBT: {
                int found_items = 0;
                if (nbtKey == null) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Must specify an NBT key!");
                    return;
                }
                for (ItemStack it : inventory.getContents()) {
                    if (found_items >= qty.asInt() || it == null || !CustomNBT.hasCustomNBT(it, nbtKey.asString(), "Denizen NBT")) continue;
                    int amt = it.getAmount();
                    if (found_items + it.getAmount() > qty.asInt()) {
                        it.setAmount(it.getAmount() - (qty.asInt() - found_items));
                        break block0;
                    }
                    inventory.getInventory().removeItem(new ItemStack[]{it});
                    found_items += amt;
                }
                break;
            }
            case SCRIPTNAME: {
                if (scriptitem == null || scriptitem.getScriptName() == null) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Must specify a valid script name!");
                    return;
                }
                int script_items = 0;
                for (ItemStack it : inventory.getContents()) {
                    if (script_items >= qty.asInt() || it == null || !scriptitem.getScriptName().equalsIgnoreCase(new ItemTag(it).getScriptName())) continue;
                    int amt = it.getAmount();
                    if (script_items + amt <= qty.asInt()) {
                        inventory.getInventory().removeItem(new ItemStack[]{it});
                        script_items += amt;
                        continue;
                    }
                    it.setAmount(amt - (qty.asInt() - script_items));
                    break block0;
                }
                break;
            }
            case SLOT: {
                int slotId = SlotHelper.nameToIndex(slot.asString());
                if (slotId == -1 || slotId >= inventory.getSize()) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "The input '" + slot.asString() + "' is not a valid slot!");
                    return;
                }
                ItemStack original = inventory.getInventory().getItem(slotId);
                if (original == null || original.getType() == Material.AIR) break;
                if (original.getAmount() > qty.asInt()) {
                    original.setAmount(original.getAmount() - qty.asInt());
                    inventory.setSlots(slotId, original);
                    break;
                }
                inventory.setSlots(slotId, new ItemStack(Material.AIR));
                break;
            }
            case BYCOVER: {
                inventory.removeBook((String)titleAuthor.get(0), titleAuthor.size() > 1 ? (String)titleAuthor.get(1) : null, qty.asInt());
            }
        }
    }

    private static enum Type {
        MONEY,
        XP,
        ITEMINHAND,
        ITEM,
        INVENTORY,
        BYDISPLAY,
        SLOT,
        BYCOVER,
        SCRIPTNAME,
        NBT;

    }
}

