/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.npc;

import com.denizenscript.denizen.npc.traits.AssignmentTrait;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;

public class AssignmentCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (arg.matchesEnum(Action.values()) && !scriptEntry.hasObject("action")) {
                scriptEntry.addObject("action", (Object)Action.valueOf(arg.getValue().toUpperCase()));
                continue;
            }
            if (arg.matchesArgumentType(ScriptTag.class) && !scriptEntry.hasObject("script")) {
                if (arg.asType(ScriptTag.class) != null && arg.asType(ScriptTag.class).getType().equalsIgnoreCase("assignment")) {
                    scriptEntry.addObject("script", arg.asType(ScriptTag.class));
                    continue;
                }
                throw new InvalidArgumentsException("Script specified is not an 'assignment-type' container.");
            }
            arg.reportUnhandled();
        }
        if (!Utilities.entryHasNPC(scriptEntry)) {
            throw new InvalidArgumentsException("NPC linked was missing or invalid.");
        }
        if (!scriptEntry.hasObject("action")) {
            throw new InvalidArgumentsException("Must specify an action!");
        }
        if (scriptEntry.getObject("action").equals((Object)Action.SET) && !scriptEntry.hasObject("script")) {
            throw new InvalidArgumentsException("Script specified was missing or invalid.");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ScriptTag script = (ScriptTag)scriptEntry.getObjectTag("script");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), ArgumentHelper.debugObj("action", scriptEntry.getObject("action")) + (script != null ? script.debug() : ""));
        }
        if (scriptEntry.getObject("action").equals((Object)Action.SET)) {
            ((AssignmentTrait)Utilities.getEntryNPC(scriptEntry).getCitizen().getTrait(AssignmentTrait.class)).setAssignment(script.getName(), Utilities.getEntryPlayer(scriptEntry));
        } else if (scriptEntry.getObject("action").equals((Object)Action.REMOVE)) {
            ((AssignmentTrait)Utilities.getEntryNPC(scriptEntry).getCitizen().getTrait(AssignmentTrait.class)).removeAssignment(Utilities.getEntryPlayer(scriptEntry));
        }
    }

    private static enum Action {
        SET,
        REMOVE;

    }
}

