/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.npc;

import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.Holdable;
import java.util.HashMap;
import net.citizensnpcs.api.ai.tree.BehaviorStatus;
import net.citizensnpcs.api.npc.BlockBreaker;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class BreakCommand
extends AbstractCommand
implements Holdable {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(LocationTag.class)) {
                scriptEntry.addObject("location", arg.asType(LocationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("npc") && arg.matchesArgumentType(NPCTag.class)) {
                scriptEntry.addObject("npc", arg.asType(NPCTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("radius") && arg.matchesFloat()) {
                scriptEntry.addObject("radius", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("location")) {
            throw new InvalidArgumentsException("Must specify a location!");
        }
        if (!scriptEntry.hasObject("npc")) {
            if (Utilities.entryHasNPC(scriptEntry)) {
                scriptEntry.addObject("npc", Utilities.getEntryNPC(scriptEntry));
            } else {
                throw new InvalidArgumentsException("Must specify a valid NPC!");
            }
        }
        scriptEntry.defaultObject("radius", new ElementTag(2));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        LocationTag location = (LocationTag)scriptEntry.getObject("location");
        final NPCTag npc = (NPCTag)scriptEntry.getObject("npc");
        ElementTag radius = scriptEntry.getElement("radius");
        final HashMap<String, Adjustable> context = new HashMap<String, Adjustable>();
        MaterialTag material = new MaterialTag(location.getBlock());
        context.put("location", location);
        context.put("material", material);
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), location.debug() + npc.debug() + radius.debug());
        }
        final ScriptEntry se = scriptEntry;
        BlockBreaker.BlockBreakerConfiguration config = new BlockBreaker.BlockBreakerConfiguration();
        config.item(npc.getLivingEntity().getEquipment().getItemInHand());
        config.radius(radius.asDouble());
        config.callback(new Runnable(){

            @Override
            public void run() {
                npc.action("dig", null, context);
                se.setFinished(true);
            }
        });
        BlockBreaker breaker = npc.getCitizen().getBlockBreaker(location.getBlock(), config);
        if (breaker.shouldExecute()) {
            TaskRunnable run = new TaskRunnable(breaker);
            run.taskId = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)DenizenAPI.getCurrentInstance(), (Runnable)run, 0L, 1L);
        } else {
            se.setFinished(true);
        }
    }

    private static class TaskRunnable
    implements Runnable {
        private int taskId;
        private final BlockBreaker breaker;

        public TaskRunnable(BlockBreaker breaker) {
            this.breaker = breaker;
        }

        @Override
        public void run() {
            if (this.breaker.run() != BehaviorStatus.RUNNING) {
                Bukkit.getScheduler().cancelTask(this.taskId);
                this.breaker.reset();
            }
        }
    }
}

