/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.npc;

import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;

public class TraitCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("state") && arg.matchesPrefix("state", "s") && arg.matchesEnum(Toggle.values())) {
                scriptEntry.addObject("state", new ElementTag(arg.getValue().toUpperCase()));
                continue;
            }
            if (scriptEntry.hasObject("trait")) continue;
            scriptEntry.addObject("trait", new ElementTag(arg.getValue()));
        }
        if (!scriptEntry.hasObject("trait")) {
            throw new InvalidArgumentsException("Missing trait argument!");
        }
        if (!Utilities.entryHasNPC(scriptEntry)) {
            throw new InvalidArgumentsException("This command requires a linked NPC!");
        }
        scriptEntry.defaultObject("state", new ElementTag("TOGGLE"));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        Class trait;
        ElementTag toggle = scriptEntry.getElement("state");
        ElementTag traitName = scriptEntry.getElement("trait");
        NPC npc = Utilities.getEntryNPC(scriptEntry).getCitizen();
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), traitName.debug() + toggle.debug() + Utilities.getEntryNPC(scriptEntry).debug());
        }
        if ((trait = CitizensAPI.getTraitFactory().getTraitClass(traitName.asString())) == null) {
            Debug.echoError(scriptEntry.getResidingQueue(), "Trait not found: " + traitName.asString());
            return;
        }
        switch (Toggle.valueOf(toggle.asString())) {
            case TRUE: 
            case ON: {
                if (npc.hasTrait(trait)) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "NPC already has trait '" + traitName.asString() + "'");
                    break;
                }
                npc.addTrait(trait);
                break;
            }
            case FALSE: 
            case OFF: {
                if (!npc.hasTrait(trait)) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "NPC does not have trait '" + traitName.asString() + "'");
                    break;
                }
                npc.removeTrait(trait);
                break;
            }
            case TOGGLE: {
                if (npc.hasTrait(trait)) {
                    npc.removeTrait(trait);
                    break;
                }
                npc.addTrait(trait);
            }
        }
    }

    private static enum Toggle {
        TOGGLE,
        TRUE,
        FALSE,
        ON,
        OFF;

    }
}

