/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.player;

import com.denizenscript.denizen.npc.speech.DenizenSpeechContext;
import com.denizenscript.denizen.npc.speech.DenizenSpeechController;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.Settings;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import org.bukkit.entity.Entity;

public class ChatCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        boolean specified_targets = false;
        boolean specified_talker = false;
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (arg.matchesPrefix("target", "targets", "t")) {
                if (arg.matchesArgumentList(EntityTag.class)) {
                    scriptEntry.addObject("targets", arg.asType(ListTag.class));
                }
                specified_targets = true;
                continue;
            }
            if (arg.matches("no_target")) {
                scriptEntry.addObject("targets", new ListTag());
                continue;
            }
            if (arg.matchesPrefix("talker", "talkers")) {
                if (arg.matchesArgumentList(EntityTag.class)) {
                    scriptEntry.addObject("talkers", arg.asType(ListTag.class));
                }
                specified_talker = true;
                continue;
            }
            if (arg.matchesPrefix("range", "r")) {
                if (!arg.matchesFloat()) continue;
                scriptEntry.addObject("range", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("message")) {
                scriptEntry.addObject("message", new ElementTag(arg.raw_value));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("targets") && Utilities.entryHasPlayer(scriptEntry) && !specified_targets) {
            scriptEntry.defaultObject("targets", new ListTag(Utilities.getEntryPlayer(scriptEntry)));
        }
        if (!scriptEntry.hasObject("talkers") && Utilities.entryHasNPC(scriptEntry) && !specified_talker) {
            scriptEntry.defaultObject("talkers", new ListTag(Utilities.getEntryNPC(scriptEntry)));
        }
        if (!scriptEntry.hasObject("targets")) {
            throw new InvalidArgumentsException("Must specify valid targets!");
        }
        if (!scriptEntry.hasObject("talkers")) {
            throw new InvalidArgumentsException("Must specify valid talkers!");
        }
        if (!scriptEntry.hasObject("message")) {
            throw new InvalidArgumentsException("Must specify a message!");
        }
        scriptEntry.defaultObject("range", new ElementTag(Settings.chatBystandersRange()));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ListTag talkers = (ListTag)scriptEntry.getObjectTag("talkers");
        ListTag targets = (ListTag)scriptEntry.getObjectTag("targets");
        ElementTag message = scriptEntry.getElement("message");
        ElementTag chatRange = scriptEntry.getElement("range");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), talkers.debug() + targets.debug() + message.debug() + chatRange.debug());
        }
        DenizenSpeechContext context = new DenizenSpeechContext(message.asString(), scriptEntry, chatRange.asDouble());
        if (!targets.isEmpty()) {
            for (EntityTag ent : targets.filter(EntityTag.class, scriptEntry)) {
                context.addRecipient(ent.getBukkitEntity());
            }
        }
        for (EntityTag talker : talkers.filter(EntityTag.class, scriptEntry)) {
            Entity entity = talker.getBukkitEntity();
            if (entity != null) {
                context.setTalker(entity);
                new DenizenSpeechController(entity).speak(context);
                continue;
            }
            Debug.echoDebug((Debuggable)scriptEntry, "Chat Talker is not spawned! Cannot talk.");
        }
    }
}

