/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.containers.core;

import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.commands.core.CooldownCommand;
import com.denizenscript.denizen.scripts.containers.core.AssignmentScriptContainer;
import com.denizenscript.denizen.scripts.containers.core.InteractScriptContainer;
import com.denizenscript.denizen.scripts.triggers.AbstractTrigger;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.ChatColor;

public class InteractScriptHelper {
    public static boolean debugGet = true;

    /*
     * WARNING - void declaration
     */
    public static InteractScriptContainer getInteractScript(NPCTag npc, PlayerTag player, Class<? extends AbstractTrigger> trigger) {
        if (npc == null || player == null || trigger == null) {
            return null;
        }
        AssignmentScriptContainer assignmentScript = npc.getAssignmentTrait().getAssignment();
        if (assignmentScript == null) {
            return null;
        }
        List<Object> assignedScripts = new ArrayList();
        if (assignmentScript.contains("interact scripts")) {
            assignedScripts = assignmentScript.getStringList("interact scripts");
        }
        if (assignedScripts.isEmpty()) {
            return null;
        }
        if (Debug.shouldDebug(assignmentScript) && debugGet) {
            Debug.log(Debug.DebugElement.Header, "Getting interact script: n@" + npc.getName() + "/p@" + player.getName());
        }
        ArrayList<PriorityPair> interactableScripts = new ArrayList<PriorityPair>();
        for (String string : assignedScripts) {
            void var7_8;
            String name;
            int priority;
            block28: {
                String string2 = string.toUpperCase();
                if (Character.isDigit(string2.charAt(0))) {
                    try {
                        priority = Integer.parseInt(string2.split(" ", 2)[0]);
                        name = string2.split(" ", 2)[1].replace("^", "");
                        break block28;
                    }
                    catch (Exception e) {
                        Debug.echoError("Invalid Interact assignment for '" + string2 + "'. Is the script name missing?");
                        continue;
                    }
                }
                name = string2;
                String string3 = "0 " + string2;
                priority = 0;
            }
            try {
                InteractScriptContainer interactScript2 = (InteractScriptContainer)ScriptRegistry.getScriptContainer(name);
                if (interactScript2 != null) {
                    if (CooldownCommand.checkCooldown(player, interactScript2.getName())) {
                        interactableScripts.add(new PriorityPair(priority, var7_8.split(" ", 2)[1]));
                    } else if (Debug.shouldDebug(interactScript2) && debugGet) {
                        Debug.log(ChatColor.GOLD + " ...but, isn't cooled down, yet! Skipping.");
                    }
                } else {
                    Debug.echoError("'" + (String)var7_8 + "' is not a valid Interact Script. Is there a duplicate script by this name?");
                }
            }
            catch (Exception e) {
                Debug.echoError(ChatColor.RED + "'" + (String)var7_8 + "' has a bad requirement, skipping.");
                Debug.echoError(e);
            }
            if (!Debug.shouldDebug(assignmentScript) || !debugGet) continue;
            Debug.log(Debug.DebugElement.Spacer, null);
        }
        if (interactableScripts.size() == 1) {
            String script = ((PriorityPair)interactableScripts.get(0)).getName();
            InteractScriptContainer interactScriptContainer = (InteractScriptContainer)ScriptRegistry.getScriptContainer(script.replace("^", ""));
            if (Debug.shouldDebug(interactScriptContainer) && debugGet) {
                Debug.echoApproval("Highest scoring script is " + script + ".");
            }
            if (Debug.shouldDebug(assignmentScript) && debugGet) {
                Debug.log("Current step for this script is: " + InteractScriptHelper.getCurrentStep(player, script));
            }
            if (Debug.shouldDebug(interactScriptContainer) && debugGet) {
                Debug.log(Debug.DebugElement.Footer, "");
            }
            return interactScriptContainer;
        }
        if (interactableScripts.isEmpty()) {
            if (Debug.shouldDebug(assignmentScript) && debugGet) {
                Debug.log(ChatColor.YELLOW + "+> " + ChatColor.WHITE + "No scripts meet requirements!");
                Debug.log(Debug.DebugElement.Footer, "");
            }
            return null;
        }
        Collections.sort(interactableScripts);
        for (int a = interactableScripts.size() - 1; a >= 0; --a) {
            InteractScriptContainer interactScriptContainer = (InteractScriptContainer)ScriptRegistry.getScriptContainer(((PriorityPair)interactableScripts.get(a)).name.replace("^", ""));
            if (Debug.shouldDebug(interactScriptContainer) && debugGet) {
                Debug.log("Checking script '" + ((PriorityPair)interactableScripts.get(a)).getName() + "'.");
            }
            if (((PriorityPair)interactableScripts.get(a)).getName().startsWith("^")) {
                if (interactScriptContainer.containsTriggerInStep(InteractScriptHelper.getCurrentStep(player, interactScriptContainer.getName()), trigger)) {
                    if (Debug.shouldDebug(interactScriptContainer) && debugGet) {
                        Debug.log("...found trigger!");
                        Debug.echoApproval("Highest scoring script is " + interactScriptContainer.getName() + ".");
                        Debug.log("Current step for this script is: " + InteractScriptHelper.getCurrentStep(player, interactScriptContainer.getName()));
                        Debug.log(Debug.DebugElement.Footer, "");
                    }
                    return interactScriptContainer;
                }
                if (!Debug.shouldDebug(interactScriptContainer) || !debugGet) continue;
                Debug.log("...no trigger on this overlay assignment. Skipping.");
                continue;
            }
            if (Debug.shouldDebug(interactScriptContainer) && debugGet) {
                Debug.log("...script is good!");
                Debug.echoApproval("Highest scoring script is " + interactScriptContainer.getName() + ".");
                Debug.log("Current step for this script is: " + InteractScriptHelper.getCurrentStep(player, interactScriptContainer.getName()));
                Debug.log(Debug.DebugElement.Footer, "");
            }
            return interactScriptContainer;
        }
        return null;
    }

    public static String getCurrentStep(PlayerTag player, String scriptName) {
        if (scriptName == null) {
            return null;
        }
        if (DenizenAPI.getSaves().contains("Players." + player.getSaveName() + ".Scripts." + scriptName.toUpperCase() + ".Current Step")) {
            return DenizenAPI.getSaves().getString("Players." + player.getSaveName() + ".Scripts." + scriptName.toUpperCase() + ".Current Step").toUpperCase();
        }
        return ScriptRegistry.getScriptContainerAs(scriptName, InteractScriptContainer.class).getDefaultStepName().toUpperCase();
    }

    private static class PriorityPair
    implements Comparable<PriorityPair> {
        int priority;
        private String name;

        public PriorityPair(int priority, String scriptName) {
            this.priority = priority;
            this.name = scriptName.toUpperCase();
        }

        @Override
        public int compareTo(PriorityPair pair) {
            return this.priority < pair.priority ? -1 : (this.priority > pair.priority ? 1 : 0);
        }

        public String getName() {
            return this.name;
        }
    }
}

