/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.tags;

import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.tags.TagContext;

public class BukkitTagContext
extends TagContext {
    public PlayerTag player;
    public NPCTag npc;

    public BukkitTagContext(BukkitTagContext copyFrom) {
        this(copyFrom.player, copyFrom.npc, copyFrom.entry, copyFrom.debug, copyFrom.script);
    }

    public BukkitTagContext(PlayerTag player, NPCTag npc, ScriptTag script) {
        super(script == null || script.getContainer().shouldDebug(), null, script);
        this.player = player;
        this.npc = npc;
    }

    public BukkitTagContext(PlayerTag player, NPCTag npc, ScriptEntry entry, boolean debug, ScriptTag script) {
        super(debug, entry, script);
        this.player = player;
        this.npc = npc;
    }

    public BukkitTagContext(ScriptEntry entry) {
        super(entry == null || entry.shouldDebug(), entry, entry != null ? entry.getScript() : null);
        this.player = entry != null ? ((BukkitScriptEntryData)entry.entryData).getPlayer() : null;
        this.npc = entry != null ? ((BukkitScriptEntryData)entry.entryData).getNPC() : null;
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        BukkitScriptEntryData bsed = new BukkitScriptEntryData(this.player, this.npc);
        bsed.scriptEntry = this.entry;
        return bsed;
    }

    public String toString() {
        return "Context{player=" + this.player + ",npc=" + this.npc + ",entry=" + this.entry + ",debug=" + this.debug + ",script=" + this.script + "}";
    }
}

