/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.BracedCommand;
import com.denizenscript.denizencore.scripts.commands.CommandRegistry;
import com.denizenscript.denizencore.scripts.commands.Holdable;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ScriptEntry
implements Cloneable,
Debuggable {
    public List<Argument> aHArgs;
    public List<String> args;
    public List<ObjectTag> processed_arguments = null;
    public ScriptEntryData entryData;
    private ScriptQueue queue = null;
    public ScriptEntryInternal internal;
    public TagContext context;
    private Map<String, Object> objects = new HashMap<String, Object>(8);
    public static final Argument NULL_ARGUMENT = new Argument("null_trick", "null_trick");
    public static final InternalArgument NULL_INTERNAL_ARGUMENT = new InternalArgument();
    private ScriptEntry owner = null;
    private Object data;
    public boolean forceInstant = false;
    public boolean isFinished = false;
    public boolean fallbackDebug = true;
    public Boolean shouldDebugBool = null;

    public List<Argument> getProcessedArgs() {
        for (Argument arg : this.aHArgs) {
            if (arg.object instanceof ElementTag && arg.prefix == null) {
                arg.fillStr(arg.object.toString());
                continue;
            }
            arg.value = arg.object.toString();
            arg.lower_value = CoreUtilities.toLowerCase(arg.value);
            arg.raw_value = arg.generateRaw();
        }
        return this.aHArgs;
    }

    public List<BracedCommand.BracedData> getBracedSet() {
        return this.internal.bracedSet;
    }

    public TagContext getContext() {
        return this.context;
    }

    public void updateContext() {
        this.context = DenizenCore.getImplementation().getTagContext(this);
    }

    public void setBracedSet(List<BracedCommand.BracedData> set) {
        this.internal.bracedSet = set;
    }

    public void generateAHArgs() {
        for (int i : this.internal.processArgs) {
            Argument aHArg = this.internal.args_ref.get((int)i).aHArg.clone();
            aHArg.scriptEntry = this;
            this.aHArgs.set(i, aHArg);
        }
    }

    public ScriptEntry clone() {
        try {
            ScriptEntry se = (ScriptEntry)super.clone();
            se.objects = new HashMap<String, Object>(8);
            se.processed_arguments = this.processed_arguments == null ? null : new ArrayList<ObjectTag>(this.processed_arguments);
            se.args = new ArrayList<String>(this.args);
            se.entryData = this.entryData.clone();
            se.entryData.scriptEntry = se;
            se.aHArgs = new ArrayList<Argument>(this.aHArgs);
            se.updateContext();
            return se;
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public List<Object> getInsideList() {
        return this.internal.insideList;
    }

    public ScriptEntry(String command, String[] arguments, ScriptContainer script) {
        this(command, arguments, script, null);
    }

    public void crunchInto(InternalArgument argVal, String arg, TagContext refContext) {
        int indEnd;
        argVal.value = TagManager.dupChain(TagManager.genChain(arg, refContext));
        boolean isTag = false;
        int indStart = arg.indexOf(60);
        if (indStart >= 0 && (indEnd = arg.lastIndexOf(62)) > indStart) {
            isTag = true;
            this.internal.hasTags = true;
        }
        argVal.aHArg = new Argument(argVal.prefix == null ? null : argVal.prefix.aHArg.raw_value, arg);
        argVal.aHArg.needsFill = isTag;
        argVal.aHArg.hasSpecialPrefix = argVal.prefix != null;
    }

    public ScriptEntry(String command, String[] arguments, ScriptContainer script, List<Object> insides) {
        if (command == null) {
            throw new RuntimeException("Command name cannot be null!");
        }
        this.internal = new ScriptEntryInternal();
        this.entryData = DenizenCore.getImplementation().getEmptyScriptEntryData();
        this.internal.command = command.toUpperCase();
        this.internal.insideList = insides;
        this.internal.argPrefixMap = new HashMap();
        if (script != null) {
            this.internal.script = script.getAsScriptArg();
        }
        this.updateContext();
        if (command.length() > 0) {
            if (command.charAt(0) == '^') {
                this.internal.instant = true;
                this.internal.command = command.substring(1);
            } else if (command.charAt(0) == '~') {
                this.internal.command = command.substring(1);
                if (DenizenCore.getCommandRegistry().get(this.internal.command) instanceof Holdable) {
                    this.internal.waitfor = true;
                } else {
                    Debug.echoError("The command '" + this.internal.command + "' cannot be waited for!");
                }
            }
            this.internal.actualCommand = DenizenCore.getCommandRegistry().get(this.internal.command);
            if (this.internal.actualCommand != null && this.internal.actualCommand.forceHold) {
                this.internal.waitfor = true;
            }
        } else {
            this.internal.actualCommand = null;
        }
        if (arguments != null) {
            int i;
            this.args = new ArrayList<String>(arguments.length);
            this.internal.preprocArgs = new ArrayList<Argument>(arguments.length);
            int nested_depth = 0;
            for (String arg : arguments) {
                Argument argObj;
                if (arg.lastIndexOf(37) > arg.indexOf(37)) {
                    Deprecations.ancientDefs.warn(this);
                }
                if (arg.lastIndexOf(62) > arg.indexOf(60) && arg.contains("<^")) {
                    Deprecations.instantTags.warn(this);
                }
                if (arg.equals("{")) {
                    ++nested_depth;
                    this.args.add(arg);
                    continue;
                }
                if (arg.equals("}")) {
                    --nested_depth;
                    this.args.add(arg);
                    continue;
                }
                if (nested_depth > 0) {
                    this.args.add(arg);
                    continue;
                }
                String parg = arg;
                String after = null;
                if (parg.endsWith("{")) {
                    after = "{";
                    parg = parg.substring(0, parg.length() - 1);
                    Debug.echoError("Command '" + command + "' in script '" + (script == null ? "(None)" : script.getName()) + "' has typo: brace written without space... like 'arg{' when it should be 'arg {'.");
                }
                if ((argObj = new Argument(arg)).hasPrefix()) {
                    if (argObj.matchesPrefix("save") || DenizenCore.getImplementation().needsHandleArgPrefix(argObj.prefix)) {
                        this.internal.preprocArgs.add(argObj);
                    } else {
                        this.args.add(arg);
                    }
                } else {
                    this.args.add(parg);
                }
                if (after == null) continue;
                this.args.add(after);
                if (!after.equals("{")) continue;
                ++nested_depth;
                this.args.add(arg);
            }
            this.internal.pre_tagged_args = new ArrayList<String>(this.args);
            nested_depth = 0;
            TagContext refContext = DenizenCore.getImplementation().getTagContext(this);
            this.internal.args_ref = new ArrayList<InternalArgument>(this.args.size());
            ArrayList<Integer> tempProcessArgs = new ArrayList<Integer>(this.args.size());
            this.aHArgs = new ArrayList<Argument>(this.args.size());
            for (i = 0; i < this.args.size(); ++i) {
                InternalArgument brace;
                String arg;
                arg = this.args.get(i);
                if (arg.equals("{")) {
                    brace = new InternalArgument();
                    brace.aHArg = new Argument("", "{");
                    this.internal.args_ref.add(brace);
                    ++nested_depth;
                    continue;
                }
                if (arg.equals("}")) {
                    brace = new InternalArgument();
                    brace.aHArg = new Argument("", "}");
                    this.internal.args_ref.add(brace);
                    --nested_depth;
                    continue;
                }
                this.internal.args_ref.add(NULL_INTERNAL_ARGUMENT);
                if (nested_depth > 0) continue;
                InternalArgument argVal = new InternalArgument();
                this.internal.args_ref.set(i, argVal);
                int colon = TagManager.findColonNotTagNorSpace(arg);
                if (colon > 0) {
                    argVal.prefix = new InternalArgument();
                    this.crunchInto(argVal.prefix, arg.substring(0, colon), refContext);
                    arg = arg.substring(colon + 1);
                    if (!argVal.prefix.aHArg.needsFill) {
                        this.internal.argPrefixMap.put(argVal.prefix.aHArg.lower_value, i);
                    }
                }
                this.crunchInto(argVal, arg, refContext);
                if (argVal.aHArg.needsFill || argVal.aHArg.hasSpecialPrefix) {
                    tempProcessArgs.add(i);
                }
                this.aHArgs.add(argVal.aHArg);
            }
            this.internal.processArgs = new int[tempProcessArgs.size()];
            for (i = 0; i < tempProcessArgs.size(); ++i) {
                this.internal.processArgs[i] = (Integer)tempProcessArgs.get(i);
            }
            this.objectify();
        } else {
            this.args = new ArrayList<String>();
            this.internal.preprocArgs = new ArrayList<Argument>();
            this.internal.pre_tagged_args = new ArrayList<String>();
            this.internal.processArgs = new int[0];
            this.internal.args_ref = new ArrayList<InternalArgument>();
            this.processed_arguments = new ArrayList<ObjectTag>();
            this.aHArgs = new ArrayList<Argument>();
        }
        if (this.internal.actualCommand != null) {
            if (this.internal.actualCommand.getOptions().requiredArgs > this.args.size()) {
                this.internal.brokenArgs = true;
                this.internal.actualCommand = CommandRegistry.debugInvalidCommand;
            }
            if (this.internal.actualCommand instanceof BracedCommand) {
                BracedCommand.getBracedCommands(this);
            }
        } else {
            this.internal.actualCommand = CommandRegistry.debugInvalidCommand;
        }
    }

    public ScriptEntry addObject(String key, Object object) {
        if (object == null) {
            return this;
        }
        if (object instanceof ObjectTag) {
            ((ObjectTag)object).setPrefix(key);
        }
        this.objects.put(key, object);
        return this;
    }

    public ScriptEntry defaultObject(String key, Object ... objects) throws InvalidArgumentsException {
        if (!this.objects.containsKey(key)) {
            for (Object obj : objects) {
                if (obj == null) continue;
                this.addObject(key, obj);
                break;
            }
        }
        if (!this.hasObject(key)) {
            throw new InvalidArgumentsException("Missing '" + key + "' argument!");
        }
        return this;
    }

    public List<String> getArguments() {
        return this.args;
    }

    public List<String> getOriginalArguments() {
        return this.internal.pre_tagged_args;
    }

    public String getCommandName() {
        return this.internal.command;
    }

    public AbstractCommand getCommand() {
        return this.internal.actualCommand;
    }

    public ScriptEntry setArguments(List<String> arguments) {
        this.args = arguments;
        return this;
    }

    public void objectify() {
        this.processed_arguments = new ArrayList<ObjectTag>(this.args.size());
        for (String arg : this.args) {
            this.processed_arguments.add(new ElementTag(arg));
        }
    }

    public void setOwner(ScriptEntry owner) {
        this.owner = owner;
    }

    public ScriptEntry getOwner() {
        return this.owner;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object result) {
        this.data = result;
    }

    public void copyFrom(ScriptEntry entry) {
        this.entryData = entry.entryData.clone();
        this.setSendingQueue(entry.getResidingQueue());
        this.updateContext();
    }

    public Map<String, Object> getObjects() {
        return this.objects;
    }

    public Object getObject(String key) {
        try {
            return this.objects.get(key);
        }
        catch (Exception ex) {
            if (Debug.verbose) {
                Debug.echoError(ex);
            }
            return null;
        }
    }

    public <T extends ObjectTag> T getObjectTag(String key) {
        try {
            Object gotten = this.objects.get(key);
            if (gotten == null) {
                return null;
            }
            if (gotten instanceof Enum) {
                return (T)new ElementTag(((Enum)gotten).name());
            }
            return (T)((ObjectTag)gotten);
        }
        catch (Exception ex) {
            if (Debug.verbose) {
                Debug.echoError(ex);
            }
            return null;
        }
    }

    public ElementTag getElement(String key) {
        try {
            Object gotten = this.objects.get(key);
            if (gotten == null) {
                return null;
            }
            return (ElementTag)gotten;
        }
        catch (Exception ex) {
            if (Debug.verbose) {
                Debug.echoError(ex);
            }
            return null;
        }
    }

    public boolean hasObject(String key) {
        return this.objects.containsKey(key);
    }

    public ScriptTag getScript() {
        return this.internal.script;
    }

    public ScriptEntry setScript(String scriptName) {
        this.internal.script = ScriptTag.valueOf(scriptName);
        return this;
    }

    public ScriptQueue getResidingQueue() {
        return this.queue;
    }

    public void setSendingQueue(ScriptQueue scriptQueue) {
        this.queue = scriptQueue;
    }

    public boolean isInstant() {
        return this.internal.instant || this.forceInstant;
    }

    public ScriptEntry setInstant(boolean instant) {
        this.forceInstant = instant;
        return this;
    }

    public boolean shouldWaitFor() {
        return this.internal.waitfor && !this.isFinished;
    }

    public ScriptEntry setFinished(boolean finished) {
        this.isFinished = finished;
        return this;
    }

    public boolean dbCallShouldDebug() {
        return DenizenCore.getImplementation().shouldDebug(this);
    }

    @Override
    public boolean shouldDebug() {
        if (this.shouldDebugBool != null) {
            return this.shouldDebugBool;
        }
        if (this.internal.script == null || this.internal.script.getContainer() == null) {
            this.shouldDebugBool = this.fallbackDebug;
            return this.shouldDebugBool;
        }
        this.shouldDebugBool = this.internal.script.getContainer().shouldDebug();
        return this.shouldDebugBool;
    }

    private static String stringifyArg(String arg) {
        if (CoreUtilities.contains(arg = arg.replace("\"", "<&dq>"), ' ')) {
            return '\"' + arg + '\"';
        }
        return arg;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String str : this.getOriginalArguments()) {
            sb.append(" ").append(ScriptEntry.stringifyArg(str));
        }
        for (Argument arg : this.internal.preprocArgs) {
            sb.append(" ").append(ScriptEntry.stringifyArg(arg.toString()));
        }
        return this.internal.command + sb.toString();
    }

    static {
        ScriptEntry.NULL_INTERNAL_ARGUMENT.aHArg = NULL_ARGUMENT;
        ScriptEntry.NULL_INTERNAL_ARGUMENT.value = new ArrayList<TagManager.ParseableTagPiece>();
    }

    public static class InternalArgument {
        public InternalArgument prefix = null;
        public List<TagManager.ParseableTagPiece> value = null;
        public Argument aHArg = null;

        public InternalArgument duplicate() {
            InternalArgument newArg = new InternalArgument();
            newArg.prefix = this.prefix == null ? null : this.prefix.duplicate();
            newArg.value = new ArrayList<TagManager.ParseableTagPiece>(this.value);
            newArg.aHArg = this.aHArg == null ? null : this.aHArg.clone();
            return newArg;
        }
    }

    public static class ScriptEntryInternal {
        public String command = null;
        public AbstractCommand actualCommand = null;
        public List<String> pre_tagged_args = null;
        public List<BracedCommand.BracedData> bracedSet = null;
        public List<InternalArgument> args_ref = null;
        public ScriptTag script = null;
        public List<Object> insideList = null;
        public boolean instant = false;
        public boolean waitfor = false;
        public boolean hasTags = false;
        public int[] processArgs = null;
        public List<Argument> preprocArgs = null;
        public Object specialProcessedData = null;
        public String originalLine = null;
        public int lineNumber;
        public boolean brokenArgs = false;
        public HashMap<String, Integer> argPrefixMap = null;
    }
}

