/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractCommand {
    private boolean preparseArgs = true;
    public boolean forceHold = false;
    protected String name;
    public CommandOptions commandOptions;

    public void setParseArgs(boolean parse) {
        this.preparseArgs = parse;
    }

    public boolean shouldPreParse() {
        return this.preparseArgs;
    }

    public AbstractCommand activate() {
        return this;
    }

    public AbstractCommand as(String commandName) {
        this.name = commandName.toUpperCase();
        DenizenCore.getCommandRegistry().register(this.name, this);
        this.onEnable();
        return this;
    }

    public String getName() {
        return this.name;
    }

    public CommandOptions getOptions() {
        return this.commandOptions;
    }

    public String getUsageHint() {
        return !this.commandOptions.syntax.equals("") ? this.commandOptions.syntax : "No usage defined! See documentation for more information!";
    }

    public void onDisable() {
    }

    public void onEnable() {
    }

    public CommandOptions withOptions(String usageHint, int numberOfRequiredArgs) {
        this.commandOptions = new CommandOptions(usageHint, numberOfRequiredArgs);
        return this.commandOptions;
    }

    public abstract void execute(ScriptEntry var1);

    public abstract void parseArgs(ScriptEntry var1) throws InvalidArgumentsException;

    public class CommandOptions {
        public String syntax;
        public int requiredArgs;
        public List<String> flatArgs = new ArrayList<String>();
        public List<String> prefixes = new ArrayList<String>();

        public CommandOptions(String syntax, int numberOfRequiredArgs) {
            this.syntax = syntax;
            this.requiredArgs = numberOfRequiredArgs;
            int firstSpace = syntax.indexOf(32);
            if (firstSpace < 0) {
                return;
            }
            String cleaned = syntax.substring(firstSpace).replace("/", " ");
            cleaned = cleaned.replace("[", "").replace("]", "").replace("(", "").replace(")", "").replace("{", "").replace("}", "");
            List<String> args = CoreUtilities.split(cleaned, ' ');
            for (String arg : args) {
                if (arg.isEmpty()) continue;
                int colonIndex = arg.indexOf(58);
                if (colonIndex > 0) {
                    String prefix = arg.substring(0, colonIndex);
                    if (prefix.contains("<")) continue;
                    this.prefixes.add(prefix);
                    continue;
                }
                if (arg.contains("<") || arg.contains("|")) continue;
                this.flatArgs.add(arg);
            }
            if (Debug.verbose) {
                Debug.log("Command syntax '" + syntax + "' parsed to flat args: ( " + String.join((CharSequence)", ", this.flatArgs) + " ) and prefixes ( " + String.join((CharSequence)", ", this.prefixes) + " ).");
            }
        }
    }
}

