/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.core;

import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.tags.core.UtilTagBase;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.HashMap;
import java.util.function.Consumer;

public class AdjustCommand
extends AbstractCommand {
    public static HashMap<String, Consumer<Mechanism>> specialAdjustables = new HashMap();

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("object")) {
                if (arg.object instanceof ListTag) {
                    scriptEntry.addObject("object", arg.object);
                    continue;
                }
                if (arg.object instanceof ElementTag) {
                    scriptEntry.addObject("object", ListTag.valueOf(arg.raw_value, scriptEntry.getContext()));
                    continue;
                }
                scriptEntry.addObject("object", arg.asType(ListTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("mechanism")) {
                if (arg.hasPrefix()) {
                    scriptEntry.addObject("mechanism", new ElementTag(arg.getPrefix().getValue()));
                    scriptEntry.addObject("mechanism_value", arg.asElement());
                    continue;
                }
                scriptEntry.addObject("mechanism", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("object")) {
            throw new InvalidArgumentsException("You must specify an object!");
        }
        if (!scriptEntry.hasObject("mechanism")) {
            throw new InvalidArgumentsException("You must specify a mechanism!");
        }
    }

    public ObjectTag adjust(ObjectTag object, ElementTag mechanismName, ElementTag value, ScriptEntry entry) {
        Mechanism mechanism = new Mechanism(mechanismName, value, entry.entryData.getTagContext());
        return this.adjust(object, mechanism, entry);
    }

    public ObjectTag adjust(ObjectTag object, Mechanism mechanism, ScriptEntry entry) {
        String objectString = object.toString();
        String lowerObjectString = CoreUtilities.toLowerCase(objectString);
        Consumer<Mechanism> specialAdjustable = specialAdjustables.get(lowerObjectString);
        if (specialAdjustable != null) {
            specialAdjustable.accept(mechanism);
            return object;
        }
        if (lowerObjectString.startsWith("def:")) {
            String defName = lowerObjectString.substring("def:".length());
            ObjectTag def = entry.getResidingQueue().getDefinitionObject(defName);
            if (def == null) {
                Debug.echoError("Invalid definition name '" + defName + "', cannot adjust");
                return object;
            }
            def = this.adjust(def, mechanism, entry);
            entry.getResidingQueue().addDefinition(defName, def);
            return def;
        }
        if (object instanceof ElementTag && (object = ObjectFetcher.pickObjectFor(objectString, entry.entryData.getTagContext())) instanceof ElementTag) {
            Debug.echoError("Unable to determine what object to adjust (missing object notation?), for: " + objectString);
            return object;
        }
        if (object instanceof ListTag) {
            ListTag subList = (ListTag)object;
            ListTag result = new ListTag();
            for (ObjectTag listObject : subList.objectForms) {
                listObject = this.adjust(listObject, mechanism, entry);
                result.addObject(listObject);
            }
            return result;
        }
        if (!(object instanceof Adjustable)) {
            Debug.echoError("'" + objectString + "' is not an adjustable object type.");
            return object;
        }
        object = ObjectFetcher.pickObjectFor(objectString, mechanism.context);
        ((Adjustable)object).safeAdjust(mechanism);
        return object;
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ElementTag mechanism = scriptEntry.getElement("mechanism");
        ElementTag value = scriptEntry.getElement("mechanism_value");
        ListTag objects = (ListTag)scriptEntry.getObjectTag("object");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), objects.debug() + mechanism.debug() + (value == null ? "" : value.debug()));
        }
        ListTag result = new ListTag();
        for (ObjectTag object : objects.objectForms) {
            object = this.adjust(object, mechanism, value, scriptEntry);
            if (objects.size() == 1) {
                scriptEntry.addObject("result", object);
            }
            result.addObject(object);
        }
        scriptEntry.addObject("result_list", result);
    }

    static {
        specialAdjustables.put("system", UtilTagBase::adjustSystem);
    }
}

