/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.core;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;

public class DebugInvalidCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        Debug.echoDebug(scriptEntry, Debug.DebugElement.Header, "Executing command: " + scriptEntry.getCommandName());
        AbstractCommand command = DenizenCore.getCommandRegistry().get(scriptEntry.internal.command);
        if (scriptEntry.internal.brokenArgs) {
            Debug.echoError(scriptEntry.getResidingQueue(), scriptEntry.toString() + " cannot be executed! Is the number of arguments given correct?\nUsage: " + command.getUsageHint());
            return;
        }
        if (command != null) {
            if (command.getOptions().requiredArgs > scriptEntry.getArguments().size()) {
                scriptEntry.internal.brokenArgs = true;
            } else {
                scriptEntry.internal.actualCommand = command;
            }
            scriptEntry.getResidingQueue().injectEntry(scriptEntry, 0);
            return;
        }
        Debug.echoError(scriptEntry.getResidingQueue(), scriptEntry.getCommandName() + " is an invalid command! Are you sure it loaded?");
        Debug.echoDebug((Debuggable)scriptEntry, Debug.DebugElement.Footer);
    }
}

