/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.file;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.DebugLog;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URLDecoder;

public class LogCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("type") && arg.matchesPrefix("type") && arg.matchesEnum(Type.values())) {
                scriptEntry.addObject("type", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("file") && arg.matchesPrefix("file")) {
                scriptEntry.addObject("file", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("message")) {
                scriptEntry.addObject("message", new ElementTag(arg.raw_value));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("message")) {
            throw new InvalidArgumentsException("Must specify a message.");
        }
        if (!scriptEntry.hasObject("file")) {
            throw new InvalidArgumentsException("Must specify a file.");
        }
        if (!scriptEntry.hasObject("type")) {
            scriptEntry.addObject("type", new ElementTag("INFO"));
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        if (!DenizenCore.getImplementation().allowLogging()) {
            Debug.echoError("Logging disabled by administrator.");
            return;
        }
        ElementTag message = scriptEntry.getElement("message");
        ElementTag fileName = scriptEntry.getElement("file");
        ElementTag typeElement = scriptEntry.getElement("type");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), message.debug() + fileName.debug() + typeElement.debug());
        }
        Type type = Type.valueOf(typeElement.asString().toUpperCase());
        String directory = URLDecoder.decode(System.getProperty("user.dir"));
        File file = new File(directory, fileName.asString());
        file.getParentFile().mkdirs();
        if (!DenizenCore.getImplementation().canWriteToFile(file)) {
            Debug.echoError(scriptEntry.getResidingQueue(), "Cannot log into that file!");
            return;
        }
        String output = message.asString();
        file.getParentFile().mkdirs();
        if (type == Type.NONE) {
            try {
                FileWriter fw = new FileWriter(file, true);
                fw.write(output + "\n");
                fw.close();
            }
            catch (IOException e) {
                Debug.echoError(scriptEntry.getResidingQueue(), "Error logging to file...");
                Debug.echoError(scriptEntry.getResidingQueue(), e);
            }
            return;
        }
        if (type == Type.CLEAR) {
            try {
                FileWriter fw = new FileWriter(file);
                if (output.length() > 0) {
                    fw.write(output + "\n");
                }
                fw.close();
            }
            catch (IOException e) {
                Debug.echoError(scriptEntry.getResidingQueue(), "Error logging to file...");
                Debug.echoError(scriptEntry.getResidingQueue(), e);
            }
            return;
        }
        DebugLog log = new DebugLog("Denizen-ScriptLog-" + fileName, file.getAbsolutePath());
        switch (type) {
            case SEVERE: {
                log.severe(output);
                break;
            }
            case INFO: {
                log.info(output);
                break;
            }
            case WARNING: {
                log.warning(output);
                break;
            }
            case FINE: {
                log.fine(output);
                break;
            }
            case FINER: {
                log.finer(output);
                break;
            }
            case FINEST: {
                log.finest(output);
            }
        }
        log.close();
    }

    public static enum Type {
        SEVERE,
        INFO,
        WARNING,
        FINE,
        FINER,
        FINEST,
        NONE,
        CLEAR;

    }
}

