/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.block;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.utilities.blocks.ModernBlockData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockCanBuildEvent;

public class BlockBuiltScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static BlockBuiltScriptEvent instance;
    public LocationTag location;
    public MaterialTag old_material;
    public MaterialTag new_material;
    public BlockCanBuildEvent event;

    public BlockBuiltScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventArgLowerAt(1).equals("being") && path.eventArgLowerAt(2).equals("built");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        String mat2 = path.eventArgLowerAt(4);
        if (mat2.length() > 0 && !this.tryMaterial(this.old_material, mat2)) {
            return false;
        }
        if (!this.tryMaterial(this.new_material, path.eventArgLowerAt(0))) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "BlockBuilt";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        if (determinationObj instanceof ElementTag) {
            String determination = determinationObj.toString();
            String lower = CoreUtilities.toLowerCase(determination);
            if (lower.equals("buildable")) {
                this.cancelled = false;
            }
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public void cancellationChanged() {
        this.event.setBuildable(!this.cancelled);
        super.cancellationChanged();
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("location")) {
            return this.location;
        }
        if (name.equals("new_material")) {
            return this.new_material;
        }
        if (name.equals("old_material")) {
            return this.old_material;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onBlockBuilt(BlockCanBuildEvent event) {
        this.location = new LocationTag(event.getBlock().getLocation());
        this.old_material = new MaterialTag(event.getBlock());
        this.new_material = NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13) ? new MaterialTag(new ModernBlockData(event.getBlockData())) : new MaterialTag(event.getMaterial());
        this.cancelled = !event.isBuildable();
        this.event = event;
        this.fire((Event)event);
    }
}

