/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class PlayerClicksInInventoryScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerClicksInInventoryScriptEvent instance;
    public InventoryTag inventory;
    public ItemTag item;
    public ItemTag cursor;
    public InventoryClickEvent event;

    public PlayerClicksInInventoryScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!path.eventLower.startsWith("player")) {
            return false;
        }
        if (!path.eventArgLowerAt(1).equals("clicks") && !path.eventArgLowerAt(2).equals("clicks")) {
            return false;
        }
        for (String arg : path.eventArgsLower) {
            if (!arg.equals("in")) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        boolean hasClickType = path.eventArgLowerAt(2).equals("clicks");
        if (hasClickType && !path.eventArgLowerAt(1).equals(CoreUtilities.toLowerCase(this.event.getClick().name()))) {
            return false;
        }
        String clickedItemText = path.eventArgLowerAt(hasClickType ? 3 : 2);
        if (!clickedItemText.equals("in") && !this.tryItem(this.item, clickedItemText)) {
            return false;
        }
        int inIndex = -1;
        for (int i = 0; i < path.eventArgsLower.length; ++i) {
            if (!path.eventArgLowerAt(i).equals("in")) continue;
            inIndex = i;
        }
        if (!this.tryInventory(this.inventory, path.eventArgLowerAt(inIndex + 1))) {
            return false;
        }
        int withIndex = -1;
        for (int i = 0; i < path.eventArgsLower.length; ++i) {
            if (!path.eventArgLowerAt(i).equals("with")) continue;
            withIndex = i;
        }
        if (!(withIndex <= 0 || this.event.getCursor() != null && this.tryItem(new ItemTag(this.event.getCursor()), path.eventArgLowerAt(withIndex + 1)))) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        if (!PlayerClicksInInventoryScriptEvent.isDefaultDetermination(determinationObj) && ItemTag.matches(determinationObj.toString())) {
            this.event.setCurrentItem(ItemTag.valueOf(determinationObj.toString(), path.context).getItemStack());
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public String getName() {
        return "PlayerClicksInInventory";
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(new PlayerTag((Player)this.event.getWhoClicked()), null);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("inventory")) {
            return this.inventory;
        }
        if (name.equals("item")) {
            return this.item;
        }
        if (name.equals("cursor_item")) {
            return this.cursor;
        }
        if (name.equals("click")) {
            return new ElementTag(this.event.getClick().name());
        }
        if (name.equals("action")) {
            return new ElementTag(this.event.getAction().name());
        }
        if (name.equals("slot_type")) {
            return new ElementTag(this.event.getSlotType().name());
        }
        if (name.equals("is_shift_click")) {
            return new ElementTag(this.event.isShiftClick());
        }
        if (name.equals("clicked_inventory") && this.event.getClickedInventory() != null) {
            return InventoryTag.mirrorBukkitInventory(this.event.getClickedInventory());
        }
        if (name.equals("slot")) {
            return new ElementTag(this.event.getSlot() + 1);
        }
        if (name.equals("raw_slot")) {
            return new ElementTag(this.event.getRawSlot() + 1);
        }
        if (name.equals("hotbar_button")) {
            return new ElementTag(this.event.getHotbarButton() + 1);
        }
        return super.getContext(name);
    }

    @EventHandler
    public void inventoryClickEvent(InventoryClickEvent event) {
        this.inventory = InventoryTag.mirrorBukkitInventory(event.getInventory());
        this.item = event.getCurrentItem() == null ? new ItemTag(Material.AIR) : new ItemTag(event.getCurrentItem().clone());
        this.cursor = new ItemTag(event.getCursor() == null ? new ItemStack(Material.AIR) : event.getCursor().clone());
        this.event = event;
        this.fire((Event)event);
    }
}

