/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class PlayerStepsOnScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerStepsOnScriptEvent instance;
    public LocationTag location;
    public LocationTag previous_location;
    public LocationTag new_location;
    public PlayerMoveEvent event;

    public PlayerStepsOnScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventLower.startsWith("player steps on");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String mat = path.eventArgLowerAt(3);
        MaterialTag material = new MaterialTag(this.location.getBlock());
        if (!this.tryMaterial(material, mat)) {
            return false;
        }
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "PlayerStepsOn";
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(PlayerTag.mirrorBukkitPlayer((OfflinePlayer)this.event.getPlayer()), null);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("location")) {
            return this.location;
        }
        if (name.equals("previous_location")) {
            return this.previous_location;
        }
        if (name.equals("new_location")) {
            return this.new_location;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPlayerStepsOn(PlayerMoveEvent event) {
        if (EntityTag.isNPC((Entity)event.getPlayer())) {
            return;
        }
        if (LocationTag.isSameBlock(event.getFrom(), event.getTo())) {
            return;
        }
        this.location = new LocationTag(event.getTo().clone().subtract(0.0, 1.0, 0.0));
        if (this.location.getBlockY() < 0 || this.location.getBlockY() > 255) {
            return;
        }
        this.previous_location = new LocationTag(event.getFrom());
        this.new_location = new LocationTag(event.getTo());
        this.event = event;
        this.fire((Event)event);
    }

    @EventHandler
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        if (EntityTag.isNPC((Entity)event.getPlayer())) {
            return;
        }
        PlayerMoveEvent evt = new PlayerMoveEvent(event.getPlayer(), event.getFrom(), event.getTo());
        this.onPlayerStepsOn(evt);
        event.setCancelled(evt.isCancelled());
    }
}

