/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.abstracts;

import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.entity.Player;

public abstract class Sidebar {
    public static final int MAX_LENGTH = 15;
    protected final Player player;
    protected String title;
    protected String[] lines = new String[15];
    protected int[] scores = new int[15];
    public int setCount = 0;

    public Sidebar(Player player) {
        this.player = player;
        this.setTitle("");
    }

    public String getTitle() {
        return this.title;
    }

    public List<SidebarLine> getLines() {
        ArrayList<SidebarLine> toReturn = new ArrayList<SidebarLine>(15);
        for (int i = 0; i < this.setCount; ++i) {
            toReturn.add(new SidebarLine(this.lines[i], this.scores[i]));
        }
        return toReturn;
    }

    public List<String> getLinesText() {
        return new ArrayList<String>(Arrays.asList(this.lines));
    }

    public int[] getScores() {
        return this.scores;
    }

    public final void setTitle(String title) {
        if (title.length() > 32) {
            title = title.substring(0, 32);
        }
        if (this.title == null || !this.title.equals(title)) {
            this.title = title;
            this.setDisplayName(title);
        }
    }

    protected abstract void setDisplayName(String var1);

    public void setLines(List<SidebarLine> lines) {
        int i;
        this.setCount = Math.min(lines.size(), 15);
        for (i = 0; i < this.setCount; ++i) {
            String line = lines.get((int)i).text;
            if (line.length() > 40) {
                line = line.substring(0, 40);
            }
            this.lines[i] = line;
            this.scores[i] = lines.get((int)i).score;
        }
        for (i = this.setCount; i < 15; ++i) {
            this.lines[i] = null;
            this.scores[i] = 0;
        }
    }

    public abstract void sendUpdate();

    public abstract void remove();

    public static class SidebarLine {
        public String text;
        public int score;

        public SidebarLine(String _text, int _score) {
            this.text = CoreUtilities.clearNBSPs(_text);
            this.score = _score;
        }
    }
}

