/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.nms.interfaces.BlockData;
import com.denizenscript.denizen.nms.interfaces.EntityHelper;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.objects.BiomeTag;
import com.denizenscript.denizen.objects.ChunkTag;
import com.denizenscript.denizen.objects.CuboidTag;
import com.denizenscript.denizen.objects.EllipsoidTag;
import com.denizenscript.denizen.objects.EntityFormObject;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.objects.notable.NotableManager;
import com.denizenscript.denizen.objects.properties.material.MaterialDirectional;
import com.denizenscript.denizen.objects.properties.material.MaterialHalf;
import com.denizenscript.denizen.objects.properties.material.MaterialPersistent;
import com.denizenscript.denizen.objects.properties.material.MaterialSwitchFace;
import com.denizenscript.denizen.scripts.commands.world.SwitchCommand;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.Settings;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.blocks.MaterialCompat;
import com.denizenscript.denizen.utilities.blocks.OldMaterialsHelper;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.entity.DenizenEntityType;
import com.denizenscript.denizen.utilities.world.PathFinder;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.notable.Notable;
import com.denizenscript.denizencore.objects.notable.Note;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.tags.core.EscapeTagBase;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Nameable;
import org.bukkit.StructureType;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.block.Banner;
import org.bukkit.block.Beacon;
import org.bukkit.block.Beehive;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.BrewingStand;
import org.bukkit.block.Chest;
import org.bukkit.block.CommandBlock;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.Dispenser;
import org.bukkit.block.DoubleChest;
import org.bukkit.block.Dropper;
import org.bukkit.block.Furnace;
import org.bukkit.block.Lectern;
import org.bukkit.block.Lockable;
import org.bukkit.block.Sign;
import org.bukkit.block.Skull;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.entity.Bee;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.Attachable;
import org.bukkit.material.Door;
import org.bukkit.material.MaterialData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.BlockIterator;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class LocationTag
extends Location
implements ObjectTag,
Notable,
Adjustable {
    public String backupWorld;
    private boolean is2D = false;
    private boolean raw = false;
    String prefix = "Location";
    public static ObjectTagProcessor<LocationTag> tagProcessor = new ObjectTagProcessor();

    public String getWorldName() {
        World w = super.getWorld();
        if (w != null) {
            return w.getName();
        }
        return this.backupWorld;
    }

    public World getWorld() {
        World w = super.getWorld();
        if (w != null) {
            return w;
        }
        if (this.backupWorld == null) {
            return null;
        }
        super.setWorld(Bukkit.getWorld((String)this.backupWorld));
        return super.getWorld();
    }

    public LocationTag clone() {
        return (LocationTag)super.clone();
    }

    @Override
    public void makeUnique(String id) {
        NotableManager.saveAs(this, id);
    }

    @Override
    @Note(value="Locations")
    public String getSaveObject() {
        return this.getX() + "," + this.getY() + "," + this.getZ() + "," + this.getPitch() + "," + this.getYaw() + "," + this.getWorldName();
    }

    public static String getSaved(LocationTag location) {
        for (LocationTag saved : NotableManager.getAllType(LocationTag.class)) {
            if (saved.getX() != location.getX() || saved.getY() != location.getY() || saved.getZ() != location.getZ() || saved.getYaw() != location.getYaw() || saved.getPitch() != location.getPitch() || (saved.getWorldName() != null || location.getWorldName() != null) && (saved.getWorldName() == null || location.getWorldName() == null || !saved.getWorldName().equals(location.getWorldName()))) continue;
            return NotableManager.getSavedId(saved);
        }
        return null;
    }

    @Override
    public void forget() {
        NotableManager.remove(this);
    }

    public static LocationTag valueOf(String string) {
        return LocationTag.valueOf(string, null);
    }

    @Fetchable(value="l")
    public static LocationTag valueOf(String string, TagContext context) {
        Notable noted;
        if (string == null) {
            return null;
        }
        if (string.startsWith("l@")) {
            string = string.substring(2);
        }
        if ((noted = NotableManager.getSavedObject(string)) instanceof LocationTag) {
            return (LocationTag)noted;
        }
        List<String> split = CoreUtilities.split(string, ',');
        if (split.size() == 2) {
            try {
                return new LocationTag(null, Double.valueOf(split.get(0)), Double.valueOf(split.get(1)));
            }
            catch (Exception e) {
                if (context == null || context.debug) {
                    Debug.log("Minor: valueOf LocationTag returning null: " + string + "(internal exception:" + e.getMessage() + ")");
                }
                return null;
            }
        }
        if (split.size() == 3) {
            try {
                World world;
                String worldName = split.get(2);
                if (worldName.startsWith("w@")) {
                    worldName = worldName.substring("w@".length());
                }
                if ((world = Bukkit.getWorld((String)worldName)) != null) {
                    return new LocationTag(world, Double.valueOf(split.get(0)), Double.valueOf(split.get(1)));
                }
                if (ArgumentHelper.matchesDouble(split.get(2))) {
                    return new LocationTag(null, (double)Double.valueOf(split.get(0)), (double)Double.valueOf(split.get(1)), Double.valueOf(split.get(2)));
                }
                LocationTag output = new LocationTag(null, Double.valueOf(split.get(0)), Double.valueOf(split.get(1)));
                output.backupWorld = worldName;
                return output;
            }
            catch (Exception e) {
                if (context == null || context.debug) {
                    Debug.log("Minor: valueOf LocationTag returning null: " + string + "(internal exception:" + e.getMessage() + ")");
                }
                return null;
            }
        }
        if (split.size() == 4) {
            try {
                World world;
                String worldName = split.get(3);
                if (worldName.startsWith("w@")) {
                    worldName = worldName.substring("w@".length());
                }
                if ((world = Bukkit.getWorld((String)worldName)) != null) {
                    return new LocationTag(world, (double)Double.valueOf(split.get(0)), (double)Double.valueOf(split.get(1)), Double.valueOf(split.get(2)));
                }
                LocationTag output = new LocationTag(null, (double)Double.valueOf(split.get(0)), (double)Double.valueOf(split.get(1)), Double.valueOf(split.get(2)));
                output.backupWorld = worldName;
                return output;
            }
            catch (Exception e) {
                if (context == null || context.debug) {
                    Debug.log("Minor: valueOf LocationTag returning null: " + string + "(internal exception:" + e.getMessage() + ")");
                }
                return null;
            }
        }
        if (split.size() == 5) {
            try {
                return new LocationTag(null, Double.valueOf(split.get(0)), Double.valueOf(split.get(1)), Double.valueOf(split.get(2)), Float.valueOf(split.get(3)).floatValue(), Float.valueOf(split.get(4)).floatValue());
            }
            catch (Exception e) {
                if (context == null || context.debug) {
                    Debug.log("Minor: valueOf LocationTag returning null: " + string + "(internal exception:" + e.getMessage() + ")");
                }
                return null;
            }
        }
        if (split.size() == 6) {
            try {
                World world;
                String worldName = split.get(5);
                if (worldName.startsWith("w@")) {
                    worldName = worldName.substring("w@".length());
                }
                if ((world = Bukkit.getWorld((String)worldName)) != null) {
                    return new LocationTag(world, Double.valueOf(split.get(0)), Double.valueOf(split.get(1)), Double.valueOf(split.get(2)), Float.valueOf(split.get(3)).floatValue(), Float.valueOf(split.get(4)).floatValue());
                }
                LocationTag output = new LocationTag(null, Double.valueOf(split.get(0)), Double.valueOf(split.get(1)), Double.valueOf(split.get(2)), Float.valueOf(split.get(3)).floatValue(), Float.valueOf(split.get(4)).floatValue());
                output.backupWorld = worldName;
                return output;
            }
            catch (Exception e) {
                if (context == null || context.debug) {
                    Debug.log("Minor: valueOf LocationTag returning null: " + string + "(internal exception:" + e.getMessage() + ")");
                }
                return null;
            }
        }
        if (context == null || context.debug) {
            Debug.log("Minor: valueOf LocationTag returning null: " + string);
        }
        return null;
    }

    public static boolean matches(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        if (string.startsWith("l@")) {
            return true;
        }
        return LocationTag.valueOf(string, new BukkitTagContext(null, null, null, false, null)) != null;
    }

    public LocationTag(Location location) {
        super(location.getWorld(), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    public LocationTag(Vector vector) {
        super(null, vector.getX(), vector.getY(), vector.getZ());
    }

    public LocationTag(World world, Vector vector) {
        super(world, vector.getX(), vector.getY(), vector.getZ());
    }

    public LocationTag(World world, double x, double y) {
        this(world, x, y, 0.0);
        this.is2D = true;
    }

    public LocationTag(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public LocationTag(double x, double y, double z, String worldName) {
        super(worldName == null ? null : Bukkit.getWorld((String)worldName), x, y, z);
        this.backupWorld = worldName;
    }

    public LocationTag(World world, double x, double y, double z, float pitch, float yaw) {
        super(world, x, y, z, yaw, pitch);
    }

    public boolean isChunkLoaded() {
        return this.getWorld() != null && this.getWorld().isChunkLoaded(this.getBlockX() >> 4, this.getBlockZ() >> 4);
    }

    public boolean isChunkLoadedSafe() {
        try {
            NMSHandler.getChunkHelper().changeChunkServerThread(this.getWorld());
            boolean bl = this.isChunkLoaded();
            return bl;
        }
        finally {
            NMSHandler.getChunkHelper().restoreServerThread(this.getWorld());
        }
    }

    public Block getBlock() {
        if (this.getWorld() == null) {
            Debug.echoError("LocationTag trying to read block, but cannot because no world is specified.");
            return null;
        }
        return super.getBlock();
    }

    public Block getBlockForTag(Attribute attribute) {
        NMSHandler.getChunkHelper().changeChunkServerThread(this.getWorld());
        try {
            if (this.getWorld() == null) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("LocationTag trying to read block, but cannot because no world is specified.");
                }
                Block block = null;
                return block;
            }
            if (!this.isChunkLoaded()) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("LocationTag trying to read block, but cannot because the chunk is unloaded. Use the 'chunkload' command to ensure the chunk is loaded.");
                }
                Block block = null;
                return block;
            }
            Block block = super.getBlock();
            return block;
        }
        finally {
            NMSHandler.getChunkHelper().restoreServerThread(this.getWorld());
        }
    }

    public Material getBlockTypeForTag(Attribute attribute) {
        NMSHandler.getChunkHelper().changeChunkServerThread(this.getWorld());
        try {
            if (this.getWorld() == null) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("LocationTag trying to read block, but cannot because no world is specified.");
                }
                Material material = null;
                return material;
            }
            if (!this.isChunkLoaded()) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("LocationTag trying to read block, but cannot because the chunk is unloaded. Use the 'chunkload' command to ensure the chunk is loaded.");
                }
                Material material = null;
                return material;
            }
            Material material = super.getBlock().getType();
            return material;
        }
        finally {
            NMSHandler.getChunkHelper().restoreServerThread(this.getWorld());
        }
    }

    public static BlockState getBlockStateSafe(Block block) {
        NMSHandler.getChunkHelper().changeChunkServerThread(block.getWorld());
        try {
            BlockState blockState = block.getState();
            return blockState;
        }
        finally {
            NMSHandler.getChunkHelper().restoreServerThread(block.getWorld());
        }
    }

    public Biome getBiomeForTag(Attribute attribute) {
        NMSHandler.getChunkHelper().changeChunkServerThread(this.getWorld());
        try {
            if (this.getWorld() == null) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("LocationTag trying to read block, but cannot because no world is specified.");
                }
                Biome biome = null;
                return biome;
            }
            if (!this.isChunkLoaded()) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("LocationTag trying to read block, but cannot because the chunk is unloaded. Use the 'chunkload' command to ensure the chunk is loaded.");
                }
                Biome biome = null;
                return biome;
            }
            Biome biome = super.getBlock().getBiome();
            return biome;
        }
        finally {
            NMSHandler.getChunkHelper().restoreServerThread(this.getWorld());
        }
    }

    public Location getHighestBlockForTag(Attribute attribute) {
        NMSHandler.getChunkHelper().changeChunkServerThread(this.getWorld());
        try {
            if (this.getWorld() == null) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("LocationTag trying to read block, but cannot because no world is specified.");
                }
                Location location = null;
                return location;
            }
            if (!this.isChunkLoaded()) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("LocationTag trying to read block, but cannot because the chunk is unloaded. Use the 'chunkload' command to ensure the chunk is loaded.");
                }
                Location location = null;
                return location;
            }
            Location location = this.getWorld().getHighestBlockAt((Location)this).getLocation();
            return location;
        }
        finally {
            NMSHandler.getChunkHelper().restoreServerThread(this.getWorld());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ItemStack> getDropsForTag(Attribute attribute, ItemStack item) {
        NMSHandler.getChunkHelper().changeChunkServerThread(this.getWorld());
        try {
            if (this.getWorld() == null) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("LocationTag trying to read block, but cannot because no world is specified.");
                }
                Collection<ItemStack> collection = null;
                return collection;
            }
            if (!this.isChunkLoaded()) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("LocationTag trying to read block, but cannot because the chunk is unloaded. Use the 'chunkload' command to ensure the chunk is loaded.");
                }
                Collection<ItemStack> collection = null;
                return collection;
            }
            Collection collection = item == null ? super.getBlock().getDrops() : super.getBlock().getDrops(item);
            return collection;
        }
        finally {
            NMSHandler.getChunkHelper().restoreServerThread(this.getWorld());
        }
    }

    public BlockState getBlockState() {
        return this.getBlock().getState();
    }

    public BlockState getBlockStateForTag(Attribute attribute) {
        Block block = this.getBlockForTag(attribute);
        if (block == null) {
            return null;
        }
        return LocationTag.getBlockStateSafe(block);
    }

    public static boolean isSameBlock(Location a, Location b) {
        return a != null && b != null && a.getWorld() == b.getWorld() && a.getBlockX() == b.getBlockX() && a.getBlockY() == b.getBlockY() && a.getBlockZ() == b.getBlockZ();
    }

    public LocationTag getBlockLocation() {
        return new LocationTag(this.getWorld(), (double)this.getBlockX(), (double)this.getBlockY(), this.getBlockZ());
    }

    private void setRaw(boolean state) {
        this.raw = state;
    }

    public void setPitch(float pitch) {
        super.setPitch(pitch);
    }

    public void setYaw(float yaw) {
        super.setYaw(yaw);
    }

    public boolean hasInventory() {
        return this.getBlockState() instanceof InventoryHolder;
    }

    public Inventory getBukkitInventory() {
        return this.hasInventory() ? ((InventoryHolder)this.getBlockState()).getInventory() : null;
    }

    public InventoryTag getInventory() {
        return this.hasInventory() ? InventoryTag.mirrorBukkitInventory(this.getBukkitInventory()) : null;
    }

    public BlockFace getSkullBlockFace(int rotation) {
        switch (rotation) {
            case 0: {
                return BlockFace.NORTH;
            }
            case 1: {
                return BlockFace.NORTH_NORTH_EAST;
            }
            case 2: {
                return BlockFace.NORTH_EAST;
            }
            case 3: {
                return BlockFace.EAST_NORTH_EAST;
            }
            case 4: {
                return BlockFace.EAST;
            }
            case 5: {
                return BlockFace.EAST_SOUTH_EAST;
            }
            case 6: {
                return BlockFace.SOUTH_EAST;
            }
            case 7: {
                return BlockFace.SOUTH_SOUTH_EAST;
            }
            case 8: {
                return BlockFace.SOUTH;
            }
            case 9: {
                return BlockFace.SOUTH_SOUTH_WEST;
            }
            case 10: {
                return BlockFace.SOUTH_WEST;
            }
            case 11: {
                return BlockFace.WEST_SOUTH_WEST;
            }
            case 12: {
                return BlockFace.WEST;
            }
            case 13: {
                return BlockFace.WEST_NORTH_WEST;
            }
            case 14: {
                return BlockFace.NORTH_WEST;
            }
            case 15: {
                return BlockFace.NORTH_NORTH_WEST;
            }
        }
        return null;
    }

    public byte getSkullRotation(BlockFace face) {
        switch (face) {
            case NORTH: {
                return 0;
            }
            case NORTH_NORTH_EAST: {
                return 1;
            }
            case NORTH_EAST: {
                return 2;
            }
            case EAST_NORTH_EAST: {
                return 3;
            }
            case EAST: {
                return 4;
            }
            case EAST_SOUTH_EAST: {
                return 5;
            }
            case SOUTH_EAST: {
                return 6;
            }
            case SOUTH_SOUTH_EAST: {
                return 7;
            }
            case SOUTH: {
                return 8;
            }
            case SOUTH_SOUTH_WEST: {
                return 9;
            }
            case SOUTH_WEST: {
                return 10;
            }
            case WEST_SOUTH_WEST: {
                return 11;
            }
            case WEST: {
                return 12;
            }
            case WEST_NORTH_WEST: {
                return 13;
            }
            case NORTH_WEST: {
                return 14;
            }
            case NORTH_NORTH_WEST: {
                return 15;
            }
        }
        return -1;
    }

    public int compare(Location loc1, Location loc2) {
        if (loc1 == null || loc2 == null || loc1.equals((Object)loc2)) {
            return 0;
        }
        return Double.compare(this.distanceSquared(loc1), this.distanceSquared(loc2));
    }

    public int hashCode() {
        return (int)(Math.floor(this.getX()) + Math.floor(this.getY()) + Math.floor(this.getZ()));
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof LocationTag)) {
            return false;
        }
        LocationTag other = (LocationTag)o;
        if (other.getWorldName() == null && this.getWorldName() != null || this.getWorldName() == null && other.getWorldName() != null || this.getWorldName() != null && other.getWorldName() != null && !this.getWorldName().equalsIgnoreCase(other.getWorldName())) {
            return false;
        }
        return Math.floor(this.getX()) == Math.floor(other.getX()) && Math.floor(this.getY()) == Math.floor(other.getY()) && Math.floor(this.getZ()) == Math.floor(other.getZ());
    }

    @Override
    public String getObjectType() {
        return "Location";
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public LocationTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public String debuggable() {
        if (this.isUnique()) {
            return "<Y>" + LocationTag.getSaved(this) + "<GR> (" + this.identifyRaw().replace(",", "<G>,<GR> ") + "<GR>)";
        }
        return "<Y>" + this.identifyRaw().replace(",", "<G>,<Y> ");
    }

    @Override
    public boolean isUnique() {
        return LocationTag.getSaved(this) != null;
    }

    @Override
    public String identify() {
        if (!this.raw && this.isUnique()) {
            return "l@" + LocationTag.getSaved(this);
        }
        return this.identifyRaw();
    }

    @Override
    public String identifySimple() {
        if (this.isUnique()) {
            return "l@" + LocationTag.getSaved(this);
        }
        if (this.getWorldName() == null) {
            return "l@" + this.getBlockX() + "," + this.getBlockY() + (!this.is2D ? "," + this.getBlockZ() : "");
        }
        return "l@" + this.getBlockX() + "," + this.getBlockY() + (!this.is2D ? "," + this.getBlockZ() : "") + "," + this.getWorldName();
    }

    public String identifyRaw() {
        if ((double)this.getYaw() != 0.0 || (double)this.getPitch() != 0.0) {
            return "l@" + CoreUtilities.doubleToString(this.getX()) + "," + CoreUtilities.doubleToString(this.getY()) + "," + CoreUtilities.doubleToString(this.getZ()) + "," + CoreUtilities.doubleToString(this.getPitch()) + "," + CoreUtilities.doubleToString(this.getYaw()) + (this.getWorldName() != null ? "," + this.getWorldName() : "");
        }
        return "l@" + CoreUtilities.doubleToString(this.getX()) + "," + CoreUtilities.doubleToString(this.getY()) + (!this.is2D ? "," + CoreUtilities.doubleToString(this.getZ()) : "") + (this.getWorldName() != null ? "," + this.getWorldName() : "");
    }

    public String toString() {
        return this.identify();
    }

    public static void registerTags() {
        LocationTag.registerTag("block_facing", (attribute, object) -> {
            Block block = object.getBlockForTag(attribute);
            MaterialTag material = new MaterialTag(block);
            if (!MaterialDirectional.describes(material)) {
                return null;
            }
            Vector vec = MaterialDirectional.getFrom(material).getDirectionVector();
            if (vec == null) {
                return null;
            }
            return new LocationTag(object.getWorld(), vec);
        }, new String[0]);
        LocationTag.registerTag("with_facing_direction", (attribute, object) -> {
            Block block = object.getBlockForTag(attribute);
            MaterialTag material = new MaterialTag(block);
            if (!MaterialDirectional.describes(material)) {
                return null;
            }
            Vector facing = MaterialDirectional.getFrom(material).getDirectionVector();
            if (facing == null) {
                return null;
            }
            LocationTag result = object.clone();
            result.setDirection(facing);
            return result;
        }, new String[0]);
        LocationTag.registerTag("above", (attribute, object) -> new LocationTag(object.clone().add(0.0, attribute.hasContext(1) ? attribute.getDoubleContext(1) : 1.0, 0.0)), new String[0]);
        LocationTag.registerTag("below", (attribute, object) -> new LocationTag(object.clone().subtract(0.0, attribute.hasContext(1) ? attribute.getDoubleContext(1) : 1.0, 0.0)), new String[0]);
        LocationTag.registerTag("forward_flat", (attribute, object) -> {
            LocationTag loc = object.clone();
            loc.setPitch(0.0f);
            Vector vector = loc.getDirection().multiply(attribute.hasContext(1) ? attribute.getDoubleContext(1) : 1.0);
            return new LocationTag(object.clone().add(vector));
        }, new String[0]);
        LocationTag.registerTag("backward_flat", (attribute, object) -> {
            LocationTag loc = object.clone();
            loc.setPitch(0.0f);
            Vector vector = loc.getDirection().multiply(attribute.hasContext(1) ? attribute.getDoubleContext(1) : 1.0);
            return new LocationTag(object.clone().subtract(vector));
        }, new String[0]);
        LocationTag.registerTag("forward", (attribute, object) -> {
            Vector vector = object.getDirection().multiply(attribute.hasContext(1) ? attribute.getDoubleContext(1) : 1.0);
            return new LocationTag(object.clone().add(vector));
        }, new String[0]);
        LocationTag.registerTag("backward", (attribute, object) -> {
            Vector vector = object.getDirection().multiply(attribute.hasContext(1) ? attribute.getDoubleContext(1) : 1.0);
            return new LocationTag(object.clone().subtract(vector));
        }, new String[0]);
        LocationTag.registerTag("left", (attribute, object) -> {
            LocationTag loc = object.clone();
            loc.setPitch(0.0f);
            Vector vector = loc.getDirection().rotateAroundY(1.5707963267948966).multiply(attribute.hasContext(1) ? attribute.getDoubleContext(1) : 1.0);
            return new LocationTag(object.clone().add(vector));
        }, new String[0]);
        LocationTag.registerTag("right", (attribute, object) -> {
            LocationTag loc = object.clone();
            loc.setPitch(0.0f);
            Vector vector = loc.getDirection().rotateAroundY(1.5707963267948966).multiply(attribute.hasContext(1) ? attribute.getDoubleContext(1) : 1.0);
            return new LocationTag(object.clone().subtract(vector));
        }, new String[0]);
        LocationTag.registerTag("up", (attribute, object) -> {
            LocationTag loc = object.clone();
            loc.setPitch(loc.getPitch() - 90.0f);
            Vector vector = loc.getDirection().multiply(attribute.hasContext(1) ? attribute.getDoubleContext(1) : 1.0);
            return new LocationTag(object.clone().add(vector));
        }, new String[0]);
        LocationTag.registerTag("down", (attribute, object) -> {
            LocationTag loc = object.clone();
            loc.setPitch(loc.getPitch() - 90.0f);
            Vector vector = loc.getDirection().multiply(attribute.hasContext(1) ? attribute.getDoubleContext(1) : 1.0);
            return new LocationTag(object.clone().subtract(vector));
        }, new String[0]);
        LocationTag.registerTag("relative", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            LocationTag offsetLoc = LocationTag.valueOf(attribute.getContext(1));
            if (offsetLoc == null) {
                return null;
            }
            LocationTag loc = object.clone();
            Vector offset = loc.getDirection().multiply(offsetLoc.getZ());
            loc.setPitch(loc.getPitch() - 90.0f);
            offset = offset.add(loc.getDirection().multiply(offsetLoc.getY()));
            loc.setPitch(0.0f);
            offset = offset.add(loc.getDirection().rotateAroundY(1.5707963267948966).multiply(offsetLoc.getX()));
            return new LocationTag(object.clone().add(offset));
        }, new String[0]);
        LocationTag.registerTag("block", (attribute, object) -> new LocationTag(object.getWorld(), (double)object.getBlockX(), (double)object.getBlockY(), object.getBlockZ()), new String[0]);
        LocationTag.registerTag("center", (attribute, object) -> new LocationTag(object.getWorld(), (double)object.getBlockX() + 0.5, (double)object.getBlockY() + 0.5, (double)object.getBlockZ() + 0.5), new String[0]);
        LocationTag.registerTag("highest", (attribute, object) -> {
            Location result = object.getHighestBlockForTag(attribute);
            if (NMSHandler.getVersion().isAtMost(NMSVersion.v1_14)) {
                result = result.subtract(0.0, 1.0, 0.0);
            }
            return new LocationTag(result);
        }, new String[0]);
        LocationTag.registerTag("base_color", (attribute, object) -> {
            DyeColor color;
            if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13)) {
                Debug.echoError("Base_Color tag no longer relevant: banner types are now distinct materials.");
            }
            return new ElementTag((color = ((Banner)object.getBlockStateForTag(attribute)).getBaseColor()) != null ? color.name() : "BLACK");
        }, new String[0]);
        LocationTag.registerTag("has_inventory", (attribute, object) -> new ElementTag(object.getBlockStateForTag(attribute) instanceof InventoryHolder), new String[0]);
        LocationTag.registerTag("inventory", (attribute, object) -> {
            if (!object.isChunkLoadedSafe()) {
                return null;
            }
            return ElementTag.handleNull(object.identify() + ".inventory", object.getInventory(), "InventoryTag", attribute.hasAlternative());
        }, new String[0]);
        LocationTag.registerTag("material", (attribute, object) -> {
            Block block = object.getBlockForTag(attribute);
            if (block == null) {
                return null;
            }
            return new MaterialTag(block);
        }, new String[0]);
        LocationTag.registerTag("patterns", (attribute, object) -> {
            ListTag list = new ListTag();
            for (Pattern pattern : ((Banner)object.getBlockStateForTag(attribute)).getPatterns()) {
                list.add(pattern.getColor().name() + "/" + pattern.getPattern().name());
            }
            return list;
        }, new String[0]);
        LocationTag.registerTag("head_rotation", (attribute, object) -> new ElementTag(object.getSkullRotation(((Skull)object.getBlockStateForTag(attribute)).getRotation()) + 1), new String[0]);
        LocationTag.registerTag("switched", (attribute, object) -> new ElementTag(SwitchCommand.switchState(object.getBlockForTag(attribute))), new String[0]);
        LocationTag.registerTag("sign_contents", (attribute, object) -> {
            if (object.getBlockStateForTag(attribute) instanceof Sign) {
                return new ListTag(Arrays.asList(((Sign)object.getBlockStateForTag(attribute)).getLines()));
            }
            return null;
        }, new String[0]);
        LocationTag.registerTag("spawner_type", (attribute, object) -> {
            if (object.getBlockStateForTag(attribute) instanceof CreatureSpawner) {
                return new EntityTag(DenizenEntityType.getByName(((CreatureSpawner)object.getBlockStateForTag(attribute)).getSpawnedType().name()));
            }
            return null;
        }, new String[0]);
        LocationTag.registerTag("lock", (attribute, object) -> {
            if (!(object.getBlockStateForTag(attribute) instanceof Lockable)) {
                return null;
            }
            Lockable lock = (Lockable)object.getBlockStateForTag(attribute);
            return new ElementTag(lock.isLocked() ? lock.getLock() : null);
        }, new String[0]);
        LocationTag.registerTag("is_locked", (attribute, object) -> {
            if (!(object.getBlockStateForTag(attribute) instanceof Lockable)) {
                return null;
            }
            return new ElementTag(((Lockable)object.getBlockStateForTag(attribute)).isLocked());
        }, new String[0]);
        LocationTag.registerTag("is_lockable", (attribute, object) -> new ElementTag(object.getBlockStateForTag(attribute) instanceof Lockable), new String[0]);
        LocationTag.registerTag("drops", (attribute, object) -> {
            ItemStack inputItem = null;
            if (attribute.hasContext(1)) {
                inputItem = ItemTag.valueOf(attribute.getContext(1), attribute.context).getItemStack();
            }
            ListTag list = new ListTag();
            for (ItemStack it : object.getDropsForTag(attribute, inputItem)) {
                list.addObject(new ItemTag(it));
            }
            return list;
        }, new String[0]);
        LocationTag.registerTag("flowerpot_contents", (attribute, object) -> {
            if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13)) {
                Debug.echoError("As of Minecraft version 1.13 potted flowers each have their own material, such as POTTED_CACTUS.");
            } else if (object.getBlockTypeForTag(attribute) == Material.FLOWER_POT) {
                MaterialData contents = NMSHandler.getBlockHelper().getFlowerpotContents(object.getBlockForTag(attribute));
                return OldMaterialsHelper.getMaterialFrom(contents.getItemType(), contents.getData());
            }
            return null;
        }, new String[0]);
        LocationTag.registerTag("hive_bee_count", (attribute, object) -> new ElementTag(((Beehive)object.getBlockStateForTag(attribute)).getEntityCount()), new String[0]);
        LocationTag.registerTag("hive_max_bees", (attribute, object) -> new ElementTag(((Beehive)object.getBlockStateForTag(attribute)).getMaxEntities()), new String[0]);
        LocationTag.registerTag("skull_type", (attribute, object) -> {
            BlockState blockState = object.getBlockStateForTag(attribute);
            if (blockState instanceof Skull) {
                String t = ((Skull)blockState).getSkullType().name();
                return new ElementTag(t);
            }
            return null;
        }, new String[0]);
        LocationTag.registerTag("skull_name", (attribute, object) -> {
            BlockState blockState = object.getBlockStateForTag(attribute);
            if (blockState instanceof Skull) {
                PlayerProfile profile = NMSHandler.getBlockHelper().getPlayerProfile((Skull)blockState);
                if (profile == null) {
                    return null;
                }
                String n = profile.getName();
                if (n == null) {
                    n = ((Skull)blockState).getOwningPlayer().getName();
                }
                return new ElementTag(n);
            }
            return null;
        }, new String[0]);
        LocationTag.registerTag("skull_skin", (attribute, object) -> {
            BlockState blockState = object.getBlockStateForTag(attribute);
            if (blockState instanceof Skull) {
                PlayerProfile profile = NMSHandler.getBlockHelper().getPlayerProfile((Skull)blockState);
                if (profile == null) {
                    return null;
                }
                String name = profile.getName();
                UUID uuid = profile.getUniqueId();
                String texture = profile.getTexture();
                if (attribute.startsWith("full", 2)) {
                    attribute.fulfill(1);
                    return new ElementTag((uuid != null ? uuid : name) + (texture != null ? "|" + texture : ""));
                }
                return new ElementTag(uuid != null ? uuid.toString() : name);
            }
            return null;
        }, new String[0]);
        LocationTag.registerTag("round", (attribute, object) -> {
            LocationTag result = object.clone();
            result.setX(Math.round(result.getX()));
            result.setY(Math.round(result.getY()));
            result.setZ(Math.round(result.getZ()));
            result.setYaw(Math.round(result.getYaw()));
            result.setPitch(Math.round(result.getPitch()));
            return result;
        }, new String[0]);
        LocationTag.registerTag("round_up", (attribute, object) -> {
            LocationTag result = object.clone();
            result.setX(Math.ceil(result.getX()));
            result.setY(Math.ceil(result.getY()));
            result.setZ(Math.ceil(result.getZ()));
            result.setYaw((float)Math.ceil(result.getYaw()));
            result.setPitch((float)Math.ceil(result.getPitch()));
            return result;
        }, new String[0]);
        LocationTag.registerTag("round_down", (attribute, object) -> {
            LocationTag result = object.clone();
            result.setX(Math.floor(result.getX()));
            result.setY(Math.floor(result.getY()));
            result.setZ(Math.floor(result.getZ()));
            result.setYaw((float)Math.floor(result.getYaw()));
            result.setPitch((float)Math.floor(result.getPitch()));
            return result;
        }, new String[0]);
        LocationTag.registerTag("round_to", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag LocationTag.round_to[...] must have a value.");
                return null;
            }
            LocationTag result = object.clone();
            int ten = (int)Math.pow(10.0, attribute.getIntContext(1));
            result.setX((double)Math.round(result.getX() * (double)ten) / (double)ten);
            result.setY((double)Math.round(result.getY() * (double)ten) / (double)ten);
            result.setZ((double)Math.round(result.getZ() * (double)ten) / (double)ten);
            result.setYaw((float)Math.round(result.getYaw() * (float)ten) / (float)ten);
            result.setPitch((float)Math.round(result.getPitch() * (float)ten) / (float)ten);
            return result;
        }, new String[0]);
        LocationTag.registerTag("round_to_precision", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag LocationTag.round_to_precision[...] must have a value.");
                return null;
            }
            LocationTag result = object.clone();
            float precision = (float)attribute.getDoubleContext(1);
            result.setX((double)Math.round(result.getX() * (double)precision) / (double)precision);
            result.setY((double)Math.round(result.getY() * (double)precision) / (double)precision);
            result.setZ((double)Math.round(result.getZ() * (double)precision) / (double)precision);
            result.setYaw((float)Math.round(result.getYaw() * precision) / precision);
            result.setPitch((float)Math.round(result.getPitch() * precision) / precision);
            return result;
        }, new String[0]);
        LocationTag.registerTag("simple", (attribute, object) -> {
            if (attribute.startsWith("formatted", 2)) {
                attribute.fulfill(1);
                return new ElementTag("X '" + object.getBlockX() + "', Y '" + object.getBlockY() + "', Z '" + object.getBlockZ() + "', in world '" + object.getWorldName() + "'");
            }
            if (object.getWorldName() == null) {
                return new ElementTag(object.getBlockX() + "," + object.getBlockY() + "," + object.getBlockZ());
            }
            return new ElementTag(object.getBlockX() + "," + object.getBlockY() + "," + object.getBlockZ() + "," + object.getWorldName());
        }, new String[0]);
        LocationTag.registerTag("precise_impact_normal", (attribute, object) -> {
            Location location;
            int range = attribute.getIntContext(1);
            if (range < 1) {
                range = 200;
            }
            if ((location = NMSHandler.getEntityHelper().getImpactNormal((Location)object, object.getDirection(), range)) != null) {
                return new LocationTag(location);
            }
            return null;
        }, new String[0]);
        LocationTag.registerTag("precise_cursor_on_block", (attribute, object) -> {
            Location location;
            int range = attribute.getIntContext(1);
            if (range < 1) {
                range = 200;
            }
            if ((location = NMSHandler.getEntityHelper().rayTraceBlock((Location)object, object.getDirection(), range)) != null) {
                return new LocationTag(location).getBlockLocation();
            }
            return null;
        }, new String[0]);
        LocationTag.registerTag("precise_cursor_on", (attribute, object) -> {
            Location location;
            int range = attribute.getIntContext(1);
            if (range < 1) {
                range = 200;
            }
            if ((location = NMSHandler.getEntityHelper().rayTrace((Location)object, object.getDirection(), range)) != null) {
                return new LocationTag(location);
            }
            return null;
        }, new String[0]);
        LocationTag.registerTag("precise_target", (attribute, object) -> {
            RayTraceResult result;
            int range = attribute.getIntContext(1);
            if (range < 1) {
                range = 100;
            }
            if (attribute.startsWith("type", 2) && attribute.hasContext(2)) {
                attribute.fulfill(1);
                HashSet<EntityType> types = new HashSet<EntityType>();
                for (String str : ListTag.valueOf(attribute.getContext(1), attribute.context)) {
                    types.add(EntityTag.valueOf(str).getBukkitEntityType());
                }
                result = object.getWorld().rayTraceEntities((Location)object, object.getDirection(), (double)range, e -> types.contains(e.getType()));
            } else {
                result = object.getWorld().rayTraceEntities((Location)object, object.getDirection(), (double)range);
            }
            if (result != null && result.getHitEntity() != null) {
                return new EntityTag(result.getHitEntity());
            }
            return null;
        }, new String[0]);
        LocationTag.registerTag("precise_target_position", (attribute, object) -> {
            RayTraceResult result;
            int range = attribute.getIntContext(1);
            if (range < 1) {
                range = 100;
            }
            if ((result = object.getWorld().rayTraceEntities((Location)object, object.getDirection(), (double)range)) != null) {
                return new LocationTag(object.getWorld(), result.getHitPosition());
            }
            return null;
        }, new String[0]);
        LocationTag.registerTag("points_between", (attribute, object) -> {
            LocationTag target = LocationTag.valueOf(attribute.getContext(1));
            if (target == null) {
                return null;
            }
            double rad = 1.0;
            if (attribute.startsWith("distance", 2)) {
                rad = attribute.getDoubleContext(2);
                attribute.fulfill(1);
            }
            ListTag list = new ListTag();
            Vector rel = target.toVector().subtract(object.toVector());
            double len = rel.length();
            rel = rel.multiply(1.0 / len);
            for (double i = 0.0; i <= len; i += rad) {
                list.addObject(new LocationTag(object.clone().add(rel.clone().multiply(i))));
            }
            return list;
        }, new String[0]);
        LocationTag.registerTag("facing_blocks", (attribute, object) -> {
            int range = attribute.getIntContext(1);
            if (range < 1) {
                range = 100;
            }
            ListTag list = new ListTag();
            try {
                NMSHandler.getChunkHelper().changeChunkServerThread(object.getWorld());
                BlockIterator iterator = new BlockIterator((Location)object, 0.0, range);
                while (iterator.hasNext()) {
                    list.addObject(new LocationTag(iterator.next().getLocation()));
                }
            }
            finally {
                NMSHandler.getChunkHelper().restoreServerThread(object.getWorld());
            }
            return list;
        }, new String[0]);
        LocationTag.registerTag("line_of_sight", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            LocationTag location = LocationTag.valueOf(attribute.getContext(1));
            if (location != null) {
                try {
                    NMSHandler.getChunkHelper().changeChunkServerThread(object.getWorld());
                    ElementTag elementTag = new ElementTag(NMSHandler.getEntityHelper().canTrace(object.getWorld(), object.toVector(), location.toVector()));
                    return elementTag;
                }
                finally {
                    NMSHandler.getChunkHelper().restoreServerThread(object.getWorld());
                }
            }
            return null;
        }, new String[0]);
        LocationTag.registerTag("direction", (attribute, object) -> {
            if (attribute.startsWith("vector", 2)) {
                attribute.fulfill(1);
                return new LocationTag(object.getWorld(), object.getDirection());
            }
            if (attribute.hasContext(1) && LocationTag.matches(attribute.getContext(1))) {
                LocationTag target = LocationTag.valueOf(attribute.getContext(1));
                EntityHelper entityHelper = NMSHandler.getEntityHelper();
                if (attribute.startsWith("yaw", 2)) {
                    attribute.fulfill(1);
                    return new ElementTag(entityHelper.normalizeYaw(entityHelper.getYaw(target.toVector().subtract(object.toVector()).normalize())));
                }
                return new ElementTag(entityHelper.getCardinal(entityHelper.getYaw(target.toVector().subtract(object.toVector()).normalize())));
            }
            return new ElementTag(NMSHandler.getEntityHelper().getCardinal(object.getYaw()));
        }, new String[0]);
        LocationTag.registerTag("rotate_yaw", (attribute, object) -> {
            LocationTag loc = LocationTag.valueOf(object.identify());
            loc.setYaw(loc.getYaw() + (float)attribute.getDoubleContext(1));
            return loc;
        }, new String[0]);
        LocationTag.registerTag("rotate_pitch", (attribute, object) -> {
            LocationTag loc = LocationTag.valueOf(object.identify());
            loc.setPitch(Math.max(-90.0f, Math.min(90.0f, loc.getPitch() + (float)attribute.getDoubleContext(1))));
            return loc;
        }, new String[0]);
        LocationTag.registerTag("face", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            LocationTag two = LocationTag.valueOf(attribute.getContext(1));
            return new LocationTag(NMSHandler.getEntityHelper().faceLocation((Location)object, (Location)two));
        }, new String[0]);
        LocationTag.registerTag("facing", (attribute, object) -> {
            if (attribute.hasContext(1)) {
                LocationTag facingLoc;
                int degrees = 45;
                if (LocationTag.matches(attribute.getContext(1))) {
                    facingLoc = object.clone();
                } else if (EntityTag.matches(attribute.getContext(1))) {
                    facingLoc = EntityTag.valueOf(attribute.getContext(1)).getLocation();
                } else {
                    if (!attribute.hasAlternative()) {
                        Debug.echoError("Tag location.facing[...] was given an invalid facing target.");
                    }
                    return null;
                }
                if (attribute.startsWith("degrees", 2) && attribute.hasContext(2)) {
                    String context = attribute.getContext(2);
                    attribute.fulfill(1);
                    if (context.contains(",")) {
                        String yaw = context.substring(0, context.indexOf(44));
                        String pitch = context.substring(context.indexOf(44) + 1);
                        degrees = Integer.parseInt(yaw);
                        int pitchDegrees = Integer.parseInt(pitch);
                        return new ElementTag(NMSHandler.getEntityHelper().isFacingLocation((Location)object, facingLoc, degrees, pitchDegrees));
                    }
                    degrees = Integer.parseInt(context);
                }
                return new ElementTag(NMSHandler.getEntityHelper().isFacingLocation((Location)object, (Location)facingLoc, (float)degrees));
            }
            return null;
        }, new String[0]);
        LocationTag.registerTag("pitch", (attribute, object) -> new ElementTag(object.getPitch()), new String[0]);
        LocationTag.registerTag("with_pose", (attribute, object) -> {
            String context = attribute.getContext(1);
            float pitch = 0.0f;
            float yaw = 0.0f;
            if (EntityTag.matches(context)) {
                EntityTag ent = EntityTag.valueOf(context);
                if (ent.isSpawnedOrValidForTag()) {
                    pitch = ent.getBukkitEntity().getLocation().getPitch();
                    yaw = ent.getBukkitEntity().getLocation().getYaw();
                }
            } else if (context.split(",").length == 2) {
                String[] split = context.split(",");
                pitch = Float.parseFloat(split[0]);
                yaw = Float.parseFloat(split[1]);
            }
            LocationTag loc = object.clone();
            loc.setPitch(pitch);
            loc.setYaw(yaw);
            return loc;
        }, new String[0]);
        LocationTag.registerTag("yaw", (attribute, object) -> {
            if (attribute.startsWith("simple", 2)) {
                attribute.fulfill(1);
                float yaw = NMSHandler.getEntityHelper().normalizeYaw(object.getYaw());
                if (yaw < 45.0f) {
                    return new ElementTag("South");
                }
                if (yaw < 135.0f) {
                    return new ElementTag("West");
                }
                if (yaw < 225.0f) {
                    return new ElementTag("North");
                }
                if (yaw < 315.0f) {
                    return new ElementTag("East");
                }
                return new ElementTag("South");
            }
            if (attribute.startsWith("raw", 2)) {
                attribute.fulfill(1);
                return new ElementTag(object.getYaw());
            }
            return new ElementTag(NMSHandler.getEntityHelper().normalizeYaw(object.getYaw()));
        }, new String[0]);
        LocationTag.registerTag("rotate_around_x", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            double angle = attribute.getDoubleContext(1);
            double cos = Math.cos(angle);
            double sin = Math.sin(angle);
            double y = object.getY() * cos - object.getZ() * sin;
            double z = object.getY() * sin + object.getZ() * cos;
            LocationTag location = object.clone();
            location.setY(y);
            location.setZ(z);
            return new LocationTag(location);
        }, new String[0]);
        LocationTag.registerTag("rotate_around_y", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            double angle = attribute.getDoubleContext(1);
            double cos = Math.cos(angle);
            double sin = Math.sin(angle);
            double x = object.getX() * cos + object.getZ() * sin;
            double z = object.getX() * -sin + object.getZ() * cos;
            LocationTag location = object.clone();
            location.setX(x);
            location.setZ(z);
            return new LocationTag(location);
        }, new String[0]);
        LocationTag.registerTag("rotate_around_z", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            double angle = attribute.getDoubleContext(1);
            double cos = Math.cos(angle);
            double sin = Math.sin(angle);
            double x = object.getX() * cos - object.getY() * sin;
            double y = object.getX() * sin + object.getY() * cos;
            LocationTag location = object.clone();
            location.setX(x);
            location.setY(y);
            return new LocationTag(location);
        }, new String[0]);
        LocationTag.registerTag("find", (attribute, object) -> {
            if (!attribute.startsWith("within", 3) || !attribute.hasContext(3)) {
                return null;
            }
            double radius = attribute.getDoubleContext(3);
            if (attribute.startsWith("blocks", 2)) {
                ArrayList<LocationTag> found = new ArrayList<LocationTag>();
                List<Object> materials = new ArrayList();
                if (attribute.hasContext(2)) {
                    materials = ListTag.valueOf(attribute.getContext(2), attribute.context).filter(MaterialTag.class, attribute.context);
                }
                if (materials == null) {
                    return null;
                }
                int max = Settings.blockTagsMaxBlocks();
                int index = 0;
                attribute.fulfill(2);
                Location tstart = object.getBlockForTag(attribute).getLocation();
                double tstartY = tstart.getY();
                int radiusInt = (int)radius;
                block0: for (int x = -radiusInt; x <= radiusInt; ++x) {
                    for (int y = -radiusInt; y <= radiusInt; ++y) {
                        double newY = (double)y + tstartY;
                        if (newY < 0.0 || newY > 255.0) continue;
                        for (int z = -radiusInt; z <= radiusInt; ++z) {
                            if (++index > max) break block0;
                            if (!Utilities.checkLocation(object, tstart.clone().add((double)x + 0.5, (double)y + 0.5, (double)z + 0.5), radius)) continue;
                            if (!materials.isEmpty()) {
                                for (MaterialTag materialTag : materials) {
                                    if (NMSHandler.getVersion().isAtMost(NMSVersion.v1_12) && materialTag.hasData() && materialTag.getData() != 0) {
                                        BlockState bs = new LocationTag(tstart.clone().add((double)x, (double)y, (double)z)).getBlockStateForTag(attribute);
                                        if (bs == null || !materialTag.matchesMaterialData(bs.getData())) continue;
                                        found.add(new LocationTag(tstart.clone().add((double)x, (double)y, (double)z)));
                                        continue;
                                    }
                                    if (materialTag.getMaterial() != new LocationTag(tstart.clone().add((double)x, (double)y, (double)z)).getBlockTypeForTag(attribute)) continue;
                                    found.add(new LocationTag(tstart.clone().add((double)x, (double)y, (double)z)));
                                }
                                continue;
                            }
                            found.add(new LocationTag(tstart.clone().add((double)x, (double)y, (double)z)));
                        }
                    }
                }
                Collections.sort(found, new Comparator<LocationTag>(){

                    @Override
                    public int compare(LocationTag loc1, LocationTag loc2) {
                        return object.compare(loc1, loc2);
                    }
                });
                return new ListTag((Collection<? extends ObjectTag>)found);
            }
            if (attribute.startsWith("surface_blocks", 2)) {
                ArrayList<LocationTag> found = new ArrayList<LocationTag>();
                List<Object> materials = new ArrayList();
                if (attribute.hasContext(2)) {
                    materials = ListTag.valueOf(attribute.getContext(2), attribute.context).filter(MaterialTag.class, attribute.context);
                }
                if (materials == null) {
                    return null;
                }
                int max = Settings.blockTagsMaxBlocks();
                int index = 0;
                attribute.fulfill(2);
                LocationTag blockLoc = object.getBlockLocation();
                Location loc = blockLoc.clone().add(0.5, 0.5, 0.5);
                block4: for (double x = -radius; x <= radius; x += 1.0) {
                    for (double y = -radius; y <= radius; y += 1.0) {
                        for (double z = -radius; z <= radius; z += 1.0) {
                            if (++index > max) break block4;
                            if (!Utilities.checkLocation(loc, blockLoc.clone().add(x + 0.5, y + 0.5, z + 0.5), radius)) continue;
                            LocationTag l = new LocationTag(blockLoc.clone().add(x, y, z));
                            if (!materials.isEmpty()) {
                                for (MaterialTag materialTag : materials) {
                                    if (!materialTag.matchesBlock(l.getBlockForTag(attribute)) || new LocationTag(l.clone().add(0.0, 1.0, 0.0)).getBlockTypeForTag(attribute) != Material.AIR || new LocationTag(l.clone().add(0.0, 2.0, 0.0)).getBlockTypeForTag(attribute) != Material.AIR || l.getBlockTypeForTag(attribute) == Material.AIR) continue;
                                    found.add(new LocationTag(blockLoc.clone().add(x + 0.5, y, z + 0.5)));
                                }
                                continue;
                            }
                            if (new LocationTag(l.clone().add(0.0, 1.0, 0.0)).getBlockTypeForTag(attribute) != Material.AIR || new LocationTag(l.clone().add(0.0, 2.0, 0.0)).getBlockTypeForTag(attribute) != Material.AIR || l.getBlockTypeForTag(attribute) == Material.AIR) continue;
                            found.add(new LocationTag(blockLoc.clone().add(x + 0.5, y, z + 0.5)));
                        }
                    }
                }
                Collections.sort(found, new Comparator<LocationTag>(){

                    @Override
                    public int compare(LocationTag loc1, LocationTag loc2) {
                        return object.compare(loc1, loc2);
                    }
                });
                return new ListTag((Collection<? extends ObjectTag>)found);
            }
            if (attribute.startsWith("players", 2)) {
                ArrayList<PlayerTag> found = new ArrayList<PlayerTag>();
                attribute.fulfill(2);
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (player.isDead() || !Utilities.checkLocation(object, player.getLocation(), radius)) continue;
                    found.add(new PlayerTag(player));
                }
                Collections.sort(found, new Comparator<PlayerTag>(){

                    @Override
                    public int compare(PlayerTag pl1, PlayerTag pl2) {
                        return object.compare(pl1.getLocation(), pl2.getLocation());
                    }
                });
                return new ListTag((Collection<? extends ObjectTag>)found);
            }
            if (attribute.startsWith("npcs", 2)) {
                ArrayList<NPCTag> found = new ArrayList<NPCTag>();
                attribute.fulfill(2);
                for (NPC npc : CitizensAPI.getNPCRegistry()) {
                    if (!npc.isSpawned() || !Utilities.checkLocation(object.getBlockForTag(attribute).getLocation(), npc.getStoredLocation(), radius)) continue;
                    found.add(new NPCTag(npc));
                }
                Collections.sort(found, new Comparator<NPCTag>(){

                    @Override
                    public int compare(NPCTag npc1, NPCTag npc2) {
                        return object.compare(npc1.getLocation(), npc2.getLocation());
                    }
                });
                return new ListTag((Collection<? extends ObjectTag>)found);
            }
            if (attribute.startsWith("entities", 2)) {
                ListTag ent_list = attribute.hasContext(2) ? ListTag.valueOf(attribute.getContext(2), attribute.context) : null;
                ListTag found = new ListTag();
                attribute.fulfill(2);
                block10: for (Entity entity : new WorldTag(object.getWorld()).getEntitiesForTag()) {
                    if (!Utilities.checkLocation(object, entity.getLocation(), radius)) continue;
                    EntityTag current = new EntityTag(entity);
                    if (ent_list != null) {
                        for (String ent : ent_list) {
                            if (!current.comparedTo(ent)) continue;
                            found.addObject(current.getDenizenObject());
                            continue block10;
                        }
                        continue;
                    }
                    found.addObject(current.getDenizenObject());
                }
                Collections.sort(found.objectForms, new Comparator<ObjectTag>(){

                    @Override
                    public int compare(ObjectTag ent1, ObjectTag ent2) {
                        return object.compare(((EntityFormObject)ent1).getLocation(), ((EntityFormObject)ent2).getLocation());
                    }
                });
                return new ListTag((Collection<? extends ObjectTag>)found.objectForms);
            }
            if (attribute.startsWith("living_entities", 2)) {
                ListTag found = new ListTag();
                attribute.fulfill(2);
                for (Entity entity : new WorldTag(object.getWorld()).getEntitiesForTag()) {
                    if (!(entity instanceof LivingEntity) || !Utilities.checkLocation(object, entity.getLocation(), radius)) continue;
                    found.addObject(new EntityTag(entity).getDenizenObject());
                }
                Collections.sort(found.objectForms, new Comparator<ObjectTag>(){

                    @Override
                    public int compare(ObjectTag ent1, ObjectTag ent2) {
                        return object.compare(((EntityFormObject)ent1).getLocation(), ((EntityFormObject)ent2).getLocation());
                    }
                });
                return new ListTag((Collection<? extends ObjectTag>)found.objectForms);
            }
            if (attribute.startsWith("structure", 2) && attribute.hasContext(2)) {
                String typeName = attribute.getContext(2);
                StructureType type = (StructureType)StructureType.getStructureTypes().get(typeName);
                if (type == null) {
                    attribute.echoError("Invalid structure type '" + typeName + "'.");
                    return null;
                }
                attribute.fulfill(2);
                Location result = object.getWorld().locateNearestStructure((Location)object, type, (int)radius, false);
                if (result == null) {
                    return null;
                }
                return new LocationTag(result);
            }
            if (attribute.startsWith("unexplored_structure", 2) && attribute.hasContext(2)) {
                String typeName = attribute.getContext(2);
                StructureType type = (StructureType)StructureType.getStructureTypes().get(typeName);
                if (type == null) {
                    attribute.echoError("Invalid structure type '" + typeName + "'.");
                    return null;
                }
                attribute.fulfill(2);
                Location result = object.getWorld().locateNearestStructure((Location)object, type, (int)radius, true);
                if (result == null) {
                    return null;
                }
                return new LocationTag(result);
            }
            return null;
        }, new String[0]);
        LocationTag.registerTag("find_path", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            LocationTag two = LocationTag.valueOf(attribute.getContext(1));
            if (two == null) {
                return null;
            }
            List<LocationTag> locs = PathFinder.getPath(object, two);
            ListTag list = new ListTag();
            for (LocationTag loc : locs) {
                list.addObject(loc);
            }
            return list;
        }, new String[0]);
        LocationTag.registerTag("formatted", (attribute, object) -> {
            if (attribute.startsWith("citizens", 2)) {
                attribute.fulfill(1);
                return new ElementTag(object.getX() + ":" + object.getY() + ":" + object.getZ() + ":" + object.getWorldName());
            }
            return new ElementTag("X '" + object.getX() + "', Y '" + object.getY() + "', Z '" + object.getZ() + "', in world '" + object.getWorldName() + "'");
        }, new String[0]);
        LocationTag.registerTag("chunk", (attribute, object) -> new ChunkTag((Location)object), "get_chunk");
        LocationTag.registerTag("raw", (attribute, object) -> {
            LocationTag rawLocation = new LocationTag((Location)object);
            rawLocation.setRaw(true);
            return rawLocation;
        }, new String[0]);
        LocationTag.registerTag("world", (attribute, object) -> WorldTag.mirrorBukkitWorld(object.getWorld()), new String[0]);
        LocationTag.registerTag("x", (attribute, object) -> new ElementTag(object.getX()), new String[0]);
        LocationTag.registerTag("y", (attribute, object) -> new ElementTag(object.getY()), new String[0]);
        LocationTag.registerTag("z", (attribute, object) -> new ElementTag(object.getZ()), new String[0]);
        LocationTag.registerTag("xyz", (attribute, object) -> new ElementTag(object.getX() + "," + object.getY() + "," + object.getZ()), new String[0]);
        LocationTag.registerTag("with_x", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            LocationTag output = object.clone();
            output.setX(attribute.getDoubleContext(1));
            return output;
        }, new String[0]);
        LocationTag.registerTag("with_y", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            LocationTag output = object.clone();
            output.setY(attribute.getDoubleContext(1));
            return output;
        }, new String[0]);
        LocationTag.registerTag("with_z", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            LocationTag output = object.clone();
            output.setZ(attribute.getDoubleContext(1));
            return output;
        }, new String[0]);
        LocationTag.registerTag("with_yaw", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            LocationTag output = object.clone();
            output.setYaw((float)attribute.getDoubleContext(1));
            return output;
        }, new String[0]);
        LocationTag.registerTag("with_pitch", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            LocationTag output = object.clone();
            output.setPitch((float)attribute.getDoubleContext(1));
            return output;
        }, new String[0]);
        LocationTag.registerTag("with_world", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            LocationTag output = object.clone();
            WorldTag world = WorldTag.valueOf(attribute.getContext(1));
            output.setWorld(world.getWorld());
            return output;
        }, new String[0]);
        LocationTag.registerTag("notable_name", (attribute, object) -> {
            String notname = NotableManager.getSavedId(object);
            if (notname == null) {
                return null;
            }
            return new ElementTag(notname);
        }, new String[0]);
        LocationTag.registerTag("add", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            String[] ints = attribute.getContext(1).replace("l@", "").split(",", 4);
            if (ints.length >= 3 && ArgumentHelper.matchesDouble(ints[0]) && ArgumentHelper.matchesDouble(ints[1]) && ArgumentHelper.matchesDouble(ints[2])) {
                return new LocationTag(object.clone().add(Double.valueOf(ints[0]), Double.valueOf(ints[1]), Double.valueOf(ints[2])));
            }
            if (LocationTag.matches(attribute.getContext(1))) {
                return new LocationTag(object.clone().add(LocationTag.valueOf(attribute.getContext(1))));
            }
            return null;
        }, new String[0]);
        LocationTag.registerTag("sub", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            String[] ints = attribute.getContext(1).replace("l@", "").split(",", 4);
            if ((ints.length == 3 || ints.length == 4) && ArgumentHelper.matchesDouble(ints[0]) && ArgumentHelper.matchesDouble(ints[1]) && ArgumentHelper.matchesDouble(ints[2])) {
                return new LocationTag(object.clone().subtract(Double.valueOf(ints[0]), Double.valueOf(ints[1]), Double.valueOf(ints[2])));
            }
            if (LocationTag.matches(attribute.getContext(1))) {
                return new LocationTag(object.clone().subtract(LocationTag.valueOf(attribute.getContext(1))));
            }
            return null;
        }, new String[0]);
        LocationTag.registerTag("mul", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            return new LocationTag(object.clone().multiply(Double.parseDouble(attribute.getContext(1))));
        }, new String[0]);
        LocationTag.registerTag("div", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            return new LocationTag(object.clone().multiply(1.0 / Double.parseDouble(attribute.getContext(1))));
        }, new String[0]);
        LocationTag.registerTag("normalize", (attribute, object) -> {
            double len = Math.sqrt(Math.pow(object.getX(), 2.0) + Math.pow(object.getY(), 2.0) + Math.pow(object.getZ(), 2.0));
            if (len == 0.0) {
                len = 1.0;
            }
            return new LocationTag(object.clone().multiply(1.0 / len));
        }, new String[0]);
        LocationTag.registerTag("vector_length", (attribute, object) -> new ElementTag(Math.sqrt(Math.pow(object.getX(), 2.0) + Math.pow(object.getY(), 2.0) + Math.pow(object.getZ(), 2.0))), new String[0]);
        LocationTag.registerTag("vector_to_face", (attribute, object) -> {
            BlockFace face = Utilities.faceFor(object.toVector());
            if (face != null) {
                return new ElementTag(face.name());
            }
            return null;
        }, new String[0]);
        LocationTag.registerTag("distance_squared", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            if (LocationTag.matches(attribute.getContext(1))) {
                LocationTag toLocation = LocationTag.valueOf(attribute.getContext(1));
                if (!object.getWorldName().equalsIgnoreCase(toLocation.getWorldName())) {
                    if (!attribute.hasAlternative()) {
                        Debug.echoError("Can't measure distance between two different worlds!");
                    }
                    return null;
                }
                return new ElementTag(object.distanceSquared(toLocation));
            }
            return null;
        }, new String[0]);
        LocationTag.registerTag("distance", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            if (LocationTag.matches(attribute.getContext(1))) {
                LocationTag toLocation = LocationTag.valueOf(attribute.getContext(1));
                if (attribute.startsWith("horizontal", 2)) {
                    if (attribute.startsWith("multiworld", 3)) {
                        attribute.fulfill(2);
                        return new ElementTag(Math.sqrt(Math.pow(object.getX() - toLocation.getX(), 2.0) + Math.pow(object.getZ() - toLocation.getZ(), 2.0)));
                    }
                    attribute.fulfill(1);
                    if (object.getWorldName().equalsIgnoreCase(toLocation.getWorldName())) {
                        return new ElementTag(Math.sqrt(Math.pow(object.getX() - toLocation.getX(), 2.0) + Math.pow(object.getZ() - toLocation.getZ(), 2.0)));
                    }
                } else if (attribute.startsWith("vertical", 2)) {
                    if (attribute.startsWith("multiworld", 3)) {
                        attribute.fulfill(2);
                        return new ElementTag(Math.abs(object.getY() - toLocation.getY()));
                    }
                    attribute.fulfill(1);
                    if (object.getWorldName().equalsIgnoreCase(toLocation.getWorldName())) {
                        return new ElementTag(Math.abs(object.getY() - toLocation.getY()));
                    }
                }
                if (!object.getWorldName().equalsIgnoreCase(toLocation.getWorldName())) {
                    if (!attribute.hasAlternative()) {
                        Debug.echoError("Can't measure distance between two different worlds!");
                    }
                    return null;
                }
                return new ElementTag(object.distance(toLocation));
            }
            return null;
        }, new String[0]);
        LocationTag.registerTag("is_within_border", (attribute, object) -> new ElementTag(object.getWorld().getWorldBorder().isInside((Location)object)), new String[0]);
        LocationTag.registerTag("is_within", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            if (EllipsoidTag.matches(attribute.getContext(1))) {
                EllipsoidTag ellipsoid = EllipsoidTag.valueOf(attribute.getContext(1));
                if (ellipsoid != null) {
                    return new ElementTag(ellipsoid.contains((Location)object));
                }
            } else {
                CuboidTag cuboid = CuboidTag.valueOf(attribute.getContext(1));
                if (cuboid != null) {
                    return new ElementTag(cuboid.isInsideCuboid((Location)object));
                }
            }
            return null;
        }, new String[0]);
        LocationTag.registerTag("biome", (attribute, object) -> {
            if (attribute.startsWith("formatted", 2)) {
                Deprecations.locationBiomeFormattedTag.warn(attribute.context);
                attribute.fulfill(1);
                return new ElementTag(CoreUtilities.toLowerCase(object.getBiomeForTag(attribute).name()).replace('_', ' '));
            }
            return new BiomeTag(object.getBiomeForTag(attribute));
        }, new String[0]);
        LocationTag.registerTag("cuboids", (attribute, object) -> {
            List<CuboidTag> cuboids = CuboidTag.getNotableCuboidsContaining(object);
            ListTag cuboid_list = new ListTag();
            for (CuboidTag cuboid : cuboids) {
                cuboid_list.addObject(cuboid);
            }
            return cuboid_list;
        }, new String[0]);
        LocationTag.registerTag("ellipsoids", (attribute, object) -> {
            List<EllipsoidTag> ellipsoids = EllipsoidTag.getNotableEllipsoidsContaining(object);
            ListTag ellipsoid_list = new ListTag();
            for (EllipsoidTag ellipsoid : ellipsoids) {
                ellipsoid_list.addObject(ellipsoid);
            }
            return ellipsoid_list;
        }, new String[0]);
        LocationTag.registerTag("is_liquid", (attribute, object) -> {
            Block b = object.getBlockForTag(attribute);
            if (b != null) {
                try {
                    NMSHandler.getChunkHelper().changeChunkServerThread(object.getWorld());
                    ElementTag elementTag = new ElementTag(b.isLiquid());
                    return elementTag;
                }
                finally {
                    NMSHandler.getChunkHelper().restoreServerThread(object.getWorld());
                }
            }
            return null;
        }, new String[0]);
        LocationTag.registerTag("light", (attribute, object) -> {
            Block b = object.getBlockForTag(attribute);
            if (b != null) {
                try {
                    NMSHandler.getChunkHelper().changeChunkServerThread(object.getWorld());
                    if (attribute.startsWith("blocks", 2)) {
                        attribute.fulfill(1);
                        ElementTag elementTag = new ElementTag(object.getBlockForTag(attribute).getLightFromBlocks());
                        return elementTag;
                    }
                    if (attribute.startsWith("sky", 2)) {
                        attribute.fulfill(1);
                        ElementTag elementTag = new ElementTag(object.getBlockForTag(attribute).getLightFromSky());
                        return elementTag;
                    }
                    ElementTag elementTag = new ElementTag(object.getBlockForTag(attribute).getLightLevel());
                    return elementTag;
                }
                finally {
                    NMSHandler.getChunkHelper().restoreServerThread(object.getWorld());
                }
            }
            return null;
        }, new String[0]);
        LocationTag.registerTag("power", (attribute, object) -> {
            Block b = object.getBlockForTag(attribute);
            if (b != null) {
                try {
                    NMSHandler.getChunkHelper().changeChunkServerThread(object.getWorld());
                    ElementTag elementTag = new ElementTag(object.getBlockForTag(attribute).getBlockPower());
                    return elementTag;
                }
                finally {
                    NMSHandler.getChunkHelper().restoreServerThread(object.getWorld());
                }
            }
            return null;
        }, new String[0]);
        LocationTag.registerTag("lectern_page", (attribute, object) -> {
            BlockState state = object.getBlockStateForTag(attribute);
            if (state instanceof Lectern) {
                return new ElementTag(((Lectern)state).getPage());
            }
            return null;
        }, new String[0]);
        LocationTag.registerTag("tree_distance", (attribute, object) -> {
            MaterialTag material = new MaterialTag(object.getBlockForTag(attribute));
            if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13) && MaterialPersistent.describes(material)) {
                return new ElementTag(MaterialPersistent.getFrom(material).getDistance());
            }
            return null;
        }, new String[0]);
        LocationTag.registerTag("command_block_name", (attribute, object) -> {
            if (!(object.getBlockStateForTag(attribute) instanceof CommandBlock)) {
                return null;
            }
            return new ElementTag(((CommandBlock)object.getBlockStateForTag(attribute)).getName());
        }, new String[0]);
        LocationTag.registerTag("command_block", (attribute, object) -> {
            if (!(object.getBlockStateForTag(attribute) instanceof CommandBlock)) {
                return null;
            }
            return new ElementTag(((CommandBlock)object.getBlockStateForTag(attribute)).getCommand());
        }, new String[0]);
        LocationTag.registerTag("brewing_time", (attribute, object) -> new DurationTag((long)((BrewingStand)object.getBlockStateForTag(attribute)).getBrewingTime()), new String[0]);
        LocationTag.registerTag("brewing_fuel_level", (attribute, object) -> new ElementTag(((BrewingStand)object.getBlockStateForTag(attribute)).getFuelLevel()), new String[0]);
        LocationTag.registerTag("furnace_burn_time", (attribute, object) -> new ElementTag(((Furnace)object.getBlockStateForTag(attribute)).getBurnTime()), new String[0]);
        LocationTag.registerTag("furnace_cook_time", (attribute, object) -> new ElementTag(((Furnace)object.getBlockStateForTag(attribute)).getCookTime()), new String[0]);
        LocationTag.registerTag("furnace_cook_time_total", (attribute, object) -> new ElementTag(((Furnace)object.getBlockStateForTag(attribute)).getCookTimeTotal()), new String[0]);
        LocationTag.registerTag("beacon_tier", (attribute, object) -> new ElementTag(((Beacon)object.getBlockStateForTag(attribute)).getTier()), new String[0]);
        LocationTag.registerTag("beacon_primary_effect", (attribute, object) -> {
            PotionEffect effect = ((Beacon)object.getBlockStateForTag(attribute)).getPrimaryEffect();
            if (effect == null) {
                return null;
            }
            return new ElementTag(effect.getType().getName());
        }, new String[0]);
        LocationTag.registerTag("beacon_secondary_effect", (attribute, object) -> {
            PotionEffect effect = ((Beacon)object.getBlockStateForTag(attribute)).getSecondaryEffect();
            if (effect == null) {
                return null;
            }
            return new ElementTag(effect.getType().getName());
        }, new String[0]);
        LocationTag.registerTag("attached_to", (attribute, object) -> {
            BlockFace face = BlockFace.SELF;
            MaterialTag material = new MaterialTag(object.getBlockForTag(attribute));
            if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13) && MaterialSwitchFace.describes(material)) {
                face = MaterialSwitchFace.getFrom(material).getAttachedTo();
            } else {
                MaterialData data = object.getBlockStateForTag(attribute).getData();
                if (data instanceof Attachable) {
                    face = ((Attachable)data).getAttachedFace();
                }
            }
            if (face != BlockFace.SELF) {
                return new LocationTag(object.getBlockForTag(attribute).getRelative(face).getLocation());
            }
            return null;
        }, new String[0]);
        LocationTag.registerTag("other_block", (attribute, object) -> {
            if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13)) {
                Block b = object.getBlockForTag(attribute);
                MaterialTag material = new MaterialTag(b);
                if (MaterialHalf.describes(material)) {
                    return new LocationTag(object.clone().add(MaterialHalf.getFrom(material).getRelativeBlockVector()));
                }
                if (!attribute.hasAlternative()) {
                    Debug.echoError("Block of type " + object.getBlockTypeForTag(attribute).name() + " isn't supported by other_block.");
                }
                return null;
            }
            BlockState state = object.getBlockStateForTag(attribute);
            if (state instanceof Chest) {
                InventoryHolder holder = ((Chest)state).getBlockInventory().getHolder();
                if (holder instanceof DoubleChest) {
                    Location left = ((DoubleChest)holder).getLeftSide().getInventory().getLocation();
                    Location right = ((DoubleChest)holder).getRightSide().getInventory().getLocation();
                    if (left.getBlockX() == object.getBlockX() && left.getBlockY() == object.getBlockY() && left.getBlockZ() == object.getBlockZ()) {
                        return new LocationTag(right);
                    }
                    return new LocationTag(left);
                }
            } else {
                if (state.getData() instanceof Door) {
                    if (((Door)state.getData()).isTopHalf()) {
                        return new LocationTag(object.clone().subtract(0.0, 1.0, 0.0));
                    }
                    return new LocationTag(object.clone().add(0.0, 1.0, 0.0));
                }
                if (!attribute.hasAlternative()) {
                    Debug.echoError("Block of type " + object.getBlockTypeForTag(attribute).name() + " isn't supported by other_block.");
                }
                return null;
            }
            if (!attribute.hasAlternative()) {
                Debug.echoError("Block of type " + object.getBlockTypeForTag(attribute).name() + " doesn't have an other block.");
            }
            return null;
        }, new String[0]);
        LocationTag.registerTag("custom_name", (attribute, object) -> {
            if (object.getBlockStateForTag(attribute) instanceof Nameable) {
                return new ElementTag(((Nameable)object.getBlockStateForTag(attribute)).getCustomName());
            }
            return null;
        }, new String[0]);
        LocationTag.registerTag("local_difficulty", (attribute, object) -> new ElementTag(NMSHandler.getWorldHelper().getLocalDifficulty((Location)object)), new String[0]);
        LocationTag.registerTag("type", (attribute, object) -> new ElementTag("Location"), new String[0]);
    }

    public static void registerTag(String name, TagRunnable.ObjectInterface<LocationTag> runnable, String ... variants) {
        tagProcessor.registerTag(name, runnable, variants);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        Debug.echoError("Cannot apply properties to a location!");
    }

    @Override
    public void adjust(Mechanism mechanism) {
        boolean generated;
        Furnace furnace;
        BrewingStand stand;
        CommandBlock block;
        Beehive hive;
        ListTag list;
        BlockState state;
        if (mechanism.matches("data") && mechanism.hasValue()) {
            Deprecations.materialIds.warn(mechanism.context);
            BlockData blockData = NMSHandler.getBlockHelper().getBlockData(this.getBlock().getType(), (byte)mechanism.getValue().asInt());
            blockData.setBlock(this.getBlock(), false);
        }
        if (mechanism.matches("block_facing") && mechanism.requireObject(LocationTag.class)) {
            LocationTag faceVec = mechanism.valueAsType(LocationTag.class);
            Block block2 = this.getBlock();
            MaterialTag material = new MaterialTag(block2);
            if (!MaterialDirectional.describes(material)) {
                Debug.echoError("LocationTag.block_facing mechanism failed: block is not directional.");
                return;
            }
            MaterialDirectional.getFrom(material).setFacing(Utilities.faceFor(faceVec.toVector()));
            material.getModernData().setToBlock(block2);
        }
        if (mechanism.matches("block_type") && mechanism.requireObject(MaterialTag.class)) {
            MaterialTag mat = mechanism.valueAsType(MaterialTag.class);
            mat.getNmsBlockData().setBlock(this.getBlock(), false);
        }
        if (mechanism.matches("biome") && mechanism.requireObject(BiomeTag.class)) {
            mechanism.valueAsType(BiomeTag.class).getBiome().changeBlockBiome(this);
        }
        if (mechanism.matches("spawner_type") && mechanism.requireObject(EntityTag.class) && this.getBlockState() instanceof CreatureSpawner) {
            CreatureSpawner spawner = (CreatureSpawner)this.getBlockState();
            spawner.setSpawnedType(mechanism.valueAsType(EntityTag.class).getBukkitEntityType());
            spawner.update();
        }
        if (mechanism.matches("lock") && this.getBlockState() instanceof Lockable) {
            state = this.getBlockState();
            ((Lockable)state).setLock(mechanism.hasValue() ? mechanism.getValue().asString() : null);
            state.update();
        }
        if (mechanism.matches("sign_contents") && this.getBlockState() instanceof Sign) {
            state = (Sign)this.getBlockState();
            for (int i = 0; i < 4; ++i) {
                state.setLine(i, "");
            }
            list = mechanism.valueAsType(ListTag.class);
            if (list.size() > 4) {
                Debug.echoError("Sign can only hold four lines!");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    state.setLine(i, EscapeTagBase.unEscape((String)list.get(i)));
                }
            }
            state.update();
        }
        if (mechanism.matches("skull_skin")) {
            BlockState blockState = this.getBlockState();
            Material material = this.getBlock().getType();
            if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13) && material != Material.PLAYER_HEAD && material != Material.PLAYER_WALL_HEAD) {
                Deprecations.skullSkinMaterials.warn(mechanism.context);
            } else if (blockState instanceof Skull) {
                PlayerProfile profile;
                ListTag list2 = mechanism.valueAsType(ListTag.class);
                String idString = (String)list2.get(0);
                String texture = null;
                if (list2.size() > 1) {
                    texture = (String)list2.get(1);
                }
                if (idString.contains("-")) {
                    UUID uuid = UUID.fromString(idString);
                    String name = null;
                    if (list2.size() > 2) {
                        name = (String)list2.get(2);
                    }
                    profile = new PlayerProfile(name, uuid, texture);
                } else {
                    profile = new PlayerProfile(idString, null, texture);
                }
                profile = NMSHandler.getInstance().fillPlayerProfile(profile);
                if (texture != null) {
                    profile.setTexture(texture);
                }
                NMSHandler.getBlockHelper().setPlayerProfile((Skull)blockState, profile);
            } else {
                Debug.echoError("Unable to set skull_skin on block of type " + material.name() + " with state " + blockState.getClass().getCanonicalName());
            }
        }
        if (mechanism.matches("flowerpot_contents") && mechanism.requireObject(MaterialTag.class)) {
            if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13)) {
                Deprecations.flowerpotMechanism.warn(mechanism.context);
            } else if (this.getBlock().getType() == Material.FLOWER_POT) {
                MaterialData data = mechanism.valueAsType(MaterialTag.class).getMaterialData();
                NMSHandler.getBlockHelper().setFlowerpotContents(this.getBlock(), data);
            }
        }
        if (mechanism.matches("hive_max_bees") && mechanism.requireInteger()) {
            hive = (Beehive)this.getBlockState();
            hive.setMaxEntities(mechanism.getValue().asInt());
            hive.update();
        }
        if (mechanism.matches("release_bees")) {
            hive = (Beehive)this.getBlockState();
            hive.releaseEntities();
            hive.update();
        }
        if (mechanism.matches("add_bee") && mechanism.requireObject(EntityTag.class)) {
            hive = (Beehive)this.getBlockState();
            hive.addEntity((Entity)((Bee)mechanism.valueAsType(EntityTag.class).getBukkitEntity()));
            hive.update();
        }
        if (mechanism.matches("command_block_name") && this.getBlock().getType() == MaterialCompat.COMMAND_BLOCK) {
            block = (CommandBlock)this.getBlockState();
            block.setName(mechanism.getValue().asString());
            block.update();
        }
        if (mechanism.matches("command_block") && this.getBlock().getType() == MaterialCompat.COMMAND_BLOCK) {
            block = (CommandBlock)this.getBlockState();
            block.setCommand(mechanism.getValue().asString());
            block.update();
        }
        if (mechanism.matches("custom_name") && this.getBlockState() instanceof Nameable) {
            String title = null;
            if (mechanism.hasValue()) {
                title = mechanism.getValue().asString();
            }
            BlockState state2 = this.getBlockState();
            ((Nameable)state2).setCustomName(title);
            state2.update(true);
        }
        if (mechanism.matches("brewing_time") && this.getBlockState() instanceof BrewingStand) {
            stand = (BrewingStand)this.getBlockState();
            stand.setBrewingTime(mechanism.valueAsType(DurationTag.class).getTicksAsInt());
            stand.update();
        }
        if (mechanism.matches("brewing_fuel_level") && this.getBlockState() instanceof BrewingStand) {
            stand = (BrewingStand)this.getBlockState();
            stand.setFuelLevel(mechanism.getValue().asInt());
            stand.update();
        }
        if (mechanism.matches("furnace_burn_time") && MaterialCompat.isFurnace(this.getBlock().getType())) {
            furnace = (Furnace)this.getBlockState();
            furnace.setBurnTime((short)mechanism.getValue().asInt());
            furnace.update();
        }
        if (mechanism.matches("furnace_cook_time") && MaterialCompat.isFurnace(this.getBlock().getType())) {
            furnace = (Furnace)this.getBlockState();
            furnace.setCookTime((short)mechanism.getValue().asInt());
            furnace.update();
        }
        if (mechanism.matches("furnace_cook_time_total") && MaterialCompat.isFurnace(this.getBlock().getType())) {
            furnace = (Furnace)this.getBlockState();
            furnace.setCookTimeTotal((int)((short)mechanism.getValue().asInt()));
            furnace.update();
        }
        if (mechanism.matches("base_color")) {
            if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13)) {
                Debug.echoError("Base_Color mechanism no longer relevant: banner types are now distinct materials.");
            }
            Banner banner = (Banner)this.getBlockState();
            banner.setBaseColor(DyeColor.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            banner.update();
        }
        if (mechanism.matches("patterns")) {
            ArrayList<Pattern> patterns = new ArrayList<Pattern>();
            list = mechanism.valueAsType(ListTag.class);
            for (String string : list) {
                try {
                    List<String> split = CoreUtilities.split(string, '/', 2);
                    patterns.add(new Pattern(DyeColor.valueOf((String)split.get(0).toUpperCase()), PatternType.valueOf((String)split.get(1).toUpperCase())));
                }
                catch (Exception e) {
                    Debug.echoError("Could not apply pattern to banner: " + string);
                }
            }
            Banner banner = (Banner)this.getBlockState();
            banner.setPatterns(patterns);
            banner.update();
        }
        if (mechanism.matches("head_rotation") && mechanism.requireInteger()) {
            Skull sk = (Skull)this.getBlockState();
            sk.setRotation(this.getSkullBlockFace(mechanism.getValue().asInt() - 1));
            sk.update();
        }
        if (mechanism.matches("generate_tree") && mechanism.requireEnum(false, (Enum<?>[])TreeType.values()) && !(generated = this.getWorld().generateTree((Location)this, TreeType.valueOf((String)mechanism.getValue().asString().toUpperCase())))) {
            Debug.echoError("Could not generate tree at " + this.identifySimple() + ". Make sure this location can naturally generate a tree!");
        }
        if (mechanism.matches("beacon_primary_effect")) {
            Beacon beacon = (Beacon)this.getBlockState();
            beacon.setPrimaryEffect(PotionEffectType.getByName((String)mechanism.getValue().asString().toUpperCase()));
            beacon.update();
        }
        if (mechanism.matches("beacon_secondary_effect")) {
            Beacon beacon = (Beacon)this.getBlockState();
            beacon.setSecondaryEffect(PotionEffectType.getByName((String)mechanism.getValue().asString().toUpperCase()));
            beacon.update();
        }
        if (mechanism.matches("activate")) {
            BlockState state3 = this.getBlockState();
            if (state3 instanceof Dispenser) {
                ((Dispenser)state3).dispense();
            } else if (state3 instanceof Dropper) {
                ((Dropper)state3).drop();
            } else {
                Debug.echoError("'activate' mechanism does not work for blocks of type: " + state3.getType().name());
            }
        }
        if (mechanism.matches("lectern_page") && mechanism.requireInteger()) {
            BlockState state4 = this.getBlockState();
            if (state4 instanceof Lectern) {
                ((Lectern)state4).setPage(mechanism.getValue().asInt());
                state4.update();
            } else {
                Debug.echoError("'lectern_page' mechanism can only be called on a lectern block.");
            }
        }
        CoreUtilities.autoPropertyMechanism(this, mechanism);
    }
}

