/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.material;

import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.block.data.type.SeaPickle;

public class MaterialPickle
implements Property {
    public static final String[] handledMechs = new String[]{"pickle_count"};
    MaterialTag material;

    public static boolean describes(ObjectTag material) {
        return material instanceof MaterialTag && ((MaterialTag)material).hasModernData() && ((MaterialTag)material).getModernData().data instanceof SeaPickle;
    }

    public static MaterialPickle getFrom(ObjectTag _material) {
        if (!MaterialPickle.describes(_material)) {
            return null;
        }
        return new MaterialPickle((MaterialTag)_material);
    }

    private MaterialPickle(MaterialTag _material) {
        this.material = _material;
    }

    public static void registerTags() {
        PropertyParser.registerTag("pickle_count", (attribute, material) -> new ElementTag(material.getCurrent()), new String[0]);
        PropertyParser.registerTag("pickle_max", (attribute, material) -> new ElementTag(material.getMax()), new String[0]);
        PropertyParser.registerTag("pickle_min", (attribute, material) -> new ElementTag(material.getMin()), new String[0]);
    }

    public SeaPickle getSeaPickle() {
        return (SeaPickle)this.material.getModernData().data;
    }

    public int getCurrent() {
        return this.getSeaPickle().getPickles();
    }

    public int getMax() {
        return this.getSeaPickle().getMaximumPickles();
    }

    public int getMin() {
        return this.getSeaPickle().getMinimumPickles();
    }

    @Override
    public String getPropertyString() {
        return String.valueOf(this.getCurrent());
    }

    @Override
    public String getPropertyId() {
        return "pickle_count";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("pickle_count") && mechanism.requireInteger()) {
            int count = mechanism.getValue().asInt();
            if (count < this.getMin() || count > this.getMax()) {
                Debug.echoError("Pickle count value '" + count + "' is not valid. Must be between " + this.getMin() + " and " + this.getMax() + ".");
                return;
            }
            this.getSeaPickle().setPickles(count);
        }
    }
}

