/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.npc;

import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class ActionCommand
extends AbstractCommand {
    public ActionCommand() {
        this.setName("action");
        this.setSyntax("action [<action name>|...] (<npc>|...) (context:<name>|<object>|...)");
        this.setRequiredArguments(1, 3);
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("npcs") && arg.matchesArgumentList(NPCTag.class)) {
                scriptEntry.addObject("npcs", arg.asType(ListTag.class).filter(NPCTag.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("context") && arg.matchesPrefix("context", "c")) {
                scriptEntry.addObject("context", arg.asType(ListTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("actions")) {
                scriptEntry.addObject("actions", arg.asType(ListTag.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("actions")) {
            throw new InvalidArgumentsException("Must specify a list of action names!");
        }
        if (!scriptEntry.hasObject("npcs")) {
            if (Utilities.entryHasNPC(scriptEntry)) {
                scriptEntry.addObject("npcs", Arrays.asList(Utilities.getEntryNPC(scriptEntry)));
            } else {
                throw new InvalidArgumentsException("Must specify an NPC to use!");
            }
        }
        scriptEntry.defaultObject("context", new ListTag());
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ListTag actions = (ListTag)scriptEntry.getObject("actions");
        ListTag context = (ListTag)scriptEntry.getObject("context");
        List npcs = (List)scriptEntry.getObject("npcs");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), actions.debug() + context.debug() + ArgumentHelper.debugList("npcs", npcs));
        }
        if (context.size() % 2 == 1) {
            context.add("null");
        }
        HashMap<String, ObjectTag> context_map = new HashMap<String, ObjectTag>();
        for (int i = 0; i < context.size(); i += 2) {
            context_map.put((String)context.get(i), ObjectFetcher.pickObjectFor((String)context.get(i + 1), scriptEntry.entryData.getTagContext()));
        }
        for (NPCTag npc : npcs) {
            for (String action : actions) {
                npc.action(action, Utilities.getEntryPlayer(scriptEntry), context_map);
            }
        }
    }
}

