/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.npc;

import com.denizenscript.denizen.npc.traits.SleepingTrait;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Villager;

public class SleepCommand
extends AbstractCommand {
    public SleepCommand() {
        this.setName("sleep");
        this.setSyntax("sleep (<location>)");
        this.setRequiredArguments(0, 1);
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (arg.matchesArgumentType(LocationTag.class) && !scriptEntry.hasObject("location")) {
                scriptEntry.addObject("location", arg.asType(LocationTag.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!Utilities.entryHasNPC(scriptEntry)) {
            throw new InvalidArgumentsException("This command requires a linked NPC!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        LocationTag location = (LocationTag)scriptEntry.getObject("location");
        NPCTag npc = Utilities.getEntryNPC(scriptEntry);
        if (npc.getEntityType() != EntityType.PLAYER && !(npc.getEntity() instanceof Villager)) {
            Debug.echoError("Only Player or villager type NPCs can sit!");
            return;
        }
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), ArgumentHelper.debugObj("npc", npc) + (location != null ? location.debug() : ""));
        }
        SleepingTrait trait = (SleepingTrait)npc.getCitizen().getTrait(SleepingTrait.class);
        if (location != null) {
            trait.toSleep(location);
        } else {
            trait.toSleep();
        }
    }
}

