/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.server;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;

public class BossBarCommand
extends AbstractCommand {
    public static final Map<String, BossBar> bossBarMap = new HashMap<String, BossBar>();

    public BossBarCommand() {
        this.setName("bossbar");
        this.setSyntax("bossbar ({create}/update/remove) [<id>] (players:<player>|...) (title:<title>) (progress:<#.#>) (color:<color>) (style:<style>) (flags:<flag>|...)");
        this.setRequiredArguments(1, 8);
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("title") && arg.matchesPrefix("title", "t")) {
                scriptEntry.addObject("title", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("progress") && arg.matchesPrefix("progress", "health", "p", "h") && arg.matchesFloat()) {
                scriptEntry.addObject("progress", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("color") && arg.matchesPrefix("color", "c") && arg.matchesEnum((Enum<?>[])BarColor.values())) {
                scriptEntry.addObject("color", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("style") && arg.matchesPrefix("style", "s") && arg.matchesEnum((Enum<?>[])BarStyle.values())) {
                scriptEntry.addObject("style", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("flags") && arg.matchesPrefix("flags", "flag", "f") && arg.matchesEnumList((Enum<?>[])BarFlag.values())) {
                scriptEntry.addObject("flags", arg.asType(ListTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("action") && arg.matchesEnum(Action.values())) {
                scriptEntry.addObject("action", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("players") && arg.matchesPrefix("players") && arg.matchesArgumentList(PlayerTag.class)) {
                scriptEntry.addObject("players", arg.asType(ListTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("id")) {
                scriptEntry.addObject("id", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("id")) {
            throw new InvalidArgumentsException("Must specify an ID!");
        }
        if (!(scriptEntry.hasObject("action") && !scriptEntry.getElement("action").asString().equalsIgnoreCase("CREATE") || scriptEntry.hasObject("players"))) {
            if (Utilities.entryHasPlayer(scriptEntry) && Utilities.getEntryPlayer(scriptEntry).isOnline()) {
                scriptEntry.addObject("players", new ListTag(Collections.singleton(Utilities.getEntryPlayer(scriptEntry).identify())));
            } else {
                throw new InvalidArgumentsException("Must specify valid player(s)!");
            }
        }
        scriptEntry.defaultObject("action", new ElementTag("CREATE"));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ElementTag id = scriptEntry.getElement("id");
        ElementTag action = scriptEntry.getElement("action");
        ListTag players = (ListTag)scriptEntry.getObjectTag("players");
        ElementTag title = scriptEntry.getElement("title");
        ElementTag progress = scriptEntry.getElement("progress");
        ElementTag color = scriptEntry.getElement("color");
        ElementTag style = scriptEntry.getElement("style");
        ListTag flags = (ListTag)scriptEntry.getObjectTag("flags");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), id.debug() + action.debug() + (players != null ? players.debug() : "") + (title != null ? title.debug() : "") + (progress != null ? progress.debug() : "") + (color != null ? color.debug() : "") + (style != null ? style.debug() : "") + (flags != null ? flags.debug() : ""));
        }
        String idString = CoreUtilities.toLowerCase(id.asString());
        switch (Action.valueOf(action.asString().toUpperCase())) {
            case CREATE: {
                if (bossBarMap.containsKey(idString)) {
                    Debug.echoError("BossBar '" + idString + "' already exists!");
                    return;
                }
                String barTitle = title != null ? title.asString() : "";
                List<PlayerTag> barPlayers = players.filter(PlayerTag.class, scriptEntry);
                double barProgress = progress != null ? progress.asDouble() : 1.0;
                BarColor barColor = color != null ? BarColor.valueOf((String)color.asString().toUpperCase()) : BarColor.WHITE;
                BarStyle barStyle = style != null ? BarStyle.valueOf((String)style.asString().toUpperCase()) : BarStyle.SOLID;
                BarFlag[] barFlags = new BarFlag[flags != null ? flags.size() : 0];
                if (flags != null) {
                    for (int i = 0; i < flags.size(); ++i) {
                        barFlags[i] = BarFlag.valueOf((String)((String)flags.get(i)).toUpperCase());
                    }
                }
                BossBar bossBar = Bukkit.createBossBar((String)barTitle, (BarColor)barColor, (BarStyle)barStyle, (BarFlag[])barFlags);
                bossBar.setProgress(barProgress);
                for (PlayerTag player : barPlayers) {
                    if (!player.isOnline()) {
                        Debug.echoError("Player must be online to show a BossBar to them!");
                        continue;
                    }
                    bossBar.addPlayer(player.getPlayerEntity());
                }
                bossBar.setVisible(true);
                bossBarMap.put(idString, bossBar);
                break;
            }
            case UPDATE: {
                if (!bossBarMap.containsKey(idString)) {
                    Debug.echoError("BossBar '" + idString + "' does not exist!");
                    return;
                }
                BossBar bossBar1 = bossBarMap.get(idString);
                if (title != null) {
                    bossBar1.setTitle(title.asString());
                }
                if (progress != null) {
                    bossBar1.setProgress(progress.asDouble());
                }
                if (color != null) {
                    bossBar1.setColor(BarColor.valueOf((String)color.asString().toUpperCase()));
                }
                if (style != null) {
                    bossBar1.setStyle(BarStyle.valueOf((String)style.asString().toUpperCase()));
                }
                if (players == null) break;
                for (PlayerTag player : players.filter(PlayerTag.class, scriptEntry)) {
                    bossBar1.addPlayer(player.getPlayerEntity());
                }
                break;
            }
            case REMOVE: {
                if (!bossBarMap.containsKey(idString)) {
                    Debug.echoError("BossBar '" + idString + "' does not exist!");
                    return;
                }
                if (players != null) {
                    BossBar bar = bossBarMap.get(idString);
                    for (PlayerTag player : players.filter(PlayerTag.class, scriptEntry)) {
                        bar.removePlayer(player.getPlayerEntity());
                    }
                    break;
                }
                bossBarMap.get(idString).setVisible(false);
                bossBarMap.remove(idString);
            }
        }
    }

    private static enum Action {
        CREATE,
        UPDATE,
        REMOVE;

    }
}

