/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.world;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.interfaces.PacketHelper;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Player;

public class AnimateChestCommand
extends AbstractCommand {
    public AnimateChestCommand() {
        this.setName("animatechest");
        this.setSyntax("animatechest [<location>] ({open}/close) (sound:{true}/false) (<player>|...)");
        this.setRequiredArguments(1, 4);
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("action") && arg.matchesEnum(ChestAction.values())) {
                scriptEntry.addObject("action", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(LocationTag.class)) {
                scriptEntry.addObject("location", arg.asType(LocationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("sound") && arg.matchesPrefix("sound") && arg.matchesBoolean()) {
                scriptEntry.addObject("sound", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("players") && arg.matchesArgumentList(PlayerTag.class)) {
                scriptEntry.addObject("players", arg.asType(ListTag.class).filter(PlayerTag.class, scriptEntry));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("location")) {
            throw new InvalidArgumentsException("Must specify a location!");
        }
        if (!scriptEntry.hasObject("action")) {
            scriptEntry.addObject("action", new ElementTag("OPEN"));
        }
        if (!scriptEntry.hasObject("sound")) {
            scriptEntry.addObject("sound", new ElementTag(true));
        }
        if (!scriptEntry.hasObject("players")) {
            if (Utilities.entryHasPlayer(scriptEntry)) {
                scriptEntry.addObject("players", Arrays.asList(Utilities.getEntryPlayer(scriptEntry)));
            } else {
                throw new InvalidArgumentsException("Missing 'players' argument!");
            }
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        LocationTag location = (LocationTag)scriptEntry.getObject("location");
        ElementTag action = scriptEntry.getElement("action");
        ElementTag sound = scriptEntry.getElement("sound");
        List players = (List)scriptEntry.getObject("players");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), location.debug() + ArgumentHelper.debugObj("block type", location.getBlock().getType().name()) + action.debug() + sound.debug() + ArgumentHelper.debugObj("players", players.toString()));
        }
        PacketHelper packetHelper = NMSHandler.getPacketHelper();
        switch (ChestAction.valueOf(action.asString().toUpperCase())) {
            case OPEN: {
                for (PlayerTag player : players) {
                    Player ent = player.getPlayerEntity();
                    if (sound.asBoolean()) {
                        NMSHandler.getSoundHelper().playSound(ent, (Location)location, Sound.BLOCK_CHEST_OPEN, 1.0f, 1.0f, "BLOCKS");
                    }
                    packetHelper.showBlockAction(ent, location, 1, 1);
                }
                break;
            }
            case CLOSE: {
                for (PlayerTag player : players) {
                    Player ent = player.getPlayerEntity();
                    if (sound.asBoolean()) {
                        NMSHandler.getSoundHelper().playSound(ent, (Location)location, Sound.BLOCK_CHEST_CLOSE, 1.0f, 1.0f, "BLOCKS");
                    }
                    packetHelper.showBlockAction(ent, location, 1, 0);
                }
                break;
            }
        }
    }

    static enum ChestAction {
        OPEN,
        CLOSE;

    }
}

