/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.world;

import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;

public class ExplodeCommand
extends AbstractCommand {
    public ExplodeCommand() {
        this.setName("explode");
        this.setSyntax("explode (power:<#.#>) (<location>) (fire) (breakblocks)");
        this.setRequiredArguments(0, 4);
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(LocationTag.class)) {
                scriptEntry.addObject("location", arg.asType(LocationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("power") && arg.matchesFloat() && arg.matchesPrefix("power", "p")) {
                scriptEntry.addObject("power", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("breakblocks") && arg.matches("breakblocks")) {
                scriptEntry.addObject("breakblocks", "");
                continue;
            }
            if (!scriptEntry.hasObject("fire") && arg.matches("fire")) {
                scriptEntry.addObject("fire", "");
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("power", new ElementTag(1.0));
        scriptEntry.defaultObject("location", Utilities.entryHasNPC(scriptEntry) ? Utilities.getEntryNPC(scriptEntry).getLocation() : null, Utilities.entryHasPlayer(scriptEntry) ? Utilities.getEntryPlayer(scriptEntry).getLocation() : null);
        if (!scriptEntry.hasObject("location")) {
            throw new InvalidArgumentsException("Missing location argument!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        LocationTag location = (LocationTag)scriptEntry.getObject("location");
        ElementTag power = (ElementTag)scriptEntry.getObject("power");
        boolean breakblocks = scriptEntry.hasObject("breakblocks");
        boolean fire = scriptEntry.hasObject("fire");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), ArgumentHelper.debugObj("location", location.toString()) + ArgumentHelper.debugObj("power", power) + ArgumentHelper.debugObj("breakblocks", breakblocks) + ArgumentHelper.debugObj("fire", fire));
        }
        location.getWorld().createExplosion(location.getX(), location.getY(), location.getZ(), power.asFloat(), fire, breakblocks);
    }
}

