/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.containers.core;

import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.containers.core.CommandScriptHelper;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.command.scripted.DenizenCommand;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.OldEventManager;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.scripts.queues.core.InstantQueue;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CommandScriptContainer
extends ScriptContainer {
    public CommandScriptContainer(YamlConfiguration configurationSection, String scriptContainerName) {
        super(configurationSection, scriptContainerName);
        CommandScriptHelper.registerDenizenCommand(new DenizenCommand(this));
    }

    public String getCommandName() {
        return CoreUtilities.toLowerCase(this.getString("name", null));
    }

    public String getDescription() {
        return TagManager.tag(this.getString("description", "").replace("\n", " \n"), new BukkitTagContext(null, null, new ScriptTag(this)));
    }

    public String getUsage() {
        return TagManager.tag(this.getString("usage", ""), new BukkitTagContext(null, null, new ScriptTag(this)));
    }

    public List<String> getAliases() {
        ArrayList aliases = this.getStringList("aliases");
        return aliases != null ? aliases : new ArrayList();
    }

    public String getPermission() {
        return this.getString("permission");
    }

    public String getPermissionMessage() {
        return this.getString("permission message");
    }

    public ScriptQueue runCommandScript(PlayerTag player, NPCTag npc, Map<String, ObjectTag> context) {
        ScriptQueue queue = new InstantQueue(this.getName()).addEntries(this.getBaseEntries(new BukkitScriptEntryData(player, npc)));
        if (context != null) {
            OldEventManager.OldEventContextSource oecs = new OldEventManager.OldEventContextSource();
            oecs.contexts = context;
            queue.setContextSource(oecs);
        }
        queue.start();
        return queue;
    }

    public boolean runAllowedHelpProcedure(PlayerTag player, NPCTag npc, Map<String, ObjectTag> context) {
        List<ScriptEntry> entries = this.getEntries(new BukkitScriptEntryData(player, npc), "allowed help");
        ScriptQueue queue = new InstantQueue(this.getName()).addEntries(entries);
        if (context != null) {
            OldEventManager.OldEventContextSource oecs = new OldEventManager.OldEventContextSource();
            oecs.contexts = context;
            queue.setContextSource(oecs);
        }
        queue.start();
        return queue.determinations != null && queue.determinations.size() > 0 && ((String)queue.determinations.get(0)).equalsIgnoreCase("true");
    }

    public List<String> runTabCompleteProcedure(PlayerTag player, NPCTag npc, Map<String, ObjectTag> context) {
        List<ScriptEntry> entries = this.getEntries(new BukkitScriptEntryData(player, npc), "tab complete");
        ScriptQueue queue = new InstantQueue(this.getName()).addEntries(entries);
        if (context != null) {
            OldEventManager.OldEventContextSource oecs = new OldEventManager.OldEventContextSource();
            oecs.contexts = context;
            queue.setContextSource(oecs);
        }
        queue.start();
        if (queue.determinations != null && queue.determinations.size() > 0) {
            BukkitTagContext tagContext = new BukkitTagContext(player, npc, new ScriptTag(this));
            return ListTag.getListFor(queue.determinations.getObject(0), tagContext);
        }
        return new ArrayList<String>();
    }

    public boolean hasAllowedHelpProcedure() {
        return this.contains("allowed help");
    }

    public boolean hasTabCompleteProcedure() {
        return this.contains("tab complete");
    }
}

