/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.containers.core;

import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.scripts.containers.core.BookScriptContainer;
import com.denizenscript.denizen.scripts.containers.core.ItemScriptHelper;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.nbt.LeatherColorer;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptBuilder;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemScriptContainer
extends ScriptContainer {
    public boolean bound = false;
    String hash = "";
    private ItemTag cleanReference;
    boolean isProcessing = false;

    public ItemScriptContainer(YamlConfiguration configurationSection, String scriptContainerName) {
        super(configurationSection, scriptContainerName);
        ItemScriptHelper.item_scripts.put(this.getName(), this);
        ItemScriptHelper.item_scripts_by_hash_id.put(ItemScriptHelper.createItemScriptID(this), this);
    }

    public ItemTag getCleanReference() {
        if (this.cleanReference == null) {
            this.cleanReference = this.getItemFrom();
        }
        return new ItemTag(this.cleanReference.getItemStack().clone());
    }

    public String getHashID() {
        return this.hash;
    }

    public void setHashID(String HashID) {
        this.hash = HashID;
    }

    public ItemTag getItemFrom() {
        return this.getItemFrom(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemTag getItemFrom(TagContext context) {
        ItemTag stack;
        if (this.isProcessing) {
            Debug.echoError("Item script contains (or chains to) a reference to itself. Cannot process.");
            return null;
        }
        if (context == null) {
            context = new BukkitTagContext(null, null, new ScriptTag(this));
        } else {
            context = new BukkitTagContext((BukkitTagContext)context);
            context.script = new ScriptTag(this);
        }
        this.isProcessing = true;
        try {
            ItemMeta meta;
            if (!this.contains("material")) {
                Debug.echoError("Item script '" + this.getName() + "' does not contain a material. Script cannot function.");
                ItemTag itemTag = null;
                return itemTag;
            }
            String material = TagManager.tag(this.getString("material"), context);
            if (material.startsWith("m@")) {
                material = material.substring(2);
            }
            if ((stack = ItemTag.valueOf(material, this)) == null) {
                ItemTag itemTag = null;
                return itemTag;
            }
            if (this.contains("mechanisms")) {
                YamlConfiguration mechs = this.getConfigurationSection("mechanisms");
                for (StringHolder stringHolder : mechs.getKeys(false)) {
                    String val;
                    if (mechs.isList(stringHolder.str)) {
                        ListTag list = new ListTag();
                        for (String listVal : mechs.getStringList(stringHolder.str)) {
                            list.add(ScriptBuilder.stripLinePrefix(TagManager.tag(listVal, context)));
                        }
                        val = list.identify();
                    } else {
                        val = TagManager.tag(mechs.getString(stringHolder.str), context);
                    }
                    stack.safeAdjust(new Mechanism(new ElementTag(stringHolder.low), new ElementTag(val), context));
                }
            }
            if (this.contains("display name")) {
                meta = stack.getItemStack().getItemMeta();
                String displayName = TagManager.tag(this.getString("display name"), context);
                meta.setDisplayName(displayName);
                stack.getItemStack().setItemMeta(meta);
            }
            if (this.contains("bound")) {
                Deprecations.boundWarning.warn(context);
                this.bound = Boolean.valueOf(TagManager.tag(this.getString("bound"), context));
            }
            if (this.contains("lore")) {
                meta = stack.getItemStack().getItemMeta();
                List lore = meta.hasLore() ? meta.getLore() : new ArrayList();
                for (String line : this.getStringList("lore")) {
                    line = TagManager.tag(line, context);
                    lore.add(line);
                }
                meta.setLore(lore);
                stack.getItemStack().setItemMeta(meta);
            }
            if (this.contains("durability")) {
                short durability = Short.valueOf(this.getString("durability"));
                stack.setDurability(durability);
            }
            if (this.contains("enchantments")) {
                for (String enchantment : this.getStringList("enchantments")) {
                    enchantment = TagManager.tag(enchantment, context);
                    try {
                        int n;
                        boolean bl = true;
                        String[] split = enchantment.split(":");
                        if (split.length > 1) {
                            n = Integer.valueOf(split[1].replace(" ", ""));
                            enchantment = split[0].replace(" ", "");
                        }
                        Enchantment ench = Utilities.getEnchantmentByName(enchantment);
                        stack.getItemStack().addUnsafeEnchantment(ench, n);
                    }
                    catch (Exception exception) {
                        Debug.echoError("While constructing '" + this.getName() + "', encountered error: '" + enchantment + "' is an invalid enchantment: " + exception.getClass().getName() + ": " + exception.getMessage());
                        if (!Debug.verbose) continue;
                        Debug.echoError(exception);
                    }
                }
            }
            if (this.contains("color")) {
                String color = TagManager.tag(this.getString("color"), context);
                LeatherColorer.colorArmor(stack, color);
            }
            if (this.contains("book")) {
                BookScriptContainer book = (BookScriptContainer)ScriptRegistry.getScriptContainer(TagManager.tag(this.getString("book"), context).replace("s@", ""));
                stack = book.writeBookTo(stack, context);
            }
            stack.setItemScript(this);
        }
        catch (Exception e) {
            Debug.echoError("Woah! An exception has been called with this item script!");
            Debug.echoError(e);
            stack = null;
        }
        finally {
            this.isProcessing = false;
        }
        return stack;
    }
}

