/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.block;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.utilities.Deprecations;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDispenseEvent;

public class BlockDispensesScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static BlockDispensesScriptEvent instance;
    public LocationTag location;
    public ItemTag item;
    private MaterialTag material;
    public BlockDispenseEvent event;

    public BlockDispensesScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventArgLowerAt(1).equals("dispenses");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        String iTest = path.eventArgLowerAt(2);
        if (!iTest.equals("item") && !this.tryItem(this.item, iTest)) {
            return false;
        }
        if (!this.tryMaterial(this.material, path.eventArgLowerAt(0))) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "BlockDispenses";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String determination = determinationObj.toString();
        if (ArgumentHelper.matchesDouble(determination)) {
            Deprecations.blockDispensesItemDetermination.warn();
            this.event.setVelocity(this.event.getVelocity().multiply(Double.parseDouble(determination)));
            return true;
        }
        if (LocationTag.matches(determination)) {
            LocationTag vel = LocationTag.valueOf(determination);
            if (vel == null) {
                Debug.echoError("[" + this.getName() + "] Invalid velocity '" + determination + "'!");
            } else {
                this.event.setVelocity(vel.toVector());
            }
            return true;
        }
        if (ItemTag.matches(determination)) {
            ItemTag it = ItemTag.valueOf(determination, path.container);
            if (it == null) {
                Debug.echoError("[" + this.getName() + "] Invalid item '" + determination + "'!");
            } else {
                this.item = it;
                this.event.setItem(this.item.getItemStack());
            }
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("location")) {
            return this.location;
        }
        if (name.equals("item")) {
            return this.item;
        }
        if (name.equals("velocity")) {
            return new LocationTag(this.event.getVelocity());
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onBlockDispenses(BlockDispenseEvent event) {
        this.location = new LocationTag(event.getBlock().getLocation());
        this.material = new MaterialTag(event.getBlock());
        this.item = new ItemTag(event.getItem());
        this.event = event;
        this.fire((Event)event);
    }
}

