/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.block;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import org.bukkit.Material;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockFromToEvent;

public class LiquidSpreadScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static LiquidSpreadScriptEvent instance;
    public MaterialTag material;
    public LocationTag location;
    public LocationTag destination;
    public BlockFromToEvent event;

    public LiquidSpreadScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (path.eventLower.startsWith("block")) {
            return false;
        }
        if (path.eventLower.startsWith("dragon egg moves")) {
            return true;
        }
        return path.eventArgLowerAt(1).equals("spreads");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String mat;
        if (path.eventLower.startsWith("dragon egg moves") ? this.material.getMaterial() != Material.DRAGON_EGG : !(mat = path.eventArgLowerAt(0)).equals("liquid") && !this.tryMaterial(this.material, mat)) {
            return false;
        }
        if (!this.runInCheck(path, this.location) && !this.runInCheck(path, this.destination)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "LiquidSpreads";
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("location")) {
            return this.location;
        }
        if (name.equals("destination")) {
            return this.destination;
        }
        if (name.equals("material")) {
            return this.material;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onLiquidSpreads(BlockFromToEvent event) {
        this.destination = new LocationTag(event.getToBlock().getLocation());
        this.location = new LocationTag(event.getBlock().getLocation());
        this.material = new MaterialTag(event.getBlock());
        this.event = event;
        this.fire((Event)event);
    }
}

