/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class EntitySpawnScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static EntitySpawnScriptEvent instance;
    public EntityTag entity;
    public LocationTag location;
    public ElementTag reason;
    public CreatureSpawnEvent event;

    public EntitySpawnScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventArgLowerAt(1).equals("spawns") && !path.eventLower.startsWith("item") && !path.eventLower.startsWith("spawner");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.tryEntity(this.entity, path.eventArgLowerAt(0))) {
            return false;
        }
        if (path.eventArgLowerAt(2).equals("because") && !path.eventArgLowerAt(3).equalsIgnoreCase(this.reason.toString())) {
            return false;
        }
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "EntitySpawn";
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("entity")) {
            return this.entity;
        }
        if (name.equals("location")) {
            return this.location;
        }
        if (name.equals("reason")) {
            return this.reason;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        LivingEntity entity = event.getEntity();
        this.entity = new EntityTag((Entity)entity);
        this.location = new LocationTag(event.getLocation());
        this.reason = new ElementTag(event.getSpawnReason().name());
        this.event = event;
        EntityTag.rememberEntity((Entity)entity);
        this.fire((Event)event);
        EntityTag.forgetEntity((Entity)entity);
    }
}

