/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import org.bukkit.Material;

public class ItemApple
implements Property {
    public static final String[] handledTags = new String[]{"apple_enchanted"};
    public static final String[] handledMechs = new String[]{"apple_enchanted"};
    ItemTag item;

    public static boolean describes(ObjectTag item) {
        return item instanceof ItemTag && (((ItemTag)item).getItemStack().getType() == Material.GOLDEN_APPLE || NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13) && ((ItemTag)item).getItemStack().getType() == Material.ENCHANTED_GOLDEN_APPLE);
    }

    public static ItemApple getFrom(ObjectTag _item) {
        if (!ItemApple.describes(_item)) {
            return null;
        }
        return new ItemApple((ItemTag)_item);
    }

    private ItemApple(ItemTag _item) {
        this.item = _item;
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("apple_enchanted")) {
            if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13)) {
                return new ElementTag(this.item.getItemStack().getType() == Material.ENCHANTED_GOLDEN_APPLE).getObjectAttribute(attribute.fulfill(1));
            }
            return new ElementTag(this.item.getItemStack().getDurability() == 1).getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public String getPropertyString() {
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13)) {
            return null;
        }
        if (this.item.getItemStack().getDurability() == 1) {
            return "true";
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "apple_enchanted";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("apple_enchanted") && mechanism.requireBoolean()) {
            if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13)) {
                this.item.getItemStack().setType(mechanism.getValue().asBoolean() ? Material.ENCHANTED_GOLDEN_APPLE : Material.GOLDEN_APPLE);
            }
            this.item.getItemStack().setDurability((short)(mechanism.getValue().asBoolean() ? 1 : 0));
        }
    }
}

