/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.scripts.containers.core.ItemScriptHelper;
import com.denizenscript.denizen.utilities.Settings;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.core.EscapeTagBase;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemLore
implements Property {
    public static final String[] handledTags = new String[]{"lore", "has_lore"};
    public static final String[] handledMechs = new String[]{"lore"};
    ItemTag item;

    public static boolean describes(ObjectTag item) {
        return item instanceof ItemTag;
    }

    public static ItemLore getFrom(ObjectTag _item) {
        if (!ItemLore.describes(_item)) {
            return null;
        }
        return new ItemLore((ItemTag)_item);
    }

    public boolean hasLore() {
        return this.item.getItemStack().hasItemMeta() && this.item.getItemStack().getItemMeta().hasLore();
    }

    private ItemLore(ItemTag _item) {
        this.item = _item;
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("lore") && this.hasLore()) {
            ArrayList<String> loreList = new ArrayList<String>();
            for (String itemLore : this.item.getItemStack().getItemMeta().getLore()) {
                if (itemLore.startsWith("\u00a70id:") || itemLore.startsWith(ItemScriptHelper.ItemScriptHashID)) continue;
                loreList.add(itemLore);
            }
            return new ListTag((List<String>)loreList).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_lore")) {
            return new ElementTag(this.hasLore()).getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public String getPropertyString() {
        if (this.hasLore()) {
            StringBuilder output = new StringBuilder();
            for (String itemLore : this.item.getItemStack().getItemMeta().getLore()) {
                if (itemLore.startsWith("\u00a70id:") || itemLore.startsWith(ItemScriptHelper.ItemScriptHashID)) continue;
                output.append(EscapeTagBase.escape(itemLore)).append("|");
            }
            return output.length() == 0 ? null : output.substring(0, output.length() - 1);
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "lore";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("lore")) {
            ItemMeta meta = this.item.getItemStack().getItemMeta();
            ListTag lore = mechanism.valueAsType(ListTag.class);
            CoreUtilities.fixNewLinesToListSeparation(lore);
            if (this.item.isItemscript() && !Settings.packetInterception()) {
                lore.add(0, ItemScriptHelper.createItemScriptID(this.item.getScriptName()));
            }
            for (int i = 0; i < lore.size(); ++i) {
                lore.set(i, CoreUtilities.clearNBSPs(EscapeTagBase.unEscape((String)lore.get(i))));
            }
            meta.setLore((List)lore);
            this.item.getItemStack().setItemMeta(meta);
        }
    }
}

