/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.core;

import com.denizenscript.denizen.flags.FlagManager;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import org.bukkit.event.Listener;

public class FlagCommand
extends AbstractCommand
implements Listener {
    public FlagCommand() {
        this.setName("flag");
        this.setSyntax("flag [player/npc/server/<entity>] [<name>([<#>])](:<action>)[:<value>] (duration:<value>)");
        this.setRequiredArguments(1, 3);
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        boolean specified_target = false;
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            String[] flagArgs;
            if (!scriptEntry.hasObject("duration") && arg.matchesPrefix("duration", "d") && arg.matchesArgumentType(DurationTag.class)) {
                scriptEntry.addObject("duration", arg.asType(DurationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("flag_target") && arg.matches("npc", "denizen")) {
                specified_target = true;
                scriptEntry.addObject("flag_target", Utilities.getEntryNPC(scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("flag_target") && arg.matches("server")) {
                specified_target = true;
                scriptEntry.addObject("flag_target", new ElementTag("server"));
                continue;
            }
            if (!scriptEntry.hasObject("flag_target") && arg.matches("global")) {
                Deprecations.globalTagName.warn(scriptEntry);
                specified_target = true;
                scriptEntry.addObject("flag_target", new ElementTag("server"));
                continue;
            }
            if (!scriptEntry.hasObject("flag_target") && arg.matches("player")) {
                specified_target = true;
                scriptEntry.addObject("flag_target", Utilities.getEntryPlayer(scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("flag_target") && arg.startsWith("n@") && !arg.hasPrefix()) {
                if (NPCTag.valueOf(arg.getValue()) == null) {
                    throw new InvalidArgumentsException("Invalid NPC target.");
                }
                specified_target = true;
                scriptEntry.addObject("flag_target", arg.asType(NPCTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("flag_target") && arg.startsWith("p@") && !arg.hasPrefix()) {
                if (PlayerTag.valueOf(arg.getValue()) == null) {
                    throw new InvalidArgumentsException("Invalid Player target.");
                }
                specified_target = true;
                scriptEntry.addObject("flag_target", arg.asType(PlayerTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("flag_target") && !arg.hasPrefix()) {
                if (EntityTag.valueOf(arg.getValue()) == null) {
                    throw new InvalidArgumentsException("Invalid Entity target.");
                }
                specified_target = true;
                scriptEntry.addObject("flag_target", arg.asType(EntityTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("flag_name") && arg.raw_value.split(":", 3).length == 1) {
                scriptEntry.addObject("action", (Object)FlagManager.Action.SET_BOOLEAN);
                scriptEntry.addObject("value", new ElementTag(true));
                scriptEntry.addObject("flag_name", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("flag_name") && arg.raw_value.split(":", 3).length == 2) {
                flagArgs = arg.raw_value.split(":", 2);
                scriptEntry.addObject("flag_name", new ElementTag(flagArgs[0].toUpperCase()));
                if (flagArgs[1].equals("++") || flagArgs[1].equals("+")) {
                    scriptEntry.addObject("action", (Object)FlagManager.Action.INCREASE);
                    scriptEntry.addObject("value", new ElementTag(1));
                    continue;
                }
                if (flagArgs[1].equals("--") || flagArgs[1].equals("-")) {
                    scriptEntry.addObject("action", (Object)FlagManager.Action.DECREASE);
                    scriptEntry.addObject("value", new ElementTag(1));
                    continue;
                }
                if (flagArgs[1].equals("!")) {
                    scriptEntry.addObject("action", (Object)FlagManager.Action.DELETE);
                    scriptEntry.addObject("value", new ElementTag(false));
                    continue;
                }
                if (flagArgs[1].equals("<-")) {
                    scriptEntry.addObject("action", (Object)FlagManager.Action.REMOVE);
                    scriptEntry.addObject("value", new ElementTag(false));
                    continue;
                }
                scriptEntry.addObject("action", (Object)FlagManager.Action.SET_VALUE);
                scriptEntry.addObject("value", new ElementTag(flagArgs[1]));
                continue;
            }
            if (!scriptEntry.hasObject("flag_name") && arg.raw_value.split(":", 3).length == 3) {
                flagArgs = arg.raw_value.split(":", 3);
                scriptEntry.addObject("flag_name", new ElementTag(flagArgs[0].toUpperCase()));
                if (flagArgs[1].equals("->")) {
                    scriptEntry.addObject("action", (Object)FlagManager.Action.INSERT);
                } else if (flagArgs[1].equals("<-")) {
                    scriptEntry.addObject("action", (Object)FlagManager.Action.REMOVE);
                } else if (flagArgs[1].equals("||") || flagArgs[1].equals("|")) {
                    scriptEntry.addObject("action", (Object)FlagManager.Action.SPLIT);
                } else if (flagArgs[1].equals("!|")) {
                    scriptEntry.addObject("action", (Object)FlagManager.Action.SPLIT_NEW);
                } else if (flagArgs[1].equals("++") || flagArgs[1].equals("+")) {
                    scriptEntry.addObject("action", (Object)FlagManager.Action.INCREASE);
                } else if (flagArgs[1].equals("--") || flagArgs[1].equals("-")) {
                    scriptEntry.addObject("action", (Object)FlagManager.Action.DECREASE);
                } else if (flagArgs[1].equals("**") || flagArgs[1].equals("*")) {
                    scriptEntry.addObject("action", (Object)FlagManager.Action.MULTIPLY);
                } else if (flagArgs[1].equals("//") || flagArgs[1].equals("/")) {
                    scriptEntry.addObject("action", (Object)FlagManager.Action.DIVIDE);
                } else {
                    scriptEntry.addObject("action", (Object)FlagManager.Action.SET_VALUE);
                    scriptEntry.addObject("value", new ElementTag(arg.raw_value.split(":", 2)[1]));
                    continue;
                }
                scriptEntry.addObject("value", new ElementTag(flagArgs[2]));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!specified_target) {
            scriptEntry.defaultObject("flag_target", Utilities.getEntryPlayer(scriptEntry));
        }
        if (!scriptEntry.hasObject("action")) {
            throw new InvalidArgumentsException("Must specify a flag action or value.");
        }
        if (!scriptEntry.hasObject("flag_target")) {
            throw new InvalidArgumentsException("Must specify a flag target!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        FlagManager.Flag flag;
        Object flag_target = scriptEntry.getObjectTag("flag_target");
        DurationTag duration = (DurationTag)scriptEntry.getObjectTag("duration");
        FlagManager.Action action = (FlagManager.Action)((Object)scriptEntry.getObject("action"));
        ElementTag value = scriptEntry.getElement("value");
        ElementTag name = scriptEntry.getElement("flag_name");
        int index = -1;
        if (CoreUtilities.contains(name.asString(), '[')) {
            try {
                index = Integer.valueOf(name.asString().split("\\[")[1].replace("]", ""));
            }
            catch (Exception e) {
                index = -1;
            }
            name = ElementTag.valueOf(name.asString().split("\\[")[0]);
        }
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), name.debug() + (index > 0 ? ArgumentHelper.debugObj("Index", String.valueOf(index)) : "") + ArgumentHelper.debugUniqueObj("Action/Value", action.toString(), value != null ? value.asString() : "null") + (duration != null ? duration.debug() : "") + flag_target.debug());
        }
        if (flag_target instanceof ElementTag) {
            flag = DenizenAPI.getCurrentInstance().flagManager().getGlobalFlag(name.asString());
        } else if (flag_target instanceof PlayerTag) {
            flag = DenizenAPI.getCurrentInstance().flagManager().getPlayerFlag((PlayerTag)flag_target, name.asString());
        } else if (flag_target instanceof NPCTag) {
            flag = DenizenAPI.getCurrentInstance().flagManager().getNPCFlag(((NPCTag)flag_target).getId(), name.asString());
        } else if (flag_target instanceof EntityTag) {
            flag = DenizenAPI.getCurrentInstance().flagManager().getEntityFlag((EntityTag)flag_target, name.asString());
        } else {
            Debug.echoError("Could not fetch a flag for this entity: " + flag_target.debug());
            return;
        }
        flag.doAction(action, value, index, scriptEntry);
        if (flag.StillValid() && duration != null && duration.getSeconds() > 0.0) {
            flag.setExpiration(DenizenCore.currentTimeMillis + Double.valueOf(duration.getSeconds() * 1000.0).longValue());
        } else if (flag.StillValid() && flag.expiration().getMillis() != 0L) {
            flag.setExpiration(0L);
        }
    }
}

