/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.world;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.interfaces.WorldHelper;
import com.denizenscript.denizen.objects.CuboidTag;
import com.denizenscript.denizen.objects.EllipsoidTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.Holdable;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.scripts.queues.core.InstantQueue;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ModifyBlockCommand
extends AbstractCommand
implements Listener,
Holdable {
    boolean no_physics = false;
    public final List<Location> block_physics = new ArrayList<Location>();
    long tick = 0L;
    long physitick = 0L;

    public ModifyBlockCommand() {
        this.setName("modifyblock");
        this.setSyntax("modifyblock [<location>|.../<ellipsoid>/<cuboid>] [<material>|...] (no_physics/naturally) (delayed) (<script>) (<percent chance>|...) (source:<player>)");
        this.setRequiredArguments(2, 7);
        DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

            @Override
            public void run() {
                ++ModifyBlockCommand.this.tick;
                if (ModifyBlockCommand.this.physitick < ModifyBlockCommand.this.tick - 1L) {
                    ModifyBlockCommand.this.block_physics.clear();
                }
            }
        }, 2L, 2L);
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (arg.matchesArgumentType(CuboidTag.class) && !scriptEntry.hasObject("locations") && !scriptEntry.hasObject("location_list") && arg.startsWith("cu@")) {
                scriptEntry.addObject("locations", arg.asType(CuboidTag.class).getBlockLocationsUnfiltered());
                continue;
            }
            if (arg.matchesArgumentType(EllipsoidTag.class) && !scriptEntry.hasObject("locations") && !scriptEntry.hasObject("location_list") && arg.startsWith("ellipsoid@")) {
                scriptEntry.addObject("locations", arg.asType(EllipsoidTag.class).getBlockLocationsUnfiltered());
                continue;
            }
            if (arg.matchesArgumentList(LocationTag.class) && !scriptEntry.hasObject("locations") && !scriptEntry.hasObject("location_list")) {
                scriptEntry.addObject("location_list", arg.asType(ListTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("materials") && arg.matchesArgumentList(MaterialTag.class)) {
                scriptEntry.addObject("materials", arg.asType(ListTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("radius") && arg.matchesPrefix("radius", "r") && arg.matchesInteger()) {
                scriptEntry.addObject("radius", new ElementTag(arg.getValue()));
                continue;
            }
            if (!scriptEntry.hasObject("height") && arg.matchesPrefix("height", "h") && arg.matchesInteger()) {
                scriptEntry.addObject("height", new ElementTag(arg.getValue()));
                continue;
            }
            if (!scriptEntry.hasObject("depth") && arg.matchesPrefix("depth", "d") && arg.matchesInteger()) {
                scriptEntry.addObject("depth", new ElementTag(arg.getValue()));
                continue;
            }
            if (!scriptEntry.hasObject("source") && arg.matchesPrefix("source") && arg.matchesArgumentType(PlayerTag.class)) {
                scriptEntry.addObject("source", arg.asType(PlayerTag.class));
                continue;
            }
            if (arg.matches("no_physics")) {
                scriptEntry.addObject("physics", new ElementTag(false));
                continue;
            }
            if (arg.matches("naturally")) {
                scriptEntry.addObject("natural", new ElementTag(true));
                continue;
            }
            if (arg.matches("delayed")) {
                scriptEntry.addObject("delayed", new ElementTag(true));
                continue;
            }
            if (!scriptEntry.hasObject("script") && arg.matchesArgumentType(ScriptTag.class)) {
                scriptEntry.addObject("script", arg.asType(ScriptTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("percents")) {
                scriptEntry.addObject("percents", arg.asType(ListTag.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("materials")) {
            throw new InvalidArgumentsException("Missing material argument!");
        }
        if (!scriptEntry.hasObject("locations") && !scriptEntry.hasObject("location_list")) {
            throw new InvalidArgumentsException("Missing location argument!");
        }
        scriptEntry.defaultObject("radius", new ElementTag(0)).defaultObject("height", new ElementTag(0)).defaultObject("depth", new ElementTag(0)).defaultObject("physics", new ElementTag(true)).defaultObject("natural", new ElementTag(false)).defaultObject("delayed", new ElementTag(false));
    }

    @Override
    public void execute(final ScriptEntry scriptEntry) {
        ListTag materials = (ListTag)scriptEntry.getObjectTag("materials");
        final List locations = (List)scriptEntry.getObject("locations");
        final ListTag location_list = (ListTag)scriptEntry.getObjectTag("location_list");
        ElementTag physics = scriptEntry.getElement("physics");
        ElementTag natural = scriptEntry.getElement("natural");
        ElementTag delayed = scriptEntry.getElement("delayed");
        ElementTag radiusElement = scriptEntry.getElement("radius");
        ElementTag heightElement = scriptEntry.getElement("height");
        ElementTag depthElement = scriptEntry.getElement("depth");
        final ScriptTag script = (ScriptTag)scriptEntry.getObjectTag("script");
        PlayerTag source = (PlayerTag)scriptEntry.getObjectTag("source");
        ListTag percents = (ListTag)scriptEntry.getObjectTag("percents");
        if (percents != null && percents.size() != materials.size()) {
            Debug.echoError(scriptEntry.getResidingQueue(), "Percents length != materials length");
            percents = null;
        }
        final List<MaterialTag> materialList = materials.filter(MaterialTag.class, scriptEntry);
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), (locations == null ? location_list.debug() : ArgumentHelper.debugList("locations", locations)) + materials.debug() + physics.debug() + radiusElement.debug() + heightElement.debug() + depthElement.debug() + natural.debug() + delayed.debug() + (script != null ? script.debug() : "") + (percents != null ? percents.debug() : "") + (source != null ? source.debug() : ""));
        }
        final Player sourcePlayer = source == null ? null : source.getPlayerEntity();
        final boolean doPhysics = physics.asBoolean();
        final boolean isNatural = natural.asBoolean();
        final int radius = radiusElement.asInt();
        final int height = heightElement.asInt();
        final int depth = depthElement.asInt();
        ArrayList<Float> percentages = null;
        if (percents != null) {
            percentages = new ArrayList<Float>();
            for (String str : percents) {
                percentages.add(Float.valueOf(new ElementTag(str).asFloat()));
            }
        }
        final ArrayList<Float> percs = percentages;
        if (locations == null && location_list == null) {
            Debug.echoError("Must specify a valid location!");
            return;
        }
        if (location_list != null && location_list.isEmpty() || locations != null && locations.isEmpty()) {
            return;
        }
        if (materialList.isEmpty()) {
            Debug.echoError("Must specify a valid material!");
            return;
        }
        boolean bl = this.no_physics = !doPhysics;
        if (delayed.asBoolean()) {
            new BukkitRunnable(){
                int index = 0;

                public void run() {
                    long start = System.currentTimeMillis();
                    LocationTag loc = locations != null ? (LocationTag)locations.get(0) : LocationTag.valueOf((String)location_list.get(0));
                    boolean was_static = ModifyBlockCommand.this.preSetup(loc);
                    while (locations != null && locations.size() > this.index || location_list != null && location_list.size() > this.index) {
                        LocationTag nLoc = locations != null ? (LocationTag)locations.get(this.index) : LocationTag.valueOf((String)location_list.get(this.index));
                        ModifyBlockCommand.this.handleLocation(nLoc, this.index, materialList, doPhysics, isNatural, radius, height, depth, percs, sourcePlayer, scriptEntry);
                        ++this.index;
                        if (System.currentTimeMillis() - start <= 50L) continue;
                        break;
                    }
                    ModifyBlockCommand.this.postComplete(loc, was_static);
                    if (locations != null && locations.size() == this.index || location_list != null && location_list.size() == this.index) {
                        if (script != null) {
                            List<ScriptEntry> entries = script.getContainer().getBaseEntries(scriptEntry.entryData.clone());
                            ScriptQueue queue = new InstantQueue(script.getContainer().getName()).addEntries(entries);
                            queue.start();
                        }
                        scriptEntry.setFinished(true);
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)DenizenAPI.getCurrentInstance(), 1L, 1L);
        } else {
            LocationTag loc = locations != null ? (LocationTag)locations.get(0) : LocationTag.valueOf((String)location_list.get(0));
            boolean was_static = this.preSetup(loc);
            int index = 0;
            if (locations != null) {
                for (ObjectTag obj : locations) {
                    this.handleLocation((LocationTag)obj, index, materialList, doPhysics, isNatural, radius, height, depth, percentages, sourcePlayer, scriptEntry);
                    ++index;
                }
            } else {
                for (String str : location_list) {
                    this.handleLocation(LocationTag.valueOf(str), index, materialList, doPhysics, isNatural, radius, height, depth, percentages, sourcePlayer, scriptEntry);
                    ++index;
                }
            }
            this.postComplete(loc, was_static);
            scriptEntry.setFinished(true);
        }
    }

    boolean preSetup(LocationTag loc0) {
        WorldHelper worldHelper = NMSHandler.getWorldHelper();
        World world = loc0.getWorld();
        boolean was_static = worldHelper.isStatic(world);
        if (this.no_physics) {
            worldHelper.setStatic(world, true);
        }
        return was_static;
    }

    void postComplete(Location loc, boolean was_static) {
        if (this.no_physics) {
            NMSHandler.getWorldHelper().setStatic(loc.getWorld(), was_static);
        }
        this.no_physics = false;
    }

    void handleLocation(LocationTag location, int index, List<MaterialTag> materialList, boolean doPhysics, boolean isNatural, int radius, int height, int depth, List<Float> percents, Player source, ScriptEntry entry) {
        int y;
        int z;
        MaterialTag material;
        if (percents == null) {
            material = materialList.get(index % materialList.size());
        } else {
            material = null;
            for (int i = 0; i < materialList.size(); ++i) {
                float perc = percents.get(i).floatValue() / 100.0f;
                if (!(CoreUtilities.getRandom().nextDouble() <= (double)perc)) continue;
                material = materialList.get(i);
                break;
            }
            if (material == null) {
                return;
            }
        }
        World world = location.getWorld();
        location.setX(location.getBlockX());
        location.setY(location.getBlockY());
        location.setZ(location.getBlockZ());
        if (source != null) {
            Object event = material.getMaterial() == Material.AIR ? new BlockBreakEvent(location.getBlock(), source) : new BlockPlaceEvent(location.getBlock(), material.getModernData().getBlockState(), location.getBlock(), new ItemTag(material, 1).getItemStack(), source, true, EquipmentSlot.HAND);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (((Cancellable)event).isCancelled()) {
                if (entry.dbCallShouldDebug()) {
                    Debug.echoDebug((Debuggable)entry, "Source event cancelled, not changing block.");
                }
                return;
            }
        }
        this.setBlock(location, material, doPhysics, isNatural);
        if (radius != 0) {
            for (int x = 0; x < 2 * radius + 1; ++x) {
                for (z = 0; z < 2 * radius + 1; ++z) {
                    this.setBlock(new Location(world, location.getX() + (double)x - (double)radius, location.getY(), location.getZ() + (double)z - (double)radius), material, doPhysics, isNatural);
                }
            }
        }
        if (height != 0) {
            for (int x = 0; x < 2 * radius + 1; ++x) {
                for (z = 0; z < 2 * radius + 1; ++z) {
                    for (y = 1; y < height + 1; ++y) {
                        this.setBlock(new Location(world, location.getX() + (double)x - (double)radius, location.getY() + (double)y, location.getZ() + (double)z - (double)radius), material, doPhysics, isNatural);
                    }
                }
            }
        }
        if (depth != 0) {
            for (int x = 0; x < 2 * radius + 1; ++x) {
                for (z = 0; z < 2 * radius + 1; ++z) {
                    for (y = 1; y < depth + 1; ++y) {
                        this.setBlock(new Location(world, location.getX() + (double)x - (double)radius, location.getY() - (double)y, location.getZ() + (double)z - (double)radius), material, doPhysics, isNatural);
                    }
                }
            }
        }
    }

    void setBlock(Location location, MaterialTag material, boolean physics, boolean natural) {
        if (physics) {
            for (int i = 0; i < this.block_physics.size(); ++i) {
                if (!this.compareloc(this.block_physics.get(i), location)) continue;
                this.block_physics.remove(i--);
            }
        } else {
            this.block_physics.add(location);
            this.physitick = this.tick;
        }
        if (location.getY() < 0.0 || location.getY() > 255.0) {
            Debug.echoError("Invalid modifyblock location: " + new LocationTag(location).toString());
            return;
        }
        if (natural && material.getMaterial() == Material.AIR) {
            location.getBlock().breakNaturally();
        } else {
            material.getNmsBlockData().setBlock(location.getBlock(), physics);
        }
    }

    @EventHandler
    public void blockPhysics(BlockPhysicsEvent event) {
        if (this.no_physics) {
            event.setCancelled(true);
        }
        for (Location loc : this.block_physics) {
            if (!this.compareloc(event.getBlock().getLocation(), loc)) continue;
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void blockChanges(EntityChangeBlockEvent event) {
        if (event.getEntity().getType() != EntityType.FALLING_BLOCK) {
            return;
        }
        if (this.no_physics) {
            event.setCancelled(true);
        }
        for (Location loc : this.block_physics) {
            if (!this.compareloc(event.getBlock().getLocation(), loc)) continue;
            event.setCancelled(true);
        }
    }

    boolean compareloc(Location lone, Location ltwo) {
        return lone.getBlockX() == ltwo.getBlockX() && lone.getBlockY() == ltwo.getBlockY() && lone.getBlockZ() == ltwo.getBlockZ() && lone.getWorld().getName().equalsIgnoreCase(ltwo.getWorld().getName());
    }
}

