/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.world;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.nms.interfaces.BlockData;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.blocks.MaterialCompat;
import com.denizenscript.denizen.utilities.blocks.ModernBlockData;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.depends.Depends;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.HashMap;
import java.util.Map;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class SwitchCommand
extends AbstractCommand {
    private Map<Location, Integer> taskMap = new HashMap<Location, Integer>(32);

    public SwitchCommand() {
        this.setName("switch");
        this.setSyntax("switch [<location>|...] (state:[{toggle}/on/off]) (duration:<value>)");
        this.setRequiredArguments(1, 3);
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("locations") && arg.matchesArgumentList(LocationTag.class)) {
                scriptEntry.addObject("locations", arg.asType(ListTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("duration") && arg.matchesArgumentType(DurationTag.class)) {
                scriptEntry.addObject("duration", arg.asType(DurationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("state") && arg.matchesEnum(SwitchState.values())) {
                scriptEntry.addObject("switchstate", new ElementTag(arg.getValue().toUpperCase()));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("locations")) {
            throw new InvalidArgumentsException("Must specify a location!");
        }
        scriptEntry.defaultObject("duration", new DurationTag(0));
        scriptEntry.defaultObject("switchstate", new ElementTag("TOGGLE"));
    }

    @Override
    public void execute(final ScriptEntry scriptEntry) {
        Player player;
        ListTag interactLocations = (ListTag)scriptEntry.getObjectTag("locations");
        long duration = ((DurationTag)scriptEntry.getObject("duration")).getTicks();
        SwitchState switchState = SwitchState.valueOf(scriptEntry.getElement("switchstate").asString());
        Player player2 = player = Utilities.entryHasPlayer(scriptEntry) ? Utilities.getEntryPlayer(scriptEntry).getPlayerEntity() : null;
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), interactLocations.debug() + ArgumentHelper.debugObj("duration", duration + "t") + ArgumentHelper.debugObj("switchstate", switchState.name()));
        }
        for (final LocationTag interactLocation : interactLocations.filter(LocationTag.class, scriptEntry)) {
            this.switchBlock(scriptEntry, interactLocation, switchState, player);
            if (duration <= 0L) continue;
            if (this.taskMap.containsKey(interactLocation)) {
                try {
                    Bukkit.getScheduler().cancelTask(this.taskMap.get(interactLocation).intValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Debug.echoDebug((Debuggable)scriptEntry, "Setting delayed task 'SWITCH' for " + interactLocation.identify());
            this.taskMap.put(interactLocation, Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

                @Override
                public void run() {
                    SwitchCommand.this.switchBlock(scriptEntry, interactLocation, SwitchState.TOGGLE, player);
                }
            }, duration));
        }
    }

    public static boolean switchState(Block b) {
        ModernBlockData mbd;
        Boolean switchState;
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13) && (switchState = (mbd = new ModernBlockData(b)).getSwitchState()) != null) {
            return switchState;
        }
        Material type = b.getType();
        if (type == MaterialCompat.IRON_DOOR || type == MaterialCompat.OAK_DOOR || type == Material.DARK_OAK_DOOR || type == Material.BIRCH_DOOR || type == Material.ACACIA_DOOR || type == Material.JUNGLE_DOOR || type == Material.SPRUCE_DOOR) {
            Location location = b.getLocation();
            byte data = b.getData();
            if (data >= 8) {
                location = b.getLocation().clone().add(0.0, -1.0, 0.0);
            }
            return (location.getBlock().getData() & 4) > 0;
        }
        if (type == MaterialCompat.OAK_TRAPDOOR || type == Material.IRON_TRAPDOOR || NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13) && (type == Material.DARK_OAK_TRAPDOOR || type == Material.BIRCH_TRAPDOOR || type == Material.ACACIA_TRAPDOOR || type == Material.JUNGLE_TRAPDOOR || type == Material.SPRUCE_TRAPDOOR)) {
            return (b.getData() & 4) > 0;
        }
        return (b.getData() & 8) > 0;
    }

    public void switchBlock(ScriptEntry scriptEntry, Location interactLocation, SwitchState switchState, Player player) {
        boolean currentState = SwitchCommand.switchState(interactLocation.getBlock());
        if (switchState.equals((Object)SwitchState.ON) && !currentState || switchState.equals((Object)SwitchState.OFF) && currentState || switchState.equals((Object)SwitchState.TOGGLE)) {
            if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13)) {
                ModernBlockData mbd = new ModernBlockData(interactLocation.getBlock());
                mbd.setSwitchState(interactLocation.getBlock(), !currentState);
            } else {
                try {
                    if (interactLocation.getBlock().getType() == MaterialCompat.IRON_DOOR) {
                        Location block = interactLocation.clone().add(0.0, -1.0, 0.0).getBlock().getType() == MaterialCompat.IRON_DOOR ? interactLocation.clone().add(0.0, -1.0, 0.0) : interactLocation;
                        BlockData blockData = NMSHandler.getBlockHelper().getBlockData(MaterialCompat.IRON_DOOR, (byte)(block.getBlock().getData() ^ 4));
                        blockData.setBlock(block.getBlock(), false);
                    } else {
                        if (player == null && Bukkit.getOnlinePlayers().size() > 0) {
                            if (Bukkit.getOnlinePlayers().size() > 0) {
                                player = (Player)Bukkit.getOnlinePlayers().toArray()[0];
                            } else if (Depends.citizens != null) {
                                for (NPC npc : CitizensAPI.getNPCRegistry()) {
                                    if (!npc.isSpawned() || !(npc.getEntity() instanceof Player)) continue;
                                    player = (Player)npc.getEntity();
                                    break;
                                }
                            }
                        }
                        NMSHandler.getEntityHelper().forceInteraction(player, interactLocation);
                    }
                }
                catch (NullPointerException e) {
                    Debug.echoError("Cannot switch " + interactLocation.getBlock().getType().toString() + "!");
                    return;
                }
            }
            Debug.echoDebug((Debuggable)scriptEntry, "Switched " + interactLocation.getBlock().getType().toString() + "! Current state now: " + (SwitchCommand.switchState(interactLocation.getBlock()) ? "ON" : "OFF"));
        }
    }

    private static enum SwitchState {
        ON,
        OFF,
        TOGGLE;

    }
}

