/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.containers.core;

import com.denizenscript.denizen.events.entity.EntityDespawnScriptEvent;
import com.denizenscript.denizen.flags.FlagManager;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.properties.entity.EntityBoundingBox;
import com.denizenscript.denizen.utilities.DataPersistenceHelper;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.world.DenizenWorldAccess;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.plugin.Plugin;

public class EntityScriptHelper
implements Listener {
    static HashMap<UUID, String> entities = new HashMap();

    public EntityScriptHelper() {
        DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEntityDeath(EntityDeathEvent event) {
        LivingEntity entity = event.getEntity();
        EntityTag.rememberEntity((Entity)entity);
        EntityDespawnScriptEvent.instance.entity = new EntityTag((Entity)entity);
        EntityDespawnScriptEvent.instance.cause = new ElementTag("DEATH");
        EntityDespawnScriptEvent.instance.cancelled = false;
        EntityDespawnScriptEvent.instance.fire();
        EntityTag.forgetEntity((Entity)entity);
        EntityScriptHelper.unlinkEntity((Entity)event.getEntity());
    }

    public static void linkWorld(World world) {
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_14)) {
            return;
        }
        NMSHandler.getWorldHelper().setWorldAccess(world, new DenizenWorldAccess());
    }

    public static void unlinkWorld(World world) {
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_14)) {
            return;
        }
        NMSHandler.getWorldHelper().removeWorldAccess(world);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onWorldLoad(WorldLoadEvent event) {
        EntityScriptHelper.linkWorld(event.getWorld());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onWorldUnload(WorldUnloadEvent event) {
        if (event.isCancelled()) {
            return;
        }
        EntityScriptHelper.unlinkWorld(event.getWorld());
    }

    @EventHandler
    public void onChunkUnload(ChunkUnloadEvent event) {
        if (event instanceof Cancellable && ((Cancellable)event).isCancelled()) {
            return;
        }
        for (Entity ent : event.getChunk().getEntities()) {
            if (ent instanceof LivingEntity && !((LivingEntity)ent).getRemoveWhenFarAway()) continue;
            EntityTag.rememberEntity(ent);
            EntityDespawnScriptEvent.instance.entity = new EntityTag(ent);
            EntityDespawnScriptEvent.instance.cause = new ElementTag("CHUNK_UNLOAD");
            EntityDespawnScriptEvent.instance.cancelled = false;
            EntityDespawnScriptEvent.instance.fire();
            EntityTag.forgetEntity(ent);
            EntityScriptHelper.unlinkEntity(ent);
        }
    }

    public static void reloadEntities() {
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_14)) {
            return;
        }
        entities.clear();
        ConfigurationSection entity_scripts = DenizenAPI.getCurrentInstance().getEntities().getConfigurationSection("entities.scripts");
        if (entity_scripts == null) {
            return;
        }
        for (String Path2 : entity_scripts.getKeys(false)) {
            UUID id = UUID.fromString(Path2);
            String scriptname = entity_scripts.getString(Path2 + ".scriptname");
            entities.put(id, scriptname);
        }
    }

    public static void saveEntities() {
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_14)) {
            return;
        }
        FileConfiguration entityScripts = DenizenAPI.getCurrentInstance().getEntities();
        entityScripts.set("entities.scripts", null);
        for (Map.Entry<UUID, String> entry : entities.entrySet()) {
            entityScripts.set("entities.scripts." + entry.getKey() + ".scriptname", (Object)entry.getValue());
        }
    }

    public static boolean entityHasScript(Entity ent) {
        return EntityScriptHelper.getEntityScript(ent) != null;
    }

    public static String getEntityScript(Entity ent) {
        if (ent == null) {
            return null;
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_14)) {
            if (!DataPersistenceHelper.hasDenizenKey(ent, "entity_script")) {
                return null;
            }
            ObjectTag scriptObject = DataPersistenceHelper.getDenizenKey(ent, "entity_script");
            if (!(scriptObject instanceof ScriptTag)) {
                return null;
            }
            return ((ScriptTag)scriptObject).getName();
        }
        return EntityScriptHelper.getEntityScript(ent.getUniqueId());
    }

    public static String getEntityScript(UUID entID) {
        if (entID == null) {
            return null;
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_14)) {
            return EntityScriptHelper.getEntityScript(Bukkit.getEntity((UUID)entID));
        }
        return entities.get(entID);
    }

    public static void setEntityScript(Entity ent, String script) {
        if (ent == null || ent.getUniqueId() == null || script == null) {
            return;
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_14)) {
            ScriptTag scriptObj = ScriptTag.valueOf(script);
            if (scriptObj == null) {
                Debug.echoError("Can't set entity script to '" + script + "': not a valid script!");
            }
            DataPersistenceHelper.setDenizenKey(ent, "entity_script", scriptObj);
            return;
        }
        entities.put(ent.getUniqueId(), script);
    }

    public static void unlinkEntity(final Entity ent) {
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_14)) {
            return;
        }
        if (ent == null || ent.getUniqueId() == null) {
            return;
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

            @Override
            public void run() {
                entities.remove(ent.getUniqueId());
                FlagManager.clearEntityFlags(new EntityTag(ent));
                EntityBoundingBox.remove(ent.getUniqueId());
            }
        }, 5L);
    }
}

