/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities;

public class TextWidthHelper {
    public static int[] characterWidthMap = new int[128];

    public static void setWidth(int width, String chars) {
        for (char c : chars.toCharArray()) {
            TextWidthHelper.characterWidthMap[c] = width;
        }
    }

    public static int getWidth(char c) {
        return c > '\u007f' ? 6 : characterWidthMap[c];
    }

    public static int getWidth(String str) {
        int total = 0;
        for (char c : str.toCharArray()) {
            total += TextWidthHelper.getWidth(c);
            if (c != '\n') continue;
            total = 0;
        }
        return total;
    }

    public static String splitLines(String str, int width) {
        if (width < 8) {
            return str;
        }
        StringBuilder output = new StringBuilder(str.length() * 2);
        int curLineWidth = 0;
        int lineStart = 0;
        block0: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\n') {
                output.append(str, lineStart, i);
                curLineWidth = 0;
                lineStart = i + 1;
                continue;
            }
            if ((curLineWidth += TextWidthHelper.getWidth(c)) <= width) continue;
            for (int x = i - 1; x > lineStart; --x) {
                char xc = str.charAt(x);
                if (xc != ' ') continue;
                output.append(str, lineStart, x).append("\n");
                curLineWidth = 0;
                lineStart = x + 1;
                i = x;
                continue block0;
            }
            output.append(str, lineStart, i).append("\n");
            curLineWidth = 0;
            lineStart = i;
        }
        output.append(str, lineStart, str.length());
        return output.toString();
    }

    static {
        for (int i = 0; i < 128; ++i) {
            TextWidthHelper.characterWidthMap[i] = 6;
        }
        TextWidthHelper.setWidth(2, "!,.:;|i`");
        TextWidthHelper.setWidth(3, "'l");
        TextWidthHelper.setWidth(4, " []tI");
        TextWidthHelper.setWidth(5, "\"()*<>fk{}");
        TextWidthHelper.setWidth(7, "@~");
    }
}

