/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.blocks;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.interfaces.BlockData;
import com.denizenscript.denizen.nms.util.jnbt.ByteArrayTag;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.IntTag;
import com.denizenscript.denizen.nms.util.jnbt.JNBTListTag;
import com.denizenscript.denizen.nms.util.jnbt.NBTInputStream;
import com.denizenscript.denizen.nms.util.jnbt.NBTOutputStream;
import com.denizenscript.denizen.nms.util.jnbt.NamedTag;
import com.denizenscript.denizen.nms.util.jnbt.ShortTag;
import com.denizenscript.denizen.nms.util.jnbt.StringTag;
import com.denizenscript.denizen.nms.util.jnbt.Tag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.utilities.blocks.CuboidBlockSet;
import com.denizenscript.denizen.utilities.blocks.OldMaterialsHelper;
import com.denizenscript.denizen.utilities.debugging.Debug;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.bukkit.util.BlockVector;

public class MCEditSchematicHelper {
    public static CuboidBlockSet fromMCEditStream(InputStream is) {
        CuboidBlockSet cbs = new CuboidBlockSet();
        try {
            NBTInputStream nbtStream = new NBTInputStream(new GZIPInputStream(is));
            NamedTag rootTag = nbtStream.readNamedTag();
            nbtStream.close();
            if (!rootTag.getName().equals("Schematic")) {
                throw new Exception("Tag 'Schematic' does not exist or is not first!");
            }
            CompoundTag schematicTag = (CompoundTag)rootTag.getTag();
            Object schematic = schematicTag.getValue();
            int width = MCEditSchematicHelper.getChildTag((Map<String, Tag>)schematic, "Width", ShortTag.class).getValue().shortValue();
            int length = MCEditSchematicHelper.getChildTag((Map<String, Tag>)schematic, "Length", ShortTag.class).getValue().shortValue();
            int height = MCEditSchematicHelper.getChildTag((Map<String, Tag>)schematic, "Height", ShortTag.class).getValue().shortValue();
            int originX = 0;
            int originY = 0;
            int originZ = 0;
            try {
                originX = MCEditSchematicHelper.getChildTag((Map<String, Tag>)schematic, "DenizenOriginX", IntTag.class).getValue();
                originY = MCEditSchematicHelper.getChildTag((Map<String, Tag>)schematic, "DenizenOriginY", IntTag.class).getValue();
                originZ = MCEditSchematicHelper.getChildTag((Map<String, Tag>)schematic, "DenizenOriginZ", IntTag.class).getValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            cbs.x_width = width;
            cbs.z_height = length;
            cbs.y_length = height;
            cbs.center_x = originX;
            cbs.center_y = originY;
            cbs.center_z = originZ;
            cbs.blocks = new BlockData[width * length * height];
            String materials = MCEditSchematicHelper.getChildTag((Map<String, Tag>)schematic, "Materials", StringTag.class).getValue();
            if (!materials.equals("Alpha")) {
                throw new Exception("Schematic file is not an Alpha schematic!");
            }
            byte[] blockId = MCEditSchematicHelper.getChildTag((Map<String, Tag>)schematic, "Blocks", ByteArrayTag.class).getValue();
            byte[] blockData = MCEditSchematicHelper.getChildTag((Map<String, Tag>)schematic, "Data", ByteArrayTag.class).getValue();
            byte[] addId = new byte[]{};
            short[] blocks = new short[blockId.length];
            if (schematic.containsKey("AddBlocks")) {
                addId = MCEditSchematicHelper.getChildTag((Map<String, Tag>)schematic, "AddBlocks", ByteArrayTag.class).getValue();
            }
            for (int index = 0; index < blockId.length; ++index) {
                blocks[index] = index >> 1 >= addId.length ? (short)(blockId[index] & 0xFF) : ((index & 1) == 0 ? (short)(((addId[index >> 1] & 0xF) << 8) + (blockId[index] & 0xFF)) : (short)(((addId[index >> 1] & 0xF0) << 4) + (blockId[index] & 0xFF)));
            }
            Object tileEntities = MCEditSchematicHelper.getChildTag((Map<String, Tag>)schematic, "TileEntities", JNBTListTag.class).getValue();
            HashMap tileEntitiesMap = new HashMap();
            Iterator iterator = tileEntities.iterator();
            while (iterator.hasNext()) {
                Tag tag = (Tag)iterator.next();
                if (!(tag instanceof CompoundTag)) continue;
                CompoundTag t = (CompoundTag)tag;
                int x = 0;
                int y = 0;
                int z = 0;
                HashMap values = new HashMap();
                for (Map.Entry entry : t.getValue().entrySet()) {
                    if (((String)entry.getKey()).equals("x")) {
                        if (entry.getValue() instanceof IntTag) {
                            x = ((IntTag)entry.getValue()).getValue();
                        }
                    } else if (((String)entry.getKey()).equals("y")) {
                        if (entry.getValue() instanceof IntTag) {
                            y = ((IntTag)entry.getValue()).getValue();
                        }
                    } else if (((String)entry.getKey()).equals("z") && entry.getValue() instanceof IntTag) {
                        z = ((IntTag)entry.getValue()).getValue();
                    }
                    values.put(entry.getKey(), entry.getValue());
                }
                BlockVector vec = new BlockVector(x, y, z);
                tileEntitiesMap.put(vec, values);
            }
            int finalIndex = 0;
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    for (int z = 0; z < length; ++z) {
                        int index = y * width * length + z * width + x;
                        BlockVector pt = new BlockVector(x, y, z);
                        MaterialTag dMat = OldMaterialsHelper.getMaterialFrom(OldMaterialsHelper.getLegacyMaterial(blocks[index]), blockData[index]);
                        BlockData block = dMat.getNmsBlockData();
                        if (tileEntitiesMap.containsKey(pt)) {
                            CompoundTag otag = NMSHandler.getInstance().createCompoundTag((Map)tileEntitiesMap.get(pt));
                            block.setCompoundTag(otag);
                        }
                        cbs.blocks[finalIndex++] = block;
                    }
                }
            }
        }
        catch (Exception e) {
            Debug.echoError(e);
        }
        return cbs;
    }

    private static <T extends Tag> T getChildTag(Map<String, Tag> items, String key, Class<T> expected) throws Exception {
        if (!items.containsKey(key)) {
            throw new Exception("Schematic file is missing a '" + key + "' tag");
        }
        Tag tag = items.get(key);
        if (!expected.isInstance(tag)) {
            throw new Exception(key + " tag is not of tag type " + expected.getName());
        }
        return (T)((Tag)expected.cast(tag));
    }

    public static void saveMCEditFormatToStream(CuboidBlockSet blockSet, OutputStream os) {
        try {
            HashMap<String, Tag> schematic = new HashMap<String, Tag>();
            schematic.put("Width", new ShortTag((short)blockSet.x_width));
            schematic.put("Length", new ShortTag((short)blockSet.z_height));
            schematic.put("Height", new ShortTag((short)blockSet.y_length));
            schematic.put("Materials", new StringTag("Alpha"));
            schematic.put("DenizenOriginX", new IntTag(blockSet.center_x));
            schematic.put("DenizenOriginY", new IntTag(blockSet.center_y));
            schematic.put("DenizenOriginZ", new IntTag(blockSet.center_z));
            schematic.put("WEOriginX", new IntTag(blockSet.center_x));
            schematic.put("WEOriginY", new IntTag(blockSet.center_y));
            schematic.put("WEOriginZ", new IntTag(blockSet.center_z));
            schematic.put("WEOffsetX", new IntTag(0));
            schematic.put("WEOffsetY", new IntTag(0));
            schematic.put("WEOffsetZ", new IntTag(0));
            byte[] blocks = new byte[blockSet.x_width * blockSet.y_length * blockSet.z_height];
            byte[] addBlocks = null;
            byte[] blockData = new byte[blocks.length];
            ArrayList<CompoundTag> tileEntities = new ArrayList<CompoundTag>();
            int indexer = 0;
            for (int x = 0; x < blockSet.x_width; ++x) {
                for (int y = 0; y < blockSet.y_length; ++y) {
                    for (int z = 0; z < blockSet.z_height; ++z) {
                        int index = y * blockSet.x_width * blockSet.z_height + z * blockSet.x_width + x;
                        BlockData bd = blockSet.blocks[indexer];
                        ++indexer;
                        int matId = NMSHandler.getBlockHelper().idFor(bd.getMaterial());
                        if (matId > 255) {
                            if (addBlocks == null) {
                                addBlocks = new byte[(blocks.length >> 1) + 1];
                            }
                            addBlocks[index >> 1] = (byte)((index & 1) == 0 ? addBlocks[index >> 1] & 0xF0 | matId >> 8 & 0xF : addBlocks[index >> 1] & 0xF | (matId >> 8 & 0xF) << 4);
                        }
                        blocks[index] = (byte)matId;
                        blockData[index] = bd.getData();
                        CompoundTag rawTag = bd.getCompoundTag();
                        if (rawTag == null) continue;
                        HashMap<String, Tag> values = new HashMap<String, Tag>();
                        for (Map.Entry entry : rawTag.getValue().entrySet()) {
                            values.put((String)entry.getKey(), (Tag)entry.getValue());
                        }
                        values.put("x", new IntTag(x));
                        values.put("y", new IntTag(y));
                        values.put("z", new IntTag(z));
                        CompoundTag tileEntityTag = NMSHandler.getInstance().createCompoundTag(values);
                        tileEntities.add(tileEntityTag);
                    }
                }
            }
            schematic.put("Blocks", new ByteArrayTag(blocks));
            schematic.put("Data", new ByteArrayTag(blockData));
            schematic.put("Entities", new JNBTListTag(CompoundTag.class, new ArrayList()));
            schematic.put("TileEntities", new JNBTListTag(CompoundTag.class, tileEntities));
            if (addBlocks != null) {
                schematic.put("AddBlocks", new ByteArrayTag(addBlocks));
            }
            CompoundTag schematicTag = NMSHandler.getInstance().createCompoundTag(schematic);
            NBTOutputStream stream = new NBTOutputStream(new GZIPOutputStream(os));
            stream.writeNamedTag("Schematic", schematicTag);
            os.flush();
            stream.close();
        }
        catch (Exception e) {
            Debug.echoError(e);
        }
    }
}

