/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.inventory;

import com.denizenscript.denizen.utilities.blocks.MaterialCompat;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import java.util.HashMap;
import org.bukkit.Material;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class SlotHelper {
    public static final int BOOTS = 36;
    public static final int LEGGINGS = 37;
    public static final int CHESTPLATE = 38;
    public static final int HELMET = 39;
    public static final int OFFHAND = 40;
    public static final HashMap<String, Integer> nameIndexMap = new HashMap();

    public static int slotForItem(PlayerInventory inventory, ItemStack item) {
        Material type = item.getType();
        if (MaterialCompat.HELMET_MATERIALS.contains(type) && item.equals((Object)inventory.getHelmet())) {
            return 39;
        }
        if (MaterialCompat.CHESTPLATE_MATERIALS.contains(type) && item.equals((Object)inventory.getChestplate())) {
            return 38;
        }
        if (MaterialCompat.LEGGINGS_MATERIALS.contains(type) && item.equals((Object)inventory.getLeggings())) {
            return 37;
        }
        if (MaterialCompat.BOOTS_MATERIALS.contains(type) && item.equals((Object)inventory.getBoots())) {
            return 36;
        }
        if (item.equals((Object)inventory.getItemInMainHand())) {
            return inventory.getHeldItemSlot();
        }
        ItemStack[] contents = inventory.getContents();
        for (int i = 0; i < contents.length; ++i) {
            if (!item.equals((Object)contents[i])) continue;
            return i;
        }
        return -1;
    }

    public static EquipmentSlot indexToEquipSlot(int index) {
        switch (index) {
            case 36: {
                return EquipmentSlot.FEET;
            }
            case 37: {
                return EquipmentSlot.LEGS;
            }
            case 38: {
                return EquipmentSlot.CHEST;
            }
            case 39: {
                return EquipmentSlot.HEAD;
            }
            case 40: {
                return EquipmentSlot.OFF_HAND;
            }
        }
        return null;
    }

    public static int equipSlotToIndex(EquipmentSlot slot) {
        switch (slot) {
            case FEET: {
                return 36;
            }
            case LEGS: {
                return 37;
            }
            case CHEST: {
                return 38;
            }
            case HEAD: {
                return 39;
            }
            case OFF_HAND: {
                return 40;
            }
        }
        return -1;
    }

    public static int nameToIndex(String name) {
        Integer matched;
        if ((name = name.toLowerCase().replace("_", "")).endsWith("s")) {
            name = name.substring(0, name.length() - 1);
        }
        if ((matched = nameIndexMap.get(name)) != null) {
            return matched;
        }
        if (ArgumentHelper.matchesInteger(name)) {
            return Integer.parseInt(name) - 1;
        }
        return -1;
    }

    static {
        nameIndexMap.put("boot", 36);
        nameIndexMap.put("feet", 36);
        nameIndexMap.put("foot", 36);
        nameIndexMap.put("shoe", 36);
        nameIndexMap.put("leg", 37);
        nameIndexMap.put("legging", 37);
        nameIndexMap.put("chest", 38);
        nameIndexMap.put("chestplate", 38);
        nameIndexMap.put("helmet", 39);
        nameIndexMap.put("head", 39);
        nameIndexMap.put("offhand", 40);
    }
}

